/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.cp.dao.MsgCpTemplateMapper;
import com.jxdinfo.hussar.msg.cp.dto.MsgCpTemplateDto;
import com.jxdinfo.hussar.msg.cp.model.MsgCpTemplate;
import com.jxdinfo.hussar.msg.cp.service.MsgCpTemplateService;
import com.jxdinfo.hussar.msg.cp.vo.MsgCpTemplateVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgCpTemplateServiceImpl
extends HussarServiceImpl<MsgCpTemplateMapper, MsgCpTemplate>
implements MsgCpTemplateService {
    @Autowired
    private MsgCpTemplateMapper msgCpTemplateMapper;
    @Autowired
    private IHussarValidateService validateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public ApiResponse<Page<MsgCpTemplateVo>> getList(PageInfo pageInfo, String templateNo, String templateName, String content, Integer openStatus, String messageType) {
        Page msgCpTemplateVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        return ApiResponse.success(this.msgCpTemplateMapper.getListPage((Page<MsgCpTemplateVo>)msgCpTemplateVoPage, SqlQueryUtil.transferSpecialChar((String)templateNo), SqlQueryUtil.transferSpecialChar((String)templateName), SqlQueryUtil.transferSpecialChar((String)content), openStatus, messageType));
    }

    public ApiResponse<MsgCpTemplateVo> listById(Long id) {
        return ApiResponse.success((Object)HussarUtils.copy((Object)super.getById((Serializable)id), MsgCpTemplateVo.class));
    }

    public ApiResponse<List<MsgCpTemplateVo>> getTemplateList() {
        List msgCpTemplateVos = HussarUtils.copy((Collection)super.list((Wrapper)new LambdaQueryWrapper().eq(MsgCpTemplate::getOpenStatus, (Object)OpenStatusEnum.ENABLE.getCode())), MsgCpTemplateVo.class);
        for (MsgCpTemplateVo msgCpTemplateVo : msgCpTemplateVos) {
            String templateParams = msgCpTemplateVo.getTemplateParams();
            if (!HussarUtils.isNotEmpty((Object)templateParams)) continue;
            msgCpTemplateVo.setTemplateParamsList(Arrays.asList(templateParams.split(",")));
        }
        return ApiResponse.success((Object)msgCpTemplateVos);
    }

    @HussarTransactional
    public ApiResponse<Boolean> addTemplate(MsgCpTemplateDto msgCpTemplateDto) {
        String validateMsg = this.validateService.validate((Object)msgCpTemplateDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String templateName = msgCpTemplateDto.getTemplateName();
        long count = super.count((Wrapper)new LambdaQueryWrapper().eq(MsgCpTemplate::getTemplateName, (Object)templateName));
        if (count > 0L) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0" + templateName + "\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
        }
        MsgCpTemplate msgCpTemplate = (MsgCpTemplate)HussarUtils.copy((Object)msgCpTemplateDto, MsgCpTemplate.class);
        msgCpTemplate.setTemplateNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.CP_TEMPLATE));
        msgCpTemplate.setTemplateParams(TemplateUtils.getTemplateParams((String)(msgCpTemplateDto.getContent() + msgCpTemplateDto.getUrl() + msgCpTemplateDto.getTitle())));
        return ApiResponse.success((Object)super.save((BaseEntity)msgCpTemplate));
    }

    @HussarTransactional
    public ApiResponse<Boolean> updateTemplate(MsgCpTemplateDto msgCpTemplateDto) {
        long count;
        String validateMsg = this.validateService.validate((Object)msgCpTemplateDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String templateName = msgCpTemplateDto.getTemplateName();
        MsgCpTemplate msgCpTemplate = (MsgCpTemplate)super.getById((Serializable)msgCpTemplateDto.getId());
        if (!HussarUtils.equals((Object)msgCpTemplate.getTemplateName(), (Object)templateName) && (count = super.count((Wrapper)new LambdaQueryWrapper().eq(MsgCpTemplate::getTemplateName, (Object)templateName))) > 0L) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0" + templateName + "\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
        }
        if (!HussarUtils.equals((Object)msgCpTemplate.getOpenStatus(), (Object)msgCpTemplateDto.getOpenStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(msgCpTemplate.getTemplateNo())))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u65e0\u6cd5\u4fee\u6539\u542f\u52a8\u72b6\u6001\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        HussarUtils.copy((Object)msgCpTemplateDto, (Object)msgCpTemplate);
        msgCpTemplate.setTemplateParams(TemplateUtils.getTemplateParams((String)(msgCpTemplateDto.getContent() + msgCpTemplateDto.getUrl() + msgCpTemplateDto.getTitle())));
        return ApiResponse.success((Object)super.updateById((BaseEntity)msgCpTemplate));
    }

    @HussarTransactional
    public ApiResponse<Boolean> delTemplate(List<Long> ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(ids).stream().map(MsgCpTemplate::getTemplateNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        return ApiResponse.success((Object)super.removeByIds(ids));
    }
}

