/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.contact.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.excel.constants.ExcelConstants;
import com.jxdinfo.hussar.excel.model.ImportSheetMsg;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.excel.util.HussarBaseExcelWriteUtils;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.msg.common.properties.UnifiedMessageProperties;
import com.jxdinfo.hussar.msg.contact.model.MsgContactExcel;
import com.jxdinfo.hussar.msg.contact.model.MsgSupportedSendType;
import com.jxdinfo.hussar.msg.contact.model.MsgTag;
import com.jxdinfo.hussar.msg.contact.service.MsgContactImportService;
import com.jxdinfo.hussar.msg.contact.service.MsgImportBaseUsersService;
import com.jxdinfo.hussar.msg.contact.service.MsgSupportedSendTypeService;
import com.jxdinfo.hussar.msg.contact.service.MsgTagService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.beans.ClassPathResource;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Service
@HussarTokenDs
public class MsgContactImportServiceImpl
implements MsgContactImportService {
    private static final Logger logger = LoggerFactory.getLogger(MsgContactImportServiceImpl.class);
    private final Map<Integer, String> map = new HashMap<Integer, String>();
    @Resource(name="com.jxdinfo.hussar.msg.contact.service.impl.MsgContactCustomExcelServiceImpl")
    private IHussarBaseCustomExcelService hussarBaseCustomExcelService;
    @Resource
    private IHussarBaseExcelService hussarBaseExcelService;
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService iSysExcelTaskService;
    @Resource
    private MsgSupportedSendTypeService msgSupportedSendTypeService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Autowired
    private MsgTagService msgTagService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired
    private IHussarBaseUserBoService sysUsersBoService;
    @Resource
    private ExecutorService hussarBaseSyncExecutor;
    @Autowired
    private MsgImportBaseUsersService msgImportBaseUsersService;
    @Autowired
    private UnifiedMessageProperties messageProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadContactExcelImpTpl(HttpServletResponse response) {
        InputStream inputStream = null;
        try (ServletOutputStream out = response.getOutputStream();){
            String fileName = "";
            response.setContentType("multipart/form-data");
            fileName = URLEncoder.encode("\u8054\u7cfb\u4ebaExcel\u5bfc\u5165\u6a21\u677f.xlsx", "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            ClassPathResource resource = new ClassPathResource((String)ExcelConstants.TemplateMap.get("MsgContactTemplate"));
            inputStream = resource.getStream();
            Workbook workbook = HussarBaseExcelWriteUtils.judegExcelEdition((String)"\u8054\u7cfb\u4ebaExcel\u5bfc\u5165\u6a21\u677f", (InputStream)inputStream);
            Sheet sheet0 = workbook.getSheetAt(0);
            this.configSheetValidation(sheet0, this.getContactTypeList(), 1);
            this.configSheetValidation(sheet0, this.getTagList(), 3);
            this.configSheetValidation(sheet0, this.getMsgSendType(), 4);
            workbook.write((OutputStream)out);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.debug("inputStream close IOException:" + e.getMessage());
                }
            }
        }
    }

    private void configSheetValidation(Sheet sheet, List<String> valueList, int columnIndex) {
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint contactTypeConstraint = helper.createExplicitListConstraint(valueList.toArray(new String[0]));
        CellRangeAddressList contactTypeCellRange = new CellRangeAddressList(2, 200000, columnIndex, columnIndex);
        DataValidation contactTypeValidation = helper.createValidation(contactTypeConstraint, contactTypeCellRange);
        contactTypeValidation.createErrorBox("\u8f93\u5165\u6709\u8bef", "\u8bf7\u9009\u62e9\u4e0b\u62c9\u53c2\u6570");
        if (contactTypeValidation instanceof XSSFDataValidation) {
            contactTypeValidation.setSuppressDropDownArrow(true);
            contactTypeValidation.setShowErrorBox(true);
        } else {
            contactTypeValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(contactTypeValidation);
    }

    public void checkContactExcel(MultipartFile file, String scenario, Long taskId) {
        InputStream input;
        try {
            input = file.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String fileName = file.getOriginalFilename();
        ApiResponse fileResponse = this.ossService.backgroundUpload(file);
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setFileName(fileName);
        task.setCheckScenario(scenario);
        task.setTaskFile((Long)fileResponse.getData());
        this.iSysExcelTaskService.updateById((Object)task);
        String connName = HussarContextHolder.getConnName();
        String tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)new HussarHttpServletRequest(servletRequestAttributes.getRequest()));
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
            HussarContextHolder.setTenant((String)connName, (String)tenantCode);
            ImportSheetMsg importSheetMsg1 = new ImportSheetMsg(Integer.valueOf(0), MsgContactExcel.class, this.hussarBaseCustomExcelService);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg1);
            HashMap<Integer, List<String>> selectParamMap = new HashMap<Integer, List<String>>();
            selectParamMap.put(1, this.getContactTypeList());
            selectParamMap.put(3, this.getTagList());
            selectParamMap.put(4, this.getMsgSendType());
            this.hussarBaseExcelService.checkExcelSheets(input, importSheetMsgs, scenario, taskId, new HashMap(), selectParamMap);
        });
    }

    public void importContactExcel(String scenario, Long taskId) {
        String connName = HussarContextHolder.getConnName();
        String tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)new HussarHttpServletRequest(servletRequestAttributes.getRequest()));
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
            HussarContextHolder.setTenant((String)connName, (String)tenantCode);
            ImportSheetMsg importSheetMsg = new ImportSheetMsg(Integer.valueOf(0), MsgContactExcel.class, this.hussarBaseCustomExcelService);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg);
            this.hussarBaseExcelService.importExcelSheets(importSheetMsgs, scenario, taskId, new HashMap());
        });
    }

    public ApiResponse<Boolean> syncMsgContact(List<String> userNames) {
        this.map.clear();
        SecurityUser loginUser = BaseSecurityUtil.getUser();
        Long loginId = loginUser == null ? null : loginUser.getId();
        CompletableFuture.runAsync(() -> this.executeSyncMsgContact(loginId), this.hussarBaseSyncExecutor);
        return ApiResponse.success();
    }

    public ApiResponse<Map<Integer, String>> syncMsgContactStatus() {
        return ApiResponse.success(this.map);
    }

    private void executeSyncMsgContact(long loginId) {
        int successNum = 0;
        try {
            List allUsers = this.sysUsersBoService.list();
            Integer batchSize = this.messageProperties.getSyncBaseUserBatchSize();
            for (int i = 0; i < allUsers.size(); i += batchSize.intValue()) {
                List subList = allUsers.subList(i, Math.min(i + batchSize, allUsers.size()));
                this.msgImportBaseUsersService.importBaseUsers(subList, Long.valueOf(loginId));
                successNum += subList.size();
                logger.info("\u6210\u529f\u540c\u6b65Base\u7528\u6237 {} \u6761", (Object)subList.size());
            }
            this.map.put(1, "\u540c\u6b65\u6210\u529f");
        }
        catch (Exception e) {
            if (successNum > 0) {
                this.map.put(2, String.format("\u540c\u6b65\u6210\u529f %d \u6761\uff0c\u5269\u4f59\u6570\u636e\u540c\u6b65\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", successNum, e.getMessage()));
            } else {
                this.map.put(2, "\u540c\u6b65\u5931\u8d25\uff0c" + e.getMessage());
            }
            throw e;
        }
    }

    private List<String> getMsgSendType() {
        List sendTypes = this.msgSupportedSendTypeService.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{MsgSupportedSendType::getSendTypeName}).eq(MsgSupportedSendType::getNeedFrontDisplay, (Object)true));
        return sendTypes.stream().map(MsgSupportedSendType::getSendTypeName).distinct().collect(Collectors.toList());
    }

    private List<String> getContactTypeList() {
        List msgContactType = this.sysDicRefService.getDicListByType("msg_contact_type");
        return msgContactType.stream().map(DicVo::getLabel).distinct().collect(Collectors.toList());
    }

    private List<String> getTagList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("default");
        List tagList = this.msgTagService.list().stream().map(MsgTag::getTagName).collect(Collectors.toList());
        list.addAll(tagList);
        return list;
    }

    private void setSheetByList(Sheet sheet, List<String> list, int startCol, int startRow) {
        for (int i = 0; i < list.size(); ++i) {
            int i1 = i + startRow;
            Row row = sheet.getRow(i1);
            if (HussarUtils.isEmpty((Object)row)) {
                row = sheet.createRow(i1);
            }
            String organType = list.get(i);
            row.createCell(startCol).setCellValue(organType);
        }
    }

    static {
        ExcelConstants.TemplateMap.put("MsgContactTemplate", "static/MsgContactTemplate.xlsx");
    }
}

