/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.contact.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.excel.builder.ConcreteExcelBuilder;
import com.jxdinfo.hussar.excel.builder.ExcelProduct;
import com.jxdinfo.hussar.excel.model.ClassSheetMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.msg.contact.model.MsgContactExcel;
import com.jxdinfo.hussar.msg.contact.model.MsgContactInfo;
import com.jxdinfo.hussar.msg.contact.service.MsgContactExportService;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class MsgContactExportServiceImpl
implements MsgContactExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MsgContactExportServiceImpl.class);
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired
    private ISysExcelTaskService sysExcelTaskService;
    @Autowired
    private ExecutorService hussarBaseExcelExecutor;
    @Resource
    private IHussarBaseExcelService hussarBaseExcelService;

    public void exportMsgContactExcel(String ids, Long taskId) {
        AssertUtil.isNotEmpty((String)StringUtil.trimToEmpty((CharSequence)ids), (String)"\u53c2\u6570\u4e3a\u7a7a");
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        List msgContactInfos = this.msgContactInfoService.list((Wrapper)new LambdaQueryWrapper().in(MsgContactInfo::getId, (Object[])ids.split(",")));
        if (msgContactInfos.isEmpty()) {
            throw new BaseException("\u5bfc\u51fa\u6570\u636e\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        ArrayList contactExcels = new ArrayList();
        msgContactInfos.forEach(msgContactInfo -> {
            MsgContactExcel msgContactExcel = new MsgContactExcel();
            BeanUtil.copy((Object)msgContactInfo, (Object)msgContactExcel);
            contactExcels.add(msgContactExcel);
        });
        String connName = HussarContextHolder.getConnName();
        String tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)new HussarHttpServletRequest(servletRequestAttributes.getRequest()));
        CompletableFuture.runAsync(() -> {
            RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
            HussarContextHolder.setTenant((String)connName, (String)tenantCode);
            ClassSheetMsg classSheetMsg = new ClassSheetMsg(MsgContactExcel.class, contactExcels, "\u8054\u7cfb\u4eba\u5bfc\u51fa\u4fe1\u606f", 0);
            try {
                ExcelProduct excelProduct = new ConcreteExcelBuilder("\u8054\u7cfb\u4eba\u5bfc\u51fa\u4fe1\u606f" + Java8DateUtils.getCurrentDateDTimeStr() + ".xlsx", taskId, this.hussarBaseExcelService).makeClassSheet(classSheetMsg).buildExcelProduct();
                this.sysExcelTaskService.updateById((Object)excelProduct.getTask());
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }, this.hussarBaseExcelExecutor);
    }
}

