/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordDto;
import com.jxdinfo.hussar.msg.apppush.model.AppPushChannel;
import com.jxdinfo.hussar.msg.apppush.model.MsgAppPushTemplate;
import com.jxdinfo.hussar.msg.apppush.service.AppPushChannelService;
import com.jxdinfo.hussar.msg.apppush.service.AppPushSendRecordService;
import com.jxdinfo.hussar.msg.apppush.service.MsgAppPushSendAsyncService;
import com.jxdinfo.hussar.msg.apppush.service.MsgAppPushTemplateService;
import com.jxdinfo.hussar.msg.apppush.third.service.AppPushThirdService;
import com.jxdinfo.hussar.msg.common.enums.AudienceTypeEnum;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.utils.PrintPushLogsUtils;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.factory.MsgUnitySendFactory;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.model.MsgBasicSendRecord;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class AppPushUnitySendServiceImpl
implements MsgUnitySendFrameService,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppPushUnitySendServiceImpl.class);
    @Autowired
    private MsgAppPushSendAsyncService msgAppPushSendAsyncService;
    @Autowired
    private MsgAppPushTemplateService msgAppPushTemplateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppPushChannelService appPushChannelService;
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired(required=false)
    private AppPushThirdService appPushThirdService;
    @Autowired
    private AppPushSendRecordService appPushSendRecordService;

    public MsgBasicSendRecord msgUnitySendBefore(MsgUnitySendDto msgUnitySendDto) {
        AppPushSendRecordDto appPushSendRecordDto = new AppPushSendRecordDto();
        try {
            Object incompleteTemplateParams = msgUnitySendDto.getExtendParams("app_push");
            if (HussarUtils.isEmpty((Object)incompleteTemplateParams)) {
                throw new BaseException("appPush\u63a8\u9001incompleteTemplateParams\u4e3a\u7a7a");
            }
            appPushSendRecordDto = (AppPushSendRecordDto)JSON.parseObject((String)JSON.toJSONString((Object)incompleteTemplateParams), AppPushSendRecordDto.class);
            AppSceneConfig appSceneConfig = (AppSceneConfig)this.appSceneConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)msgUnitySendDto.getSceneCode()));
            String sceneCode = appSceneConfig.getSceneCode();
            Long appAccessId = appSceneConfig.getAppPkId();
            appPushSendRecordDto.setSceneName(appSceneConfig.getSceneName());
            appPushSendRecordDto.setSceneCode(sceneCode);
            AppAccess appAccess = (AppAccess)this.appAccessService.getById((Serializable)appAccessId);
            appPushSendRecordDto.setMsgAppId(appAccess.getAppId());
            appPushSendRecordDto.setMsgAppName(appAccess.getAppName());
            ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(sceneCode, appAccessId.toString(), ServiceTypeEnum.APP_PUSH.getCode());
            String templateNo = configJsonData.getTemplateNo();
            MsgAppPushTemplate msgAppPushTemplate = (MsgAppPushTemplate)this.msgAppPushTemplateService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgAppPushTemplate::getTemplateNo, (Object)templateNo));
            AppPushChannel appPushChannel = (AppPushChannel)this.appPushChannelService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppPushChannel::getChannelNo, (Object)configJsonData.getChannelNo()));
            HussarUtils.copy((Object)appPushChannel, (Object)appPushSendRecordDto);
            HussarUtils.copy((Object)msgAppPushTemplate, (Object)appPushSendRecordDto);
            appPushSendRecordDto.setAppPushParams(TemplateUtils.getCurrentTemplateParams((Map)msgUnitySendDto.getTemplateParams(), (String)msgAppPushTemplate.getTemplateParams()));
            this.replaceContent(appPushSendRecordDto);
            appPushSendRecordDto.setStatus(Integer.valueOf(1));
            appPushSendRecordDto.setTenantCode(msgUnitySendDto.getTenantCode());
            ArrayList errorContactInfos = new ArrayList();
            List receiveAddress = this.msgContactInfoService.getReceiveAddress(msgUnitySendDto, ServiceTypeEnum.APP_PUSH.getCode(), appSceneConfig, errorContactInfos);
            if (AudienceTypeEnum.TOKEN.getCode().equals(appPushSendRecordDto.getAudienceType()) && HussarUtils.isEmpty((Object)receiveAddress)) {
                this.saveFailRecord(appPushSendRecordDto, new RuntimeException("\u65e0\u53ef\u7528\u8054\u7cfb\u5730\u5740\uff01" + (HussarUtils.isNotEmpty(errorContactInfos) ? "\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", errorContactInfos) : "")));
                return null;
            }
            appPushSendRecordDto.setTokenList(receiveAddress);
            PrintPushLogsUtils.printPushReceiveLogs((List)receiveAddress, (String)ServiceTypeEnum.APP_PUSH.getCode(), (Logger)LOGGER);
            appPushSendRecordDto.setErrorContactInfos(errorContactInfos);
        }
        catch (Exception e) {
            this.saveFailRecord(appPushSendRecordDto, e);
            throw e;
        }
        this.appPushThirdService.sendPushTimMsg(appPushSendRecordDto);
        return null;
    }

    public String getMsgSendType() {
        return null;
    }

    public boolean msgUnityThirdSend(MsgBasicSendRecord msgBasicSendRecord) {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        MsgUnitySendFactory.setSendBeansToMap("app_push", this);
    }

    private void replaceContent(AppPushSendRecordDto appPushSendRecordDto) {
        String title = appPushSendRecordDto.getTitle();
        String content = appPushSendRecordDto.getContent();
        Map appPushParams = appPushSendRecordDto.getAppPushParams();
        if (HussarUtils.isNotEmpty((Object)appPushParams)) {
            appPushSendRecordDto.setTitle(TemplateUtils.replaceParams((String)title, (Map)appPushParams));
            appPushSendRecordDto.setContent(TemplateUtils.replaceParams((String)content, (Map)appPushParams));
        }
    }

    private void saveFailRecord(AppPushSendRecordDto appPushSendRecordDto, Exception e) {
        Date now = new Date();
        if (HussarUtils.isEmpty((Object)appPushSendRecordDto.getChannelNo())) {
            appPushSendRecordDto.setChannelNo("null");
            appPushSendRecordDto.setChannelName("\u65e0\u901a\u9053\u6807\u8bc6\u8bb0\u5f55");
        }
        appPushSendRecordDto.setId(null);
        appPushSendRecordDto.setSendTime(now);
        appPushSendRecordDto.setCreateTime(now);
        appPushSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        appPushSendRecordDto.setStatus(SendStatusEnum.FAIL.getCode());
        appPushSendRecordDto.setErrMsg("\u7ec4\u88c5\u53d1\u9001\u53c2\u6570\u53d1\u751f\u5f02\u5e38\uff1a" + (HussarUtils.isNotEmpty((Object)e.getMessage()) ? e.getMessage() : e.getClass().getName()));
        this.appPushSendRecordService.saveRecord(appPushSendRecordDto);
    }
}

