/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordCreateDto;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordDto;
import com.jxdinfo.hussar.msg.apppush.model.AppPushChannel;
import com.jxdinfo.hussar.msg.apppush.model.MsgAppPushTemplate;
import com.jxdinfo.hussar.msg.apppush.service.AppPushChannelService;
import com.jxdinfo.hussar.msg.apppush.service.AppPushSendService;
import com.jxdinfo.hussar.msg.apppush.service.MsgAppPushSendAsyncService;
import com.jxdinfo.hussar.msg.apppush.service.MsgAppPushTemplateService;
import com.jxdinfo.hussar.msg.apppush.third.service.AppPushThirdService;
import com.jxdinfo.hussar.msg.common.enums.AppEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.model.SendRecordTenant;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class AppPushSendServiceImpl
implements AppPushSendService {
    @Autowired
    private AppPushChannelService msgAppChannelService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired(required=false)
    private AppPushThirdService appPushThirdService;
    @Autowired
    private MsgAppPushSendAsyncService msgAppPushSendAsyncService;
    @Autowired
    private MsgAppPushTemplateService msgAppPushTemplateService;

    public boolean sendMsgAppMq(AppPushSendRecordCreateDto createDto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(createDto.getAppId(), createDto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(createDto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.APP_PUSH.getCode());
        AppPushChannel appPushChannel = this.getAppChannel(createDto.getChannelId(), configJsonData.getChannelNo());
        AppPushSendRecordDto appPushSendRecord = new AppPushSendRecordDto();
        appPushSendRecord.setChannelId(createDto.getChannelId());
        appPushSendRecord.setChannelNo(appPushChannel.getChannelNo());
        appPushSendRecord.setSceneCode(createDto.getSceneCode());
        appPushSendRecord.setSceneName(configJsonData.getSceneName());
        appPushSendRecord.setChannelName(appPushChannel.getChannelName());
        appPushSendRecord.setTitle(createDto.getTitle());
        appPushSendRecord.setAudienceType(createDto.getAudienceType());
        appPushSendRecord.setPlatform(createDto.getPlatform());
        appPushSendRecord.setContent(createDto.getContent());
        appPushSendRecord.setAngleMark(createDto.getAngleMark());
        appPushSendRecord.setActionType(createDto.getActionType());
        appPushSendRecord.setActivity(createDto.getActivity());
        appPushSendRecord.setActionAddress(createDto.getActionAddress());
        appPushSendRecord.setUrl(createDto.getUrl());
        appPushSendRecord.setIntent(createDto.getIntent());
        appPushSendRecord.setTokenList(createDto.getTokenList());
        appPushSendRecord.setAppId(appPushChannel.getAppId());
        appPushSendRecord.setAssessId(appPushChannel.getAssessId());
        appPushSendRecord.setSecretKey(appPushChannel.getSecretKey());
        appPushSendRecord.setTim(createDto.getTim());
        appPushSendRecord.setJobTime(createDto.getJobTime());
        appPushSendRecord.setStatus(SendStatusEnum.SENDING.getCode());
        appPushSendRecord.setMsgAppId(createDto.getAppId());
        appPushSendRecord.setMsgAppName(appAccess.getAppName());
        appPushSendRecord.setMsgAppSecret(createDto.getAppSecret());
        TenantCodeUtils.fillTenantCode((SendRecordTenant)appPushSendRecord);
        return this.msgAppPushSendAsyncService.sendAppPushAsyncMsg(appPushSendRecord);
    }

    public boolean testSend(AppPushSendRecordCreateDto createDto) {
        AppPushChannel appPushChannel = this.getAppChannel(createDto.getChannelId(), createDto.getChannelNo());
        AppPushSendRecordDto appPushSendRecordDto = new AppPushSendRecordDto();
        appPushSendRecordDto.setChannelId(createDto.getChannelId());
        appPushSendRecordDto.setChannelNo(appPushChannel.getChannelNo());
        appPushSendRecordDto.setChannelName(appPushChannel.getChannelName());
        appPushSendRecordDto.setTitle(createDto.getTitle());
        appPushSendRecordDto.setAudienceType(createDto.getAudienceType());
        appPushSendRecordDto.setPlatform(createDto.getPlatform());
        appPushSendRecordDto.setContent(createDto.getContent());
        appPushSendRecordDto.setAngleMark(createDto.getAngleMark());
        appPushSendRecordDto.setActionType(createDto.getActionType());
        appPushSendRecordDto.setActivity(createDto.getActivity());
        appPushSendRecordDto.setActionAddress(createDto.getActionAddress());
        appPushSendRecordDto.setUrl(createDto.getUrl());
        appPushSendRecordDto.setIntent(createDto.getIntent());
        appPushSendRecordDto.setTokenList(createDto.getTokenList());
        appPushSendRecordDto.setAppId(appPushChannel.getAppId());
        appPushSendRecordDto.setAssessId(appPushChannel.getAssessId());
        appPushSendRecordDto.setSecretKey(appPushChannel.getSecretKey());
        appPushSendRecordDto.setTim(createDto.getTim());
        appPushSendRecordDto.setJobTime(createDto.getJobTime());
        Long templateId = createDto.getTemplateId();
        if (HussarUtils.isNotEmpty((Object)templateId)) {
            Map appPushParams = createDto.getAppPushParams();
            MsgAppPushTemplate msgAppPushTemplate = (MsgAppPushTemplate)this.msgAppPushTemplateService.getById((Serializable)templateId);
            HussarUtils.copy((Object)msgAppPushTemplate, (Object)appPushSendRecordDto);
            appPushSendRecordDto.setAppPushParams(appPushParams);
            appPushSendRecordDto.setTitle(TemplateUtils.replaceParams((String)appPushSendRecordDto.getTitle(), (Map)appPushParams));
            appPushSendRecordDto.setContent(TemplateUtils.replaceParams((String)appPushSendRecordDto.getContent(), (Map)appPushParams));
        }
        appPushSendRecordDto.setMsgAppId(AppEnum.TEST.getAppId());
        appPushSendRecordDto.setMsgAppName(AppEnum.TEST.getAppName());
        appPushSendRecordDto.setMsgAppSecret(AppEnum.TEST.getAppSecret());
        appPushSendRecordDto.setSceneName(AppEnum.TEST.getSceneName());
        appPushSendRecordDto.setSceneCode(AppEnum.TEST.getSceneCode());
        appPushSendRecordDto.setTenantCode(createDto.getTenantCode());
        return this.appPushThirdService.sendPushTimMsg(appPushSendRecordDto);
    }

    private AppPushChannel getAppChannel(Long channelId, String channelNo) {
        AppPushChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(AppPushChannel::getId, (Object)channelId);
        }
        if (HussarUtils.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(AppPushChannel::getChannelNo, (Object)channelNo);
        }
        if ((channel = (AppPushChannel)this.msgAppChannelService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }
}

