/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.appim.thrid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordDto;
import com.jxdinfo.hussar.msg.appim.service.AppImChannelService;
import com.jxdinfo.hussar.msg.appim.service.AppImSendRecordService;
import com.jxdinfo.hussar.msg.appim.third.service.AppImPushThirdService;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.mp.im.model.ArticleBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.FileMsgBean;
import com.jxdinfo.mp.im.model.ImgMsgBean;
import com.jxdinfo.mp.push.service.PushService;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AppImPushThirdServiceImpl
implements AppImPushThirdService {
    private static final Logger logger = LoggerFactory.getLogger(AppImPushThirdServiceImpl.class);
    private PushService pushService = new PushService();
    @Resource
    private OssService ossService;
    @Autowired
    private AppImChannelService appImChannelService;
    @Autowired
    private AppImSendRecordService appImSendRecordService;
    @Autowired
    private MsgJobService msgJobService;

    public boolean thirdSendAppIm(AppImSendRecordDto appImSendRecordDto) {
        appImSendRecordDto.setId(null);
        if (HussarUtils.isEmpty((Object)appImSendRecordDto.getMessageType()) || "text".equals(appImSendRecordDto.getMessageType())) {
            return this.sendTextTimMsg(appImSendRecordDto);
        }
        if ("textcard".equals(appImSendRecordDto.getMessageType())) {
            return this.sendArticleTimMsg(appImSendRecordDto);
        }
        return true;
    }

    public boolean sendTextTimMsg(AppImSendRecordDto recordDto) {
        List userIds = recordDto.getUserIds();
        boolean flag = true;
        if (recordDto.getTim() != null && recordDto.getTim().booleanValue()) {
            this.msgJobService.saveMsgJob(recordDto.getJobTime(), JSONObject.toJSONString((Object)recordDto), MsgJobEnum.MSG_APPIM_TEXT);
            recordDto.setStatus(SendStatusEnum.SENDING.getCode());
            Date now = new Date();
            recordDto.setSendTime(recordDto.getJobTime());
            recordDto.setCreateTime(now);
            recordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appImSendRecordService.saveRecord(recordDto);
        } else {
            if (!this.sendTextThird(recordDto, userIds)) {
                flag = false;
            }
            Date now = new Date();
            recordDto.setSendTime(now);
            recordDto.setCreateTime(now);
            recordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appImSendRecordService.saveRecord(recordDto);
        }
        return flag;
    }

    public void jobSendTextMsg(AppImSendRecordDto recordDto) {
        AppImSendRecordDto appImSendRecordDto = this.appImSendRecordService.findById(recordDto.getId());
        if (HussarUtils.isNotEmpty((Object)appImSendRecordDto.getId())) {
            this.sendTextThird(appImSendRecordDto, appImSendRecordDto.getUserIds());
            appImSendRecordDto.setSendTime(new Date());
            this.appImSendRecordService.saveRecord(appImSendRecordDto);
        }
    }

    private boolean sendTextThird(AppImSendRecordDto recordDto, List<String> userIds) {
        boolean flag = true;
        try {
            flag = this.pushService.postMessage((BaseMsgBean)this.pushService.buildTextMsgBean(recordDto.getContent(), BaseMsgBean.Mode.PUBPLAT, recordDto.getPubId(), recordDto.getPubName()), userIds, recordDto.getPubId(), recordDto.getPubPassword(), recordDto.getCompanyId(), recordDto.getCompanyName(), recordDto.getServer());
            if (flag) {
                recordDto.setStatus(SendStatusEnum.SUCCESS.getCode());
                recordDto.setErrMsg(SendStatusEnum.SUCCESS.getName());
            } else {
                recordDto.setStatus(SendStatusEnum.FAIL.getCode());
            }
        }
        catch (Exception e) {
            logger.error("AppIm\u6587\u672c\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            recordDto.setStatus(SendStatusEnum.FAIL.getCode());
            flag = false;
            recordDto.setErrMsg(e.getMessage());
        }
        return flag;
    }

    public boolean sendArticleTimMsg(AppImSendRecordDto recordDto) {
        boolean flag = true;
        if (recordDto.getTim() != null && recordDto.getTim().booleanValue()) {
            this.msgJobService.saveMsgJob(recordDto.getJobTime(), JSONObject.toJSONString((Object)recordDto), MsgJobEnum.MSG_APPIM_ARTICLE);
            recordDto.setStatus(SendStatusEnum.SENDING.getCode());
            Date now = new Date();
            recordDto.setSendTime(recordDto.getJobTime());
            recordDto.setCreateTime(now);
            recordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appImSendRecordService.saveRecord(recordDto);
        } else {
            List userIds;
            JSONObject jsonObject = new JSONObject();
            if (HussarUtils.isEmpty((Object)recordDto.getMessageType())) {
                jsonObject = JSONObject.parseObject((String)recordDto.getContent());
            }
            if (!this.sendArticleThird(recordDto, jsonObject, userIds = recordDto.getUserIds())) {
                flag = false;
            }
            Date now = new Date();
            recordDto.setUserIds(userIds);
            recordDto.setCreateTime(now);
            recordDto.setSendTime(now);
            recordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appImSendRecordService.saveRecord(recordDto);
        }
        return flag;
    }

    public void jobSendArticleMsg(AppImSendRecordDto recordDto) {
        AppImSendRecordDto appImSendRecordDto = this.appImSendRecordService.findById(recordDto.getId());
        if (HussarUtils.isNotEmpty((Object)appImSendRecordDto.getId())) {
            JSONObject jsonObject = JSONObject.parseObject((String)appImSendRecordDto.getContent());
            this.sendArticleThird(appImSendRecordDto, jsonObject, recordDto.getUserIds());
            appImSendRecordDto.setSendTime(new Date());
            this.appImSendRecordService.saveRecord(appImSendRecordDto);
        }
    }

    private boolean sendArticleThird(AppImSendRecordDto recordDto, JSONObject jsonObject, List<String> userIds) {
        String title = recordDto.getTitle();
        String subTitle = recordDto.getContent();
        String url = recordDto.getUrl();
        String filePath = "";
        if (HussarUtils.isEmpty((Object)recordDto.getMessageType())) {
            title = jsonObject.getString("title");
            subTitle = jsonObject.getString("subTitle");
            url = jsonObject.getString("url");
            filePath = jsonObject.getString("filePath");
        }
        boolean flag = true;
        ArticleBean.LinkType type = ArticleBean.LinkType.WEB;
        try {
            ArticleBean articleBean = this.pushService.buildArticle(title, subTitle, HussarUtils.isNotEmpty((Object)filePath) ? new File(filePath) : null, url, type, null, null);
            flag = this.pushService.postMessage((BaseMsgBean)this.pushService.buildArticleMsgBean(Collections.singletonList(articleBean), BaseMsgBean.Mode.PUBPLAT, recordDto.getPubId(), recordDto.getPubName()), userIds, recordDto.getPubId(), recordDto.getPubPassword(), recordDto.getCompanyId(), recordDto.getCompanyName(), recordDto.getServer());
            if (flag) {
                recordDto.setStatus(SendStatusEnum.SUCCESS.getCode());
                recordDto.setErrMsg(SendStatusEnum.SUCCESS.getName());
            } else {
                recordDto.setStatus(SendStatusEnum.FAIL.getCode());
            }
        }
        catch (Exception e) {
            logger.error("AppIm\u56fe\u6587\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            recordDto.setStatus(SendStatusEnum.FAIL.getCode());
            flag = false;
            recordDto.setErrMsg(e.getMessage());
        }
        return flag;
    }

    public boolean sendImgTimMsg(AppImSendRecordDto recordDto) {
        boolean flag = true;
        if (recordDto.getTim() != null && recordDto.getTim().booleanValue()) {
            this.msgJobService.saveMsgJob(recordDto.getJobTime(), JSONObject.toJSONString((Object)recordDto), MsgJobEnum.MSG_APPIM_IMG);
            recordDto.setStatus(SendStatusEnum.SENDING.getCode());
            Date now = new Date();
            recordDto.setSendTime(recordDto.getJobTime());
            recordDto.setCreateTime(now);
            recordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appImSendRecordService.saveRecord(recordDto);
        } else {
            List userIds = recordDto.getUserIds();
            JSONObject jsonObject = JSONObject.parseObject((String)recordDto.getContent());
            String filePath = jsonObject.getString("filePath");
            if (!this.sendImgThird(recordDto, filePath, userIds)) {
                flag = false;
            }
            Date now = new Date();
            recordDto.setUserIds(userIds);
            recordDto.setCreateTime(now);
            recordDto.setSendTime(now);
            recordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appImSendRecordService.saveRecord(recordDto);
        }
        return flag;
    }

    public void jobSendImgMsg(AppImSendRecordDto recordDto) {
        AppImSendRecordDto appImSendRecordDto = this.appImSendRecordService.findById(recordDto.getId());
        if (HussarUtils.isNotEmpty((Object)appImSendRecordDto.getId())) {
            JSONObject jsonObject = JSONObject.parseObject((String)appImSendRecordDto.getContent());
            String filePath = jsonObject.getString("filePath");
            this.sendImgThird(appImSendRecordDto, filePath, recordDto.getUserIds());
            appImSendRecordDto.setSendTime(new Date());
            this.appImSendRecordService.saveRecord(appImSendRecordDto);
        }
    }

    private boolean sendImgThird(AppImSendRecordDto recordDto, String filePath, List<String> userIds) {
        boolean flag = true;
        try {
            ImgMsgBean articleBean = this.pushService.buildImgMsgBean(new File(filePath), BaseMsgBean.Mode.PUBPLAT, recordDto.getPubId(), recordDto.getPubName());
            flag = this.pushService.postMessage((BaseMsgBean)articleBean, userIds, recordDto.getPubId(), recordDto.getPubPassword(), recordDto.getCompanyId(), recordDto.getCompanyName(), recordDto.getServer());
            if (flag) {
                recordDto.setStatus(SendStatusEnum.SUCCESS.getCode());
                recordDto.setErrMsg(SendStatusEnum.SUCCESS.getName());
            } else {
                recordDto.setStatus(SendStatusEnum.FAIL.getCode());
            }
        }
        catch (Exception e) {
            logger.error("AppIm\u56fe\u7247\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            recordDto.setStatus(SendStatusEnum.FAIL.getCode());
            flag = false;
            recordDto.setErrMsg(e.getMessage());
        }
        return flag;
    }

    public boolean sendFileTimMsg(AppImSendRecordDto recordDto) {
        boolean flag = true;
        if (recordDto.getTim() != null && recordDto.getTim().booleanValue()) {
            this.msgJobService.saveMsgJob(recordDto.getJobTime(), JSONObject.toJSONString((Object)recordDto), MsgJobEnum.MSG_APPIM_FILE);
            recordDto.setStatus(SendStatusEnum.SENDING.getCode());
            Date now = new Date();
            recordDto.setSendTime(recordDto.getJobTime());
            recordDto.setCreateTime(now);
            recordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appImSendRecordService.saveRecord(recordDto);
        } else {
            List userIds = recordDto.getUserIds();
            JSONObject jsonObject = JSONObject.parseObject((String)recordDto.getContent());
            String filePath = jsonObject.getString("filePath");
            if (!this.sendFileThird(recordDto, filePath, userIds)) {
                flag = false;
            }
            recordDto.setUserIds(userIds);
            Date now = new Date();
            recordDto.setCreateTime(now);
            recordDto.setSendTime(now);
            recordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appImSendRecordService.saveRecord(recordDto);
        }
        return flag;
    }

    public void jobSendFileMsg(AppImSendRecordDto recordDto) {
        AppImSendRecordDto appImSendRecordDto = this.appImSendRecordService.findById(recordDto.getId());
        if (HussarUtils.isNotEmpty((Object)appImSendRecordDto.getId())) {
            JSONObject jsonObject = JSONObject.parseObject((String)appImSendRecordDto.getContent());
            String filePath = jsonObject.getString("filePath");
            this.sendFileThird(appImSendRecordDto, filePath, recordDto.getUserIds());
            appImSendRecordDto.setSendTime(new Date());
            this.appImSendRecordService.saveRecord(appImSendRecordDto);
        }
    }

    private boolean sendFileThird(AppImSendRecordDto recordDto, String filePath, List<String> userIds) {
        boolean flag = true;
        try {
            FileMsgBean articleBean = this.pushService.buildFileMsgBean(new File(filePath), BaseMsgBean.Mode.PUBPLAT, recordDto.getPubId(), recordDto.getPubName());
            flag = this.pushService.postMessage((BaseMsgBean)articleBean, userIds, recordDto.getPubId(), recordDto.getPubPassword(), recordDto.getCompanyId(), recordDto.getCompanyName(), recordDto.getServer());
            if (flag) {
                recordDto.setStatus(SendStatusEnum.SUCCESS.getCode());
                recordDto.setErrMsg(SendStatusEnum.SUCCESS.getName());
            } else {
                recordDto.setStatus(SendStatusEnum.FAIL.getCode());
            }
        }
        catch (Exception e) {
            logger.error("AppIm\u6587\u4ef6\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            recordDto.setStatus(SendStatusEnum.FAIL.getCode());
            flag = false;
            recordDto.setErrMsg(e.getMessage());
        }
        return flag;
    }
}

