/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.appim.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendArticleCreateDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendFileCreateDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendImgCreateDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendTextCreateDto;
import com.jxdinfo.hussar.msg.appim.dto.MsgAppImTestSendDto;
import com.jxdinfo.hussar.msg.appim.model.AppImChannel;
import com.jxdinfo.hussar.msg.appim.model.MsgAppImTemplate;
import com.jxdinfo.hussar.msg.appim.service.AppImChannelService;
import com.jxdinfo.hussar.msg.appim.service.AppImSendService;
import com.jxdinfo.hussar.msg.appim.service.MsgAppImSendAsyncService;
import com.jxdinfo.hussar.msg.appim.service.MsgAppImTemplateService;
import com.jxdinfo.hussar.msg.appim.third.service.AppImPushThirdService;
import com.jxdinfo.hussar.msg.common.enums.AppEnum;
import com.jxdinfo.hussar.msg.common.enums.AppImMsgTypeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.model.SendRecordTenant;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AppImSendServiceImpl
implements AppImSendService {
    @Autowired
    private AppImChannelService appImChannelService;
    @Autowired
    private OssService ossService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired(required=false)
    private AppImPushThirdService appImPushThirdService;
    @Autowired
    private MsgAppImTemplateService msgAppImTemplateService;
    @Autowired
    private MsgAppImSendAsyncService msgAppImSendAsyncService;

    public boolean sendTextMsg(AppImSendTextCreateDto dto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(dto.getAppId(), dto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(dto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.APP_IM.getCode());
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), configJsonData.getChannelNo());
        AppImSendRecordDto record = new AppImSendRecordDto();
        BeanUtils.copyProperties((Object)channel, (Object)record);
        record.setSceneCode(dto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        record.setChannelId(channel.getId());
        record.setType(AppImMsgTypeEnum.TEXT.getCode());
        record.setContent(dto.getText());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(dto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(dto.getAppSecret());
        TenantCodeUtils.fillTenantCode((SendRecordTenant)record);
        record.setUserIds(dto.getUserIds());
        return this.msgAppImSendAsyncService.sendAppImAsyncMsg(record);
    }

    public boolean sendArticleMsg(AppImSendArticleCreateDto dto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(dto.getAppId(), dto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(dto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.APP_IM.getCode());
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), configJsonData.getChannelNo());
        AppImSendRecordDto record = new AppImSendRecordDto();
        BeanUtils.copyProperties((Object)channel, (Object)record);
        record.setChannelId(channel.getId());
        record.setSceneCode(dto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        record.setType(AppImMsgTypeEnum.ARTICLE.getCode());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        JSONObject object = new JSONObject();
        object.put("title", (Object)dto.getTitle());
        object.put("subTitle", (Object)dto.getSubTitle());
        object.put("filePath", (Object)this.getAttachmentUrlPath(dto.getFileIds()));
        object.put("linkType", (Object)dto.getLinkType());
        object.put("url", (Object)dto.getUrl());
        record.setContent(object.toJSONString());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(dto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(dto.getAppSecret());
        TenantCodeUtils.fillTenantCode((SendRecordTenant)record);
        record.setUserIds(dto.getUserIds());
        return this.msgAppImSendAsyncService.sendAppImAsyncMsg(record);
    }

    public boolean sendImgMsg(AppImSendImgCreateDto dto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(dto.getAppId(), dto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(dto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.APP_IM.getCode());
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), configJsonData.getChannelNo());
        AppImSendRecordDto record = new AppImSendRecordDto();
        BeanUtils.copyProperties((Object)channel, (Object)record);
        record.setSceneCode(dto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        record.setChannelId(channel.getId());
        record.setType(AppImMsgTypeEnum.IMG.getCode());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        JSONObject object = new JSONObject();
        object.put("filePath", (Object)this.getAttachmentUrlPath(dto.getFileIds()));
        record.setContent(object.toJSONString());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(dto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(dto.getAppSecret());
        TenantCodeUtils.fillTenantCode((SendRecordTenant)record);
        record.setUserIds(dto.getUserIds());
        return this.msgAppImSendAsyncService.sendAppImAsyncMsg(record);
    }

    public boolean sendFileMsg(AppImSendFileCreateDto dto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(dto.getAppId(), dto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(dto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.APP_IM.getCode());
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), configJsonData.getChannelNo());
        AppImSendRecordDto record = new AppImSendRecordDto();
        BeanUtils.copyProperties((Object)channel, (Object)record);
        record.setSceneCode(dto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        record.setChannelId(channel.getId());
        record.setType(AppImMsgTypeEnum.FILE.getCode());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        JSONObject object = new JSONObject();
        object.put("filePath", (Object)this.getAttachmentUrlPath(dto.getFileIds()));
        record.setContent(object.toJSONString());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(dto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(dto.getAppSecret());
        TenantCodeUtils.fillTenantCode((SendRecordTenant)record);
        record.setUserIds(dto.getUserIds());
        return this.msgAppImSendAsyncService.sendAppImAsyncMsg(record);
    }

    public boolean testSendTextMsg(AppImSendTextCreateDto dto) {
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), dto.getChannelNo());
        AppImSendRecordDto appImSendRecordDto = new AppImSendRecordDto();
        BeanUtils.copyProperties((Object)channel, (Object)appImSendRecordDto);
        appImSendRecordDto.setChannelId(channel.getId());
        appImSendRecordDto.setType(AppImMsgTypeEnum.TEXT.getCode());
        appImSendRecordDto.setContent(dto.getText());
        appImSendRecordDto.setStatus(Integer.valueOf(1));
        appImSendRecordDto.setTim(dto.getTim());
        appImSendRecordDto.setJobTime(dto.getJobTime());
        appImSendRecordDto.setUserIds(dto.getUserIds());
        Long templateId = dto.getTemplateId();
        if (HussarUtils.isNotEmpty((Object)templateId)) {
            Map imParams = dto.getImParams();
            MsgAppImTemplate msgAppImTemplate = (MsgAppImTemplate)this.msgAppImTemplateService.getById((Serializable)templateId);
            HussarUtils.copy((Object)msgAppImTemplate, (Object)appImSendRecordDto);
            appImSendRecordDto.setImParams(imParams);
            if ("textcard".equals(appImSendRecordDto.getMessageType())) {
                appImSendRecordDto.setType(AppImMsgTypeEnum.ARTICLE.getCode());
            }
            appImSendRecordDto.setTitle(TemplateUtils.replaceParams((String)appImSendRecordDto.getTitle(), (Map)imParams));
            appImSendRecordDto.setUrl(TemplateUtils.replaceParams((String)appImSendRecordDto.getUrl(), (Map)imParams));
            appImSendRecordDto.setContent(TemplateUtils.replaceParams((String)appImSendRecordDto.getContent(), (Map)imParams));
        }
        appImSendRecordDto.setAppId(AppEnum.TEST.getAppId());
        appImSendRecordDto.setAppName(AppEnum.TEST.getAppName());
        appImSendRecordDto.setAppSecret(AppEnum.TEST.getAppSecret());
        appImSendRecordDto.setSceneCode(AppEnum.TEST.getSceneCode());
        appImSendRecordDto.setSceneName(AppEnum.TEST.getSceneName());
        appImSendRecordDto.setTenantCode(dto.getTenantCode());
        return this.appImPushThirdService.thirdSendAppIm(appImSendRecordDto);
    }

    public boolean testSendArticleMsg(AppImSendArticleCreateDto dto) {
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), dto.getChannelNo());
        AppImSendRecordDto appImSendRecordDto = new AppImSendRecordDto();
        BeanUtils.copyProperties((Object)channel, (Object)appImSendRecordDto);
        appImSendRecordDto.setChannelId(channel.getId());
        appImSendRecordDto.setType(AppImMsgTypeEnum.ARTICLE.getCode());
        appImSendRecordDto.setTim(dto.getTim());
        appImSendRecordDto.setJobTime(dto.getJobTime());
        JSONObject object = new JSONObject();
        object.put("title", (Object)dto.getTitle());
        object.put("subTitle", (Object)dto.getSubTitle());
        object.put("filePath", (Object)this.getAttachmentUrlPath(dto.getFileIds()));
        object.put("linkType", (Object)dto.getLinkType());
        object.put("url", (Object)dto.getUrl());
        appImSendRecordDto.setContent(object.toJSONString());
        appImSendRecordDto.setFileNames(dto.getFileNames());
        appImSendRecordDto.setStatus(SendStatusEnum.SENDING.getCode());
        appImSendRecordDto.setUserIds(dto.getUserIds());
        appImSendRecordDto.setAppId(AppEnum.TEST.getAppId());
        appImSendRecordDto.setAppName(AppEnum.TEST.getAppName());
        appImSendRecordDto.setAppSecret(AppEnum.TEST.getAppSecret());
        appImSendRecordDto.setSceneCode(AppEnum.TEST.getSceneCode());
        appImSendRecordDto.setSceneName(AppEnum.TEST.getSceneName());
        appImSendRecordDto.setTenantCode(dto.getTenantCode());
        return this.appImPushThirdService.sendArticleTimMsg(appImSendRecordDto);
    }

    public boolean testSendImgMsg(AppImSendImgCreateDto dto) {
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), dto.getChannelNo());
        AppImSendRecordDto appImSendRecordDto = new AppImSendRecordDto();
        BeanUtils.copyProperties((Object)channel, (Object)appImSendRecordDto);
        appImSendRecordDto.setChannelId(channel.getId());
        appImSendRecordDto.setType(AppImMsgTypeEnum.IMG.getCode());
        appImSendRecordDto.setTim(dto.getTim());
        appImSendRecordDto.setJobTime(dto.getJobTime());
        JSONObject object = new JSONObject();
        object.put("filePath", (Object)this.getAttachmentUrlPath(dto.getFileIds()));
        appImSendRecordDto.setContent(object.toJSONString());
        appImSendRecordDto.setFileNames(dto.getFileNames());
        appImSendRecordDto.setStatus(SendStatusEnum.SENDING.getCode());
        appImSendRecordDto.setUserIds(dto.getUserIds());
        appImSendRecordDto.setAppId(AppEnum.TEST.getAppId());
        appImSendRecordDto.setAppName(AppEnum.TEST.getAppName());
        appImSendRecordDto.setAppSecret(AppEnum.TEST.getAppSecret());
        appImSendRecordDto.setSceneCode(AppEnum.TEST.getSceneCode());
        appImSendRecordDto.setSceneName(AppEnum.TEST.getSceneName());
        appImSendRecordDto.setTenantCode(dto.getTenantCode());
        return this.appImPushThirdService.sendImgTimMsg(appImSendRecordDto);
    }

    public boolean testSendFileMsg(AppImSendFileCreateDto dto) {
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), dto.getChannelNo());
        AppImSendRecordDto appImSendRecordDto = new AppImSendRecordDto();
        BeanUtils.copyProperties((Object)channel, (Object)appImSendRecordDto);
        appImSendRecordDto.setChannelId(channel.getId());
        appImSendRecordDto.setType(AppImMsgTypeEnum.FILE.getCode());
        appImSendRecordDto.setTim(dto.getTim());
        appImSendRecordDto.setJobTime(dto.getJobTime());
        JSONObject object = new JSONObject();
        object.put("filePath", (Object)this.getAttachmentUrlPath(dto.getFileIds()));
        appImSendRecordDto.setContent(object.toJSONString());
        appImSendRecordDto.setFileNames(dto.getFileNames());
        appImSendRecordDto.setStatus(SendStatusEnum.SENDING.getCode());
        appImSendRecordDto.setUserIds(dto.getUserIds());
        appImSendRecordDto.setAppId(AppEnum.TEST.getAppId());
        appImSendRecordDto.setAppName(AppEnum.TEST.getAppName());
        appImSendRecordDto.setAppSecret(AppEnum.TEST.getAppSecret());
        appImSendRecordDto.setSceneCode(AppEnum.TEST.getSceneCode());
        appImSendRecordDto.setSceneName(AppEnum.TEST.getSceneName());
        appImSendRecordDto.setTenantCode(dto.getTenantCode());
        return this.appImPushThirdService.sendFileTimMsg(appImSendRecordDto);
    }

    private void checkBeforSend(MsgAppImTestSendDto msgAppImTestSendDto) {
        MsgAppImTemplate msgAppImTemplate = (MsgAppImTemplate)this.msgAppImTemplateService.getById((Serializable)msgAppImTestSendDto.getTemplateId());
        String[] templateParams = msgAppImTemplate.getTemplateParams().split(",");
        Map imParams = msgAppImTestSendDto.getImParams();
        for (String str : templateParams) {
            if (imParams.containsKey(str)) continue;
            throw new HussarException("\u6a21\u677f\u53c2\u6570\uff1a" + str + ",\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private void replaceContent(AppImSendRecordDto appImSendRecordDto) {
        String title = appImSendRecordDto.getTitle();
        String url = appImSendRecordDto.getUrl();
        String content = appImSendRecordDto.getContent();
        Map imParams = appImSendRecordDto.getImParams();
        if (HussarUtils.isNotEmpty((Object)imParams) && (HussarUtils.isNotEmpty((Object)title) || HussarUtils.isNotEmpty((Object)url) || HussarUtils.isNotEmpty((Object)content))) {
            for (String key : imParams.keySet()) {
                title = title.replaceAll("\\#\\{" + key + "}*\\}", (String)imParams.get(key));
                url = url.replaceAll("\\#\\{" + key + "}*\\}", (String)imParams.get(key));
                content = content.replaceAll("\\#\\{" + key + "}*\\}", (String)imParams.get(key));
            }
            appImSendRecordDto.setTitle(title);
            appImSendRecordDto.setUrl(url);
            appImSendRecordDto.setContent(content);
        }
    }

    private String getAttachmentUrlPath(String fileIds) {
        String path = "";
        if (HussarUtils.isEmpty((Object)fileIds)) {
            return path;
        }
        String[] fileIdList = fileIds.split(",");
        List attachList = this.ossService.getByFileIds(fileIdList);
        if (HussarUtils.isNotEmpty((Object)attachList)) {
            for (AttachmentManagerModelVo attach : attachList) {
                Long fileId = attach.getId();
                String fileName = attach.getAttachmentName();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                path = attach.getAttachmentDir().replace("\\", "/") + fileId + suffix;
            }
        }
        return path;
    }

    private AppImChannel getAppImChannel(Long channelId, String channelNo) {
        AppImChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(AppImChannel::getId, (Object)channelId);
        }
        if (HussarUtils.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(AppImChannel::getChannelNo, (Object)channelNo);
        }
        if ((channel = (AppImChannel)this.appImChannelService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getOpenStatus() == null || !channel.getOpenStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }
}

