/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.appim.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.appim.dao.AppImChannelMapper;
import com.jxdinfo.hussar.msg.appim.dto.AppImChannelCreateDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImChannelQueryDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImChannelUpdateDto;
import com.jxdinfo.hussar.msg.appim.model.AppImChannel;
import com.jxdinfo.hussar.msg.appim.service.AppImChannelService;
import com.jxdinfo.hussar.msg.appim.vo.AppImChannelPageVo;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AppImChannelServiceImpl
extends HussarServiceImpl<AppImChannelMapper, AppImChannel>
implements AppImChannelService {
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<AppImChannel> listPage(Page page, AppImChannelQueryDto queryDto) {
        queryDto.setChannelNo(SqlQueryUtil.transferSpecialChar((String)queryDto.getChannelNo()));
        queryDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)queryDto.getChannelName()));
        queryDto.setPubName(SqlQueryUtil.transferSpecialChar((String)queryDto.getPubName()));
        IPage<AppImChannel> pageList = ((AppImChannelMapper)this.baseMapper).queryPage(page, queryDto);
        return pageList;
    }

    public List<AppImChannelPageVo> queryList(AppImChannelQueryDto queryDto) {
        QueryWrapper qw = new QueryWrapper();
        List list = ((AppImChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public AppImChannelPageVo findById(long id) {
        AppImChannel entity = (AppImChannel)super.getById((Serializable)Long.valueOf(id));
        return this.entity2QueryVo(entity);
    }

    @HussarTransactional
    public boolean save(AppImChannelCreateDto createDto) {
        QueryWrapper nameQw = new QueryWrapper();
        nameQw.lambda().eq(AppImChannel::getChannelName, (Object)createDto.getChannelName());
        long nameCount = this.count((Wrapper)nameQw);
        if (nameCount > 0L) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + createDto.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        QueryWrapper pubNameQw = new QueryWrapper();
        pubNameQw.lambda().eq(AppImChannel::getPubName, (Object)createDto.getPubName());
        long pubNameCount = this.count((Wrapper)pubNameQw);
        if (pubNameCount > 0L) {
            throw new HussarException("\u5fae\u5e94\u7528\u540d\u79f0'" + createDto.getPubName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        AppImChannel entity = new AppImChannel();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        entity.setChannelNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.APP_IM_CHANNEL));
        super.save((BaseEntity)entity);
        return true;
    }

    @HussarTransactional
    public boolean updateById(AppImChannelUpdateDto updateDto) {
        QueryWrapper nameQw = new QueryWrapper();
        nameQw.lambda().eq(AppImChannel::getChannelName, (Object)updateDto.getChannelName());
        nameQw.lambda().ne(AppImChannel::getId, (Object)updateDto.getId());
        long nameCount = this.count((Wrapper)nameQw);
        if (nameCount > 0L) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + updateDto.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        QueryWrapper pubNameQw = new QueryWrapper();
        pubNameQw.lambda().eq(AppImChannel::getPubName, (Object)updateDto.getPubName());
        pubNameQw.lambda().ne(AppImChannel::getId, (Object)updateDto.getId());
        long pubNameCount = this.count((Wrapper)pubNameQw);
        if (pubNameCount > 0L) {
            throw new HussarException("\u5fae\u5e94\u7528\u540d\u79f0'" + updateDto.getPubName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        AppImChannel appImChannel = (AppImChannel)super.getById((Serializable)updateDto.getId());
        if (!HussarUtils.equals((Object)appImChannel.getOpenStatus(), (Object)updateDto.getOpenStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(appImChannel.getChannelNo())))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u65e0\u6cd5\u4fee\u6539\u542f\u52a8\u72b6\u6001\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        AppImChannel entity = new AppImChannel();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        super.updateById((BaseEntity)entity);
        return true;
    }

    @HussarTransactional
    public boolean delete(Long id) {
        String channelNo = ((AppImChannel)super.getById((Serializable)id)).getChannelNo();
        if (this.appSceneConfigService.isExistScene(channelNo)) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        super.removeById((Serializable)id);
        return true;
    }

    @HussarTransactional
    public boolean deleteChannelByIds(Long[] ids) {
        List channelNos = super.listByIds(Arrays.asList(ids)).stream().map(AppImChannel::getChannelNo).collect(Collectors.toList());
        if (this.appSceneConfigService.isExistSceneInBatch(channelNos)) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        super.removeByIds(Arrays.asList(ids));
        return true;
    }

    public boolean updateStatus(Long id) {
        AppImChannel appImChannel = (AppImChannel)super.getById((Serializable)id);
        if (appImChannel == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7b7e\u540d\u6570\u636e");
        }
        AppImChannel entity = new AppImChannel();
        entity.setId(id);
        entity.setOpenStatus(appImChannel.getOpenStatus().equals(OpenStatusEnum.DISABLED.getCode()) ? OpenStatusEnum.ENABLE.getCode() : OpenStatusEnum.DISABLED.getCode());
        return super.updateById((BaseEntity)entity);
    }

    public List<AppImChannelPageVo> getChannelList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((AppImChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public Map<String, String> getChannelNoAndName(List<String> channelNos) {
        if (HussarUtils.isEmpty(channelNos)) {
            return new HashMap<String, String>();
        }
        Map<String, String> channelNoAndName = super.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{AppImChannel::getChannelNo, AppImChannel::getChannelName}).in(AppImChannel::getChannelNo, channelNos)).stream().collect(Collectors.toMap(AppImChannel::getChannelNo, AppImChannel::getChannelName));
        channelNoAndName.put("null", "\u65e0\u901a\u9053\u6807\u8bc6\u8bb0\u5f55");
        return channelNoAndName;
    }

    private AppImChannelPageVo entity2QueryVo(AppImChannel entity) {
        AppImChannelPageVo vo = new AppImChannelPageVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }
}

