/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.ChannelTypeEnum;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.utils.PrintPushLogsUtils;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.factory.MsgUnitySendFactory;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.model.MsgBasicSendRecord;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordDto;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsChannel;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsSign;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsTemplate;
import com.jxdinfo.hussar.msg.sms.service.MsgSmsSendAsyncService;
import com.jxdinfo.hussar.msg.sms.service.SmsChannelService;
import com.jxdinfo.hussar.msg.sms.service.SmsSendRecordService;
import com.jxdinfo.hussar.msg.sms.service.SmsSignService;
import com.jxdinfo.hussar.msg.sms.service.SmsTemplateService;
import com.jxdinfo.hussar.msg.sms.third.service.SmsPushService;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class SmsUnitySendServiceImpl
implements MsgUnitySendFrameService,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmsUnitySendServiceImpl.class);
    @Autowired
    private MsgSmsSendAsyncService msgSmsSendAsyncService;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private SmsChannelService smsChannelService;
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired
    private SmsSignService smsSignService;
    @Autowired
    private SmsPushService smsPushService;
    @Autowired
    private SmsSendRecordService smsSendRecordService;

    public MsgBasicSendRecord msgUnitySendBefore(MsgUnitySendDto msgUnitySendDto) {
        SmsSendRecordDto smsSendRecordDto = new SmsSendRecordDto();
        try {
            AppSceneConfig appSceneConfig = (AppSceneConfig)this.appSceneConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)msgUnitySendDto.getSceneCode()));
            String sceneCode = appSceneConfig.getSceneCode();
            Long appAccessId = appSceneConfig.getAppPkId();
            smsSendRecordDto.setSceneName(appSceneConfig.getSceneName());
            smsSendRecordDto.setSceneCode(sceneCode);
            AppAccess appAccess = (AppAccess)this.appAccessService.getById((Serializable)appAccessId);
            smsSendRecordDto.setAppId(appAccess.getAppId());
            smsSendRecordDto.setAppName(appAccess.getAppName());
            ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(sceneCode, appAccessId.toString(), ServiceTypeEnum.SMS.getCode());
            String templateNo = configJsonData.getTemplateNo();
            String signNo = configJsonData.getSignNo();
            MsgSmsSign msgSmsSign = (MsgSmsSign)this.smsSignService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgSmsSign::getSignNo, (Object)signNo)).eq(MsgSmsSign::getStatus, (Object)1));
            if (HussarUtils.isEmpty((Object)msgSmsSign)) {
                throw new BaseException("\u7b7e\u540d\u6807\u8bc6\u4e3a" + signNo + "\u4e0d\u5b58\u5728\u6216\u8005\u672a\u542f\u7528");
            }
            smsSendRecordDto.setSignName(msgSmsSign.getSignName());
            smsSendRecordDto.setSignNo(signNo);
            smsSendRecordDto.setSignId(msgSmsSign.getId());
            MsgSmsTemplate msgSmsTemplate = (MsgSmsTemplate)this.smsTemplateService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgSmsTemplate::getTemplateNo, (Object)templateNo));
            MsgSmsChannel msgSmsChannel = (MsgSmsChannel)this.smsChannelService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgSmsChannel::getChannelNo, (Object)configJsonData.getChannelNo()));
            HussarUtils.copy((Object)msgSmsTemplate, (Object)smsSendRecordDto);
            HussarUtils.copy((Object)msgSmsChannel, (Object)smsSendRecordDto);
            String channelTypeName = ChannelTypeEnum.getName((Integer)msgSmsChannel.getChannelType());
            smsSendRecordDto.setChannelType(channelTypeName);
            smsSendRecordDto.setAccessKeyId(msgSmsChannel.getKeyId());
            smsSendRecordDto.setAccessKeySecret(msgSmsChannel.getKeySecret());
            smsSendRecordDto.setSmsSdkAppId(msgSmsChannel.getAppKey());
            smsSendRecordDto.setTemplateId(msgSmsTemplate.getId());
            smsSendRecordDto.setContent(msgSmsTemplate.getTemplateContent());
            smsSendRecordDto.setParams(JSON.toJSONString((Object)TemplateUtils.getCurrentTemplateParams((Map)msgUnitySendDto.getTemplateParams(), (String)TemplateUtils.getTemplateParams((String)msgSmsTemplate.getTemplateContent()))));
            smsSendRecordDto.setStatus(Integer.valueOf(1));
            smsSendRecordDto.setTenantCode(msgUnitySendDto.getTenantCode());
            ArrayList errorContactInfos = new ArrayList();
            List receiveAddress = this.msgContactInfoService.getReceiveAddress(msgUnitySendDto, ServiceTypeEnum.SMS.getCode(), appSceneConfig, errorContactInfos);
            if (HussarUtils.isEmpty((Object)receiveAddress)) {
                this.saveFailRecord(smsSendRecordDto, new RuntimeException("\u65e0\u53ef\u7528\u8054\u7cfb\u5730\u5740\uff01" + (HussarUtils.isNotEmpty(errorContactInfos) ? "\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", errorContactInfos) : "")));
                return null;
            }
            smsSendRecordDto.setPhoneNumber(String.join((CharSequence)",", receiveAddress));
            PrintPushLogsUtils.printPushReceiveLogs((List)receiveAddress, (String)ServiceTypeEnum.SMS.getCode(), (Logger)LOGGER);
            smsSendRecordDto.setErrorContactInfos(errorContactInfos);
        }
        catch (Exception e) {
            this.saveFailRecord(smsSendRecordDto, e);
            throw e;
        }
        this.smsPushService.sendMsg(smsSendRecordDto);
        return null;
    }

    public String getMsgSendType() {
        return null;
    }

    public boolean msgUnityThirdSend(MsgBasicSendRecord msgBasicSendRecord) {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        MsgUnitySendFactory.setSendBeansToMap("sms", this);
    }

    private void saveFailRecord(SmsSendRecordDto smsSendRecordDto, Exception e) {
        Date now = new Date();
        if (HussarUtils.isEmpty((Object)smsSendRecordDto.getChannelNo())) {
            smsSendRecordDto.setChannelNo("null");
            smsSendRecordDto.setChannelName("\u65e0\u901a\u9053\u6807\u8bc6\u8bb0\u5f55");
        }
        smsSendRecordDto.setId(null);
        smsSendRecordDto.setSendTime(now);
        smsSendRecordDto.setCreateTime(now);
        smsSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        smsSendRecordDto.setStatus(SendStatusEnum.FAIL.getCode());
        smsSendRecordDto.setErrMsg("\u7ec4\u88c5\u53d1\u9001\u53c2\u6570\u53d1\u751f\u5f02\u5e38\uff1a" + (HussarUtils.isNotEmpty((Object)e.getMessage()) ? e.getMessage() : e.getClass().getName()));
        this.smsSendRecordService.save(smsSendRecordDto);
    }
}

