/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.enums.ChannelTypeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.sms.dao.MsgSmsTemplateMapper;
import com.jxdinfo.hussar.msg.sms.dto.SmsChannelQueryVo;
import com.jxdinfo.hussar.msg.sms.dto.SmsTemplateCreateDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsTemplatePageDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsTemplateQueryVo;
import com.jxdinfo.hussar.msg.sms.dto.SmsTemplateUpdateDto;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsTemplate;
import com.jxdinfo.hussar.msg.sms.service.SmsChannelService;
import com.jxdinfo.hussar.msg.sms.service.SmsTemplateService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SmsTemplateServiceImpl
extends HussarServiceImpl<MsgSmsTemplateMapper, MsgSmsTemplate>
implements SmsTemplateService {
    private static final String ALIYUN_PATTERN_CONTENT = "\\#\\{(.*?)\\}";
    private static final String TENCENT_PATTERN_CONTENT = "\\{(.*?)\\}";
    @Autowired
    private SmsChannelService smsChannelService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<MsgSmsTemplate> listPage(Page page, SmsTemplatePageDto pageDto) {
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getTemplateCode())) {
            pageDto.setTemplateCode(SqlQueryUtil.transferSpecialChar((String)pageDto.getTemplateCode().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getTemplateName())) {
            pageDto.setTemplateName(SqlQueryUtil.transferSpecialChar((String)pageDto.getTemplateName().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getTemplateNo())) {
            pageDto.setTemplateNo(SqlQueryUtil.transferSpecialChar((String)pageDto.getTemplateNo().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelName())) {
            pageDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelName().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelNo())) {
            pageDto.setChannelNo(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelNo().trim()));
        }
        IPage<MsgSmsTemplate> pageList = ((MsgSmsTemplateMapper)this.baseMapper).queryPage(page, pageDto);
        return pageList;
    }

    public SmsTemplateQueryVo findById(Long id) {
        MsgSmsTemplate entity = (MsgSmsTemplate)super.getById((Serializable)id);
        return this.entity2QueryVo(entity);
    }

    public boolean save(SmsTemplateCreateDto createDto) {
        SmsChannelQueryVo smsChannelQueryVo = this.smsChannelService.findById(createDto.getChannelId());
        if (HussarUtils.isEmpty((Object)smsChannelQueryVo)) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        MsgSmsTemplate entity = new MsgSmsTemplate();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        entity.setTemplateNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.MSM_TEMPLATE));
        if (HussarUtils.equals((Object)"1", (Object)this.checkTemplateUnique(entity))) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0'" + entity.getTemplateName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.save((BaseEntity)entity);
    }

    public boolean updateById(SmsTemplateUpdateDto updateDto) {
        MsgSmsTemplate msgSmsTemplate = (MsgSmsTemplate)super.getById((Serializable)updateDto.getId());
        if (HussarUtils.isEmpty((Object)msgSmsTemplate)) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677f\u6570\u636e");
        }
        SmsChannelQueryVo smsChannelQueryVo = this.smsChannelService.findById(msgSmsTemplate.getChannelId());
        if (HussarUtils.isEmpty((Object)smsChannelQueryVo)) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        MsgSmsTemplate entity = new MsgSmsTemplate();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        if (HussarUtils.equals((Object)"1", (Object)this.checkTemplateUnique(entity))) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0'" + entity.getTemplateName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        if (!HussarUtils.equals((Object)msgSmsTemplate.getStatus(), (Object)updateDto.getStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(msgSmsTemplate.getTemplateNo())))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u65e0\u6cd5\u4fee\u6539\u542f\u52a8\u72b6\u6001\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        return super.updateById((BaseEntity)entity);
    }

    public boolean delete(Long id) {
        MsgSmsTemplate msgSmsTemplate = (MsgSmsTemplate)super.getById((Serializable)id);
        if (HussarUtils.isEmpty((Object)msgSmsTemplate)) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677f\u6570\u636e");
        }
        if (this.appSceneConfigService.isExistScene(msgSmsTemplate.getTemplateNo())) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        SmsChannelQueryVo smsChannelQueryVo = this.smsChannelService.findById(msgSmsTemplate.getChannelId());
        if (HussarUtils.isEmpty((Object)smsChannelQueryVo)) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        return super.removeById((Serializable)id);
    }

    public boolean updateStatus(Long id) {
        MsgSmsTemplate msgSmsTemplate = (MsgSmsTemplate)super.getById((Serializable)id);
        if (HussarUtils.isEmpty((Object)msgSmsTemplate)) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677f\u6570\u636e");
        }
        MsgSmsTemplate entity = new MsgSmsTemplate();
        entity.setId(id);
        entity.setStatus(msgSmsTemplate.getStatus().equals(OpenStatusEnum.DISABLED.getCode()) ? OpenStatusEnum.ENABLE.getCode() : OpenStatusEnum.DISABLED.getCode());
        return super.updateById((BaseEntity)entity);
    }

    public List<SmsTemplateQueryVo> getTemplateListByChannelId(Long channelId) {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgSmsTemplate::getChannelId, (Object)channelId);
        qw.lambda().eq(MsgSmsTemplate::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgSmsTemplateMapper)this.baseMapper).selectList((Wrapper)qw);
        SmsChannelQueryVo channel = this.smsChannelService.findById(channelId);
        if (channel.getChannelType().equals(ChannelTypeEnum.TENCENT.getType())) {
            for (MsgSmsTemplate msgSmsTemplate : list) {
                msgSmsTemplate.setTemplateContents(this.getTemplateContent(msgSmsTemplate.getTemplateContent(), TENCENT_PATTERN_CONTENT));
            }
        } else if (channel.getChannelType().equals(ChannelTypeEnum.ALIYUN.getType())) {
            for (MsgSmsTemplate msgSmsTemplate : list) {
                msgSmsTemplate.setTemplateContents(this.getTemplateContent(msgSmsTemplate.getTemplateContent(), ALIYUN_PATTERN_CONTENT));
            }
        } else {
            throw new HussarException("\u83b7\u53d6\u6a21\u677f\u53c2\u6570\u5931\u8d25");
        }
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public boolean deleteTemplateByIds(Long[] ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(Arrays.asList(ids)).stream().map(MsgSmsTemplate::getTemplateNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        return super.removeByIds(Arrays.asList(ids));
    }

    private SmsTemplateQueryVo entity2QueryVo(MsgSmsTemplate entity) {
        SmsTemplateQueryVo vo = new SmsTemplateQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }

    private List<String> getTemplateContent(String templateContent, String patternContent) {
        LinkedList<String> contents = new LinkedList<String>();
        if (HussarUtils.isNotEmpty((Object)templateContent)) {
            Pattern pattern = Pattern.compile(patternContent);
            Matcher matcher = pattern.matcher(templateContent);
            while (matcher.find()) {
                String group = matcher.group(1);
                contents.add(group);
            }
        }
        return contents;
    }

    private String checkTemplateUnique(MsgSmsTemplate entity) {
        Long id = HussarUtils.isEmpty((Object)entity.getId()) ? -1L : entity.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgSmsTemplate::getTemplateName, (Object)entity.getTemplateName());
        MsgSmsTemplate info = (MsgSmsTemplate)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)info) && !HussarUtils.equals((Object)info.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

