/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.notice.service.impl;

import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.common.enums.AppEnum;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.notice.model.MsgNoticeTemplate;
import com.jxdinfo.hussar.msg.notice.model.Notice;
import com.jxdinfo.hussar.msg.notice.service.MsgNoticeSendAsyncService;
import com.jxdinfo.hussar.msg.notice.service.MsgNoticeTemplateService;
import com.jxdinfo.hussar.msg.notice.service.NoticeSendService;
import com.jxdinfo.hussar.msg.notice.third.service.NoticeSendThirdService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoticeSendServiceImpl
implements NoticeSendService {
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private NoticeSendThirdService noticeSendThirdService;
    @Autowired
    private MsgNoticeSendAsyncService msgNoticeSendAsyncService;
    @Autowired
    private MsgNoticeTemplateService msgNoticeTemplateService;

    public boolean sendMsgNoticeMq(Notice notice) {
        AppAccess appAccess = this.appAccessService.getAppAccess(notice.getAppId(), notice.getAppSecret());
        notice.setAppName(appAccess.getAppName());
        HussarTenantDefinition tenant = HussarContextHolder.getHussarTenant();
        if (HussarUtils.isNotEmpty((Object)tenant)) {
            notice.setTenantCode(tenant.getTenantCode());
        }
        return this.msgNoticeSendAsyncService.sendNoticeAsyncMsg(notice);
    }

    public Boolean sendTestMsgNotice(Notice notice) {
        Long templateId = notice.getTemplateId();
        if (HussarUtils.isNotEmpty((Object)templateId)) {
            Map noticeParams = notice.getNoticeParams();
            MsgNoticeTemplate msgNoticeTemplate = (MsgNoticeTemplate)this.msgNoticeTemplateService.getById((Serializable)templateId);
            HussarUtils.copy((Object)msgNoticeTemplate, (Object)notice);
            notice.setNoticeParams(noticeParams);
            notice.setNoticeTitle(msgNoticeTemplate.getTitle());
            notice.setNoticeContent(msgNoticeTemplate.getContent());
            notice.setNoticeContent(TemplateUtils.replaceParams((String)notice.getNoticeContent(), (Map)noticeParams));
            notice.setNoticeTitle(TemplateUtils.replaceParams((String)notice.getNoticeTitle(), (Map)noticeParams));
        }
        notice.setAppId(AppEnum.TEST.getAppId());
        notice.setAppName(AppEnum.TEST.getAppName());
        notice.setAppSecret(AppEnum.TEST.getAppSecret());
        notice.setSceneCode(AppEnum.TEST.getSceneCode());
        notice.setSceneName(AppEnum.TEST.getSceneName());
        return this.noticeSendThirdService.sendMsgTimNotice(notice);
    }
}

