/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.AppEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.model.SendRecordTenant;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.mp.dto.MpSendMsgCreateDto;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordDto;
import com.jxdinfo.hussar.msg.mp.model.MsgMpChannel;
import com.jxdinfo.hussar.msg.mp.model.MsgMpTemplate;
import com.jxdinfo.hussar.msg.mp.service.MpChannelService;
import com.jxdinfo.hussar.msg.mp.service.MpSendService;
import com.jxdinfo.hussar.msg.mp.service.MpTemplateService;
import com.jxdinfo.hussar.msg.mp.service.MsgMpSendAsyncService;
import com.jxdinfo.hussar.msg.mp.third.service.MpSendMsgThirdService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MpSendServiceImpl
implements MpSendService {
    @Autowired
    private MpChannelService mpChannelService;
    @Autowired
    private MpTemplateService mpTemplateService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private MpSendMsgThirdService mpSendMsgThirdService;
    @Autowired
    private MsgMpSendAsyncService msgMpSendAsyncService;

    public boolean sendMpMsgMq(MpSendMsgCreateDto createDto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(createDto.getAppId(), createDto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(createDto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.WX_ACCOUNT.getCode());
        createDto.setChannelNo(configJsonData.getChannelNo());
        createDto.setTemplateNo(configJsonData.getTemplateNo());
        MsgMpChannel channel = this.getMpChannel(createDto.getChannelId(), createDto.getChannelNo());
        MsgMpTemplate template = this.getMpTemplate(createDto.getTemplateId(), createDto.getTemplateNo());
        MpSendRecordDto record = new MpSendRecordDto();
        record.setChannelId(channel.getId());
        record.setChannelNo(channel.getChannelNo());
        record.setChannelName(channel.getChannelName());
        record.setKeyId(channel.getKeyId());
        record.setKeySecret(channel.getKeySecret());
        record.setTemplateId(template.getId());
        record.setTemplateNo(template.getTemplateNo());
        record.setTemplateName(template.getTemplateName());
        record.setTemplateBizId(template.getTemplateBizId());
        record.setToUser(createDto.getToUser());
        record.setUrl(createDto.getUrl());
        record.setContent(JSONObject.toJSONString((Object)createDto.getData()));
        record.setTim(createDto.getTim());
        record.setJobTime(createDto.getJobTime());
        record.setAppId(createDto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(createDto.getAppSecret());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setSceneCode(createDto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        TenantCodeUtils.fillTenantCode((SendRecordTenant)record);
        return this.msgMpSendAsyncService.sendMpAsyncMsg(record);
    }

    public boolean testSendMpMsg(MpSendMsgCreateDto createDto) {
        MsgMpChannel channel = this.getMpChannel(createDto.getChannelId(), createDto.getChannelNo());
        MsgMpTemplate template = this.getMpTemplate(createDto.getTemplateId(), createDto.getTemplateNo());
        MpSendRecordDto mpSendRecordDto = new MpSendRecordDto();
        mpSendRecordDto.setChannelId(channel.getId());
        mpSendRecordDto.setChannelNo(channel.getChannelNo());
        mpSendRecordDto.setChannelName(channel.getChannelName());
        mpSendRecordDto.setKeyId(channel.getKeyId());
        mpSendRecordDto.setKeySecret(channel.getKeySecret());
        mpSendRecordDto.setTemplateId(template.getId());
        mpSendRecordDto.setTemplateNo(template.getTemplateNo());
        mpSendRecordDto.setTemplateName(template.getTemplateName());
        mpSendRecordDto.setTemplateBizId(template.getTemplateBizId());
        mpSendRecordDto.setToUser(createDto.getToUser());
        mpSendRecordDto.setUrl(createDto.getUrl());
        mpSendRecordDto.setContent(HussarUtils.isNotEmpty((Object)createDto.getData()) ? JSONObject.toJSONString((Object)createDto.getData()) : "");
        mpSendRecordDto.setStatus(SendStatusEnum.SENDING.getCode());
        mpSendRecordDto.setTim(createDto.getTim());
        mpSendRecordDto.setJobTime(createDto.getJobTime());
        mpSendRecordDto.setAppId(AppEnum.TEST.getAppId());
        mpSendRecordDto.setAppName(AppEnum.TEST.getAppName());
        mpSendRecordDto.setAppSecret(AppEnum.TEST.getAppSecret());
        mpSendRecordDto.setSceneCode(AppEnum.TEST.getSceneCode());
        mpSendRecordDto.setSceneName(AppEnum.TEST.getSceneName());
        mpSendRecordDto.setTenantCode(createDto.getTenantCode());
        return this.mpSendMsgThirdService.sendMpTimMsg(mpSendRecordDto);
    }

    private MsgMpChannel getMpChannel(Long channelId, String channelNo) {
        MsgMpChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(MsgMpChannel::getId, (Object)channelId);
        }
        if (HussarUtils.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(MsgMpChannel::getChannelNo, (Object)channelNo);
        }
        if ((channel = (MsgMpChannel)this.mpChannelService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }

    private MsgMpTemplate getMpTemplate(Long templateId, String templateNo) {
        MsgMpTemplate template;
        QueryWrapper qw = new QueryWrapper();
        if (templateId != null) {
            qw.lambda().eq(MsgMpTemplate::getId, (Object)templateId);
        }
        if (HussarUtils.isNotEmpty((Object)templateNo)) {
            qw.lambda().eq(MsgMpTemplate::getTemplateNo, (Object)templateNo);
        }
        if ((template = (MsgMpTemplate)this.mpTemplateService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677f");
        }
        if (template.getStatus() == null || !template.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u6a21\u677f\u672a\u542f\u7528");
        }
        QueryWrapper qw1 = new QueryWrapper();
        qw1.lambda().eq(MsgMpChannel::getId, (Object)template.getChannelId());
        qw1.lambda().eq(MsgMpChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        long count = this.mpChannelService.count((Wrapper)qw1);
        if (count == 0L) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        return template;
    }
}

