/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.controller;

import com.jxdinfo.hussar.msg.common.model.MsgAppAccessBean;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkChannelDto;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendDto;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkChannelService;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkSendService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.exception.HussarException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/msg/dingtalk/send"})
@Api(tags={"\u53d1\u9001\u9489\u9489\u6d88\u606f"})
public class DingTalkSendController {
    @Autowired
    private DingTalkChannelService dingTalkChannelService;
    @Autowired
    private DingTalkSendService dingTalkSendService;

    @GetMapping(value={"getChannelList"})
    @ApiOperation(value="\u83b7\u53d6\u901a\u9053\u5217\u8868", notes="\u83b7\u53d6\u901a\u9053\u5217\u8868")
    @AuditLog(moduleName="\u53d1\u9001\u9489\u9489\u6d88\u606f", eventDesc="\u83b7\u53d6\u901a\u9053\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DingTalkChannelDto>> getChannelList() {
        return ApiResponse.success((Object)this.dingTalkChannelService.getChannelList());
    }

    @PostMapping(value={"test"})
    @ApiOperation(value="\u53d1\u9001\u6d4b\u8bd5", notes="\u53d1\u9001\u6d4b\u8bd5")
    @AuditLog(moduleName="\u53d1\u9001\u9489\u9489\u6d88\u606f", eventDesc="\u53d1\u9001\u6d4b\u8bd5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> test(@Valid @RequestBody DingTalkSendDto dto) {
        TenantCodeUtils.fillTestTenantCode((MsgAppAccessBean)dto);
        if (this.dingTalkSendService.testSendMsg(dto)) {
            return ApiResponse.success();
        }
        throw new HussarException("\u53d1\u9001\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u53d1\u9001\u8bb0\u5f55\uff01");
    }

    @PostMapping(value={"sendMsg"})
    @ApiOperation(value="\u53d1\u9001\u9489\u9489\u6d88\u606f", notes="\u53d1\u9001\u9489\u9489\u6d88\u606f")
    @AuditLog(moduleName="\u53d1\u9001\u9489\u9489\u6d88\u606f", eventDesc="\u53d1\u9001\u9489\u9489\u6d88\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> send(@Valid @RequestBody DingTalkSendDto dto) {
        return ApiResponse.status((boolean)this.dingTalkSendService.send(dto));
    }
}

