/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.msg.app.dao.MsgSceneContactMapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.MsgSceneContact;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.app.service.MsgSceneContactService;
import com.jxdinfo.hussar.msg.contact.model.MsgContact;
import com.jxdinfo.hussar.msg.contact.model.MsgContactInfo;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.contact.service.MsgContactService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgSceneContactServiceImpl
extends HussarServiceImpl<MsgSceneContactMapper, MsgSceneContact>
implements MsgSceneContactService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MsgSceneContactServiceImpl.class);
    @Autowired
    private MsgContactService msgContactService;
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    @HussarTransactional
    public boolean delByContactId(Long contactId) {
        return super.remove((Wrapper)new LambdaQueryWrapper().eq(MsgSceneContact::getMsgContactId, (Object)contactId));
    }

    public List<String> getContactReceiveAddress(Long sceneId, String sendType, String tagName, String sceneCode, List<String> errorContactInfos) {
        ArrayList<String> receiveAddressList = new ArrayList<String>();
        List sceneContacts = super.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgSceneContact::getSceneId, (Object)sceneId)).eq(MsgSceneContact::getSendType, (Object)sendType));
        if (HussarUtils.isNotEmpty((Object)sceneContacts)) {
            String sendTypeCopy = sendType;
            List msgContactIds = sceneContacts.stream().map(MsgSceneContact::getMsgContactId).collect(Collectors.toList());
            List contactIdAndTypes = this.msgContactService.listByIds(msgContactIds).stream().map(MsgContact::getContactIdAndType).collect(Collectors.toList());
            if ("wx_account".equals(sendType)) {
                ConfigJsonData configData = this.appSceneConfigService.getConfigData(sceneCode, sendType);
                String channelNo = configData.getChannelNo();
                sendTypeCopy = sendType + ":" + channelNo;
            }
            for (String contactIdAndType : contactIdAndTypes) {
                String contactId = contactIdAndType.split("_")[0];
                String contactType = contactIdAndType.split("_")[1];
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryWrapper.eq(MsgContactInfo::getContactIdAndType, (Object)contactIdAndType)).eq(MsgContactInfo::getSendType, (Object)sendTypeCopy);
                if (this.msgContactInfoService.count((Wrapper)queryWrapper) == 0L) {
                    LOGGER.error("\u6807\u8bc6\u4e3a{}\uff0c\u7c7b\u578b\u4e3a{}\u7684\u8054\u7cfb\u4eba\uff0c{}\u53d1\u9001\uff0c\u65e0\u901a\u8baf\u5730\u5740", new Object[]{contactId, contactType, sendTypeCopy});
                    errorContactInfos.add(String.format("\u6807\u8bc6\u4e3a%s\uff0c\u7c7b\u578b\u4e3a%s\u7684\u8054\u7cfb\u4eba\uff0c%s\u53d1\u9001\uff0c\u65e0\u901a\u8baf\u5730\u5740", contactId, contactType, sendTypeCopy));
                    continue;
                }
                queryWrapper.eq(MsgContactInfo::getTagName, (Object)tagName);
                MsgContactInfo msgContactInfo = (MsgContactInfo)this.msgContactInfoService.getOne((Wrapper)queryWrapper);
                if (HussarUtils.isEmpty((Object)msgContactInfo)) {
                    List list = this.msgContactInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MsgContactInfo::getContactIdAndType, (Object)contactIdAndType)).eq(MsgContactInfo::getSendType, (Object)sendType)).eq(MsgContactInfo::getTagName, (Object)"default"));
                    if (HussarUtils.isEmpty((Object)list)) {
                        LOGGER.error("\u6807\u8bc6\u4e3a{}\uff0c\u7c7b\u578b\u4e3a{}\u7684\u8054\u7cfb\u4eba\uff0c{}\u53d1\u9001\uff0c\u65e0\u9ed8\u8ba4\u6807\u7b7e\u901a\u8baf\u5730\u5740", new Object[]{contactId, contactType, sendTypeCopy});
                        errorContactInfos.add(String.format("\u6807\u8bc6\u4e3a%s\uff0c\u7c7b\u578b\u4e3a%s\u7684\u8054\u7cfb\u4eba\uff0c%s\u53d1\u9001\uff0c\u65e0\u5bf9\u5e94\u6807\u7b7e\u4ee5\u53ca\u9ed8\u8ba4\u6807\u7b7e\u901a\u8baf\u5730\u5740", contactId, contactType, sendTypeCopy));
                        continue;
                    }
                    msgContactInfo = (MsgContactInfo)list.get(0);
                }
                receiveAddressList.add(msgContactInfo.getReceiveAddress());
            }
        }
        return receiveAddressList;
    }
}

