/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.dao.AppAccessMapper;
import com.jxdinfo.hussar.msg.app.dto.AppAccessCreateDto;
import com.jxdinfo.hussar.msg.app.dto.AppAccessPageDto;
import com.jxdinfo.hussar.msg.app.dto.AppAccessUpdateDto;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.app.vo.AppAccessQueryVo;
import com.jxdinfo.hussar.msg.appim.dao.MsgAppImTemplateMapper;
import com.jxdinfo.hussar.msg.appim.model.MsgAppImTemplate;
import com.jxdinfo.hussar.msg.apppush.dao.MsgAppPushTemplateMapper;
import com.jxdinfo.hussar.msg.apppush.model.MsgAppPushTemplate;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.utils.IdUtil;
import com.jxdinfo.hussar.msg.cp.dao.MsgCpTemplateMapper;
import com.jxdinfo.hussar.msg.cp.model.MsgCpTemplate;
import com.jxdinfo.hussar.msg.dingtalk.dao.MsgDingTalkTemplateMapper;
import com.jxdinfo.hussar.msg.dingtalk.model.MsgDingTalkTemplate;
import com.jxdinfo.hussar.msg.event.MsgAfterDeleteAppEvent;
import com.jxdinfo.hussar.msg.event.MsgAfterUpdateAppEvent;
import com.jxdinfo.hussar.msg.mail.model.MsgMailTemplate;
import com.jxdinfo.hussar.msg.mail.service.MsgMailTemplateService;
import com.jxdinfo.hussar.msg.mp.model.MsgMpTemplate;
import com.jxdinfo.hussar.msg.mp.service.MpTemplateService;
import com.jxdinfo.hussar.msg.notice.dao.MsgNoticeTemplateMapper;
import com.jxdinfo.hussar.msg.notice.model.MsgNoticeTemplate;
import com.jxdinfo.hussar.msg.push.dto.AppSceneVo;
import com.jxdinfo.hussar.msg.push.dto.AppServiceDto;
import com.jxdinfo.hussar.msg.push.dto.TemplateData;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsTemplate;
import com.jxdinfo.hussar.msg.sms.service.SmsTemplateService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class AppAccessServiceImpl
extends HussarServiceImpl<AppAccessMapper, AppAccess>
implements AppAccessService,
ApplicationContextAware {
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private MsgMailTemplateService mailTemplateService;
    @Autowired
    private MpTemplateService mpTemplateService;
    @Autowired
    private MsgAppPushTemplateMapper appPushTemplateMapper;
    @Autowired
    private MsgAppImTemplateMapper appImTemplateMapper;
    @Autowired
    private MsgCpTemplateMapper cpTemplateMapper;
    @Autowired
    private MsgDingTalkTemplateMapper dingTalkTemplateMapper;
    @Autowired
    private MsgNoticeTemplateMapper noticeTemplateMapper;
    private ApplicationContext applicationContext;

    @HussarTokenDs
    public IPage<AppAccess> listPage(Page page, AppAccessPageDto pageDto) {
        Map serviceMap = ServiceTypeEnum.getServiceMap();
        pageDto.setAppId(SqlQueryUtil.transferSpecialChar((String)pageDto.getAppId()));
        pageDto.setAppName(SqlQueryUtil.transferSpecialChar((String)pageDto.getAppName()));
        IPage<AppAccess> pageList = ((AppAccessMapper)this.baseMapper).queryPage(page, pageDto);
        pageList.getRecords().forEach(o -> o.setServiceTypeData(Arrays.stream(o.getServiceType().split(",")).map(serviceMap::get).collect(Collectors.joining(","))));
        return pageList;
    }

    @HussarTokenDs
    public AppAccessQueryVo findById(long id) {
        AppAccess entity = (AppAccess)super.getById((Serializable)Long.valueOf(id));
        return this.entity2QueryVo(entity);
    }

    @HussarTokenDs
    @HussarTransactional
    public boolean save(AppAccessCreateDto createDto) {
        QueryWrapper nameQw = new QueryWrapper();
        nameQw.lambda().eq(AppAccess::getAppName, (Object)createDto.getAppName());
        if (this.count((Wrapper)nameQw) > 0L) {
            throw new HussarException("\u5e94\u7528\u540d\u79f0'" + createDto.getAppName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        QueryWrapper idQw = new QueryWrapper();
        idQw.lambda().eq(AppAccess::getAppId, (Object)createDto.getAppId());
        if (this.count((Wrapper)idQw) > 0L) {
            throw new HussarException("\u5e94\u7528\u6807\u8bc6'" + createDto.getAppId() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        String appId = createDto.getAppId();
        String appSecret = IdUtil.getAppSecret((String)appId);
        createDto.setAppSecret(appSecret);
        AppAccess entity = new AppAccess();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        return super.save((BaseEntity)entity);
    }

    @HussarTokenDs
    @HussarTransactional
    public boolean updateById(AppAccessUpdateDto updateDto) {
        AppAccess entity = new AppAccess();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        QueryWrapper nameQw = new QueryWrapper();
        nameQw.lambda().eq(AppAccess::getAppName, (Object)entity.getAppName());
        nameQw.lambda().ne(AppAccess::getId, (Object)entity.getId());
        if (this.count((Wrapper)nameQw) > 0L) {
            throw new HussarException("\u5e94\u7528\u540d\u79f0'" + updateDto.getAppName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        QueryWrapper idQw = new QueryWrapper();
        idQw.lambda().eq(AppAccess::getAppId, (Object)entity.getAppId());
        idQw.lambda().ne(AppAccess::getId, (Object)entity.getId());
        if (this.count((Wrapper)idQw) > 0L) {
            throw new HussarException("\u5e94\u7528\u6807\u8bc6'" + entity.getAppId() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        super.updateById((BaseEntity)entity);
        this.afterUpdateApp(updateDto);
        return true;
    }

    @HussarTokenDs
    @HussarTransactional
    public boolean delete(Long id) {
        if (HussarUtils.isNotEmpty((Object)this.appSceneConfigService.list((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getAppPkId, (Object)id)))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        this.afterDeleteApp(id);
        return super.removeById((Serializable)id);
    }

    @HussarTokenDs
    @HussarTransactional
    public boolean deleteAccessByIds(Long[] ids) {
        if (HussarUtils.isNotEmpty((Object)this.appSceneConfigService.list((Wrapper)new LambdaQueryWrapper().in(AppSceneConfig::getAppPkId, Arrays.asList(ids))))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        return super.removeByIds(Arrays.asList(ids));
    }

    @HussarTokenDs
    public AppAccess getAppAccess(String appId, String appSecret) {
        if (HussarUtils.isEmpty((Object)appId)) {
            throw new HussarException("appId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(AppAccess::getAppId, (Object)appId);
        AppAccess appAccess = (AppAccess)this.getOne((Wrapper)qw);
        if (appAccess == null) {
            throw new HussarException("\u672a\u67e5\u5230\u6388\u6743\u4fe1\u606f");
        }
        if (appAccess.getStatus() == null || appAccess.getStatus() != 1) {
            throw new HussarException("\u6388\u6743\u672a\u542f\u7528");
        }
        return appAccess;
    }

    @HussarTokenDs
    public List<AppSceneVo> getAppService(AppServiceDto appServiceDto) {
        if (HussarUtils.isEmpty((Object)appServiceDto.getAppId())) {
            throw new HussarException("appId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)appServiceDto.getAppSecret())) {
            throw new HussarException("appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(AppAccess::getAppId, (Object)appServiceDto.getAppId());
        return this.getAppSceneTemplate((AppAccess)this.getOne((Wrapper)qw), appServiceDto.getSceneCategory());
    }

    @HussarTokenDs
    public List<AppSceneVo> getAppService2(AppServiceDto appServiceDto) {
        if (HussarUtils.isEmpty((Object)appServiceDto.getAppId())) {
            throw new HussarException("appId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)appServiceDto.getAppSecret())) {
            throw new HussarException("appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(AppAccess::getAppId, (Object)appServiceDto.getAppId());
        qw.lambda().eq(AppAccess::getAppSecret, (Object)appServiceDto.getAppSecret());
        qw.lambda().eq(AppAccess::getStatus, (Object)1);
        return this.convertServiceMap((AppAccess)this.getOne((Wrapper)qw));
    }

    @HussarTokenDs
    public List<AppSceneVo> getAppService(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException("\u67e5\u8be2\u670d\u52a1\u7c7b\u578b\u5931\u8d25\uff0c\u5e94\u7528\u4e3b\u952e\u4e3a\u7a7a\uff01");
        }
        return this.convertServiceMap((AppAccess)this.getById(id));
    }

    @HussarTokenDs
    public List<AppAccessQueryVo> bathFindById(List<Long> ids) {
        if (HussarUtils.isNotEmpty(ids)) {
            List appAccesses = this.list((Wrapper)new LambdaQueryWrapper().in(AppAccess::getId, ids));
            return HussarUtils.copy((Collection)appAccesses, AppAccessQueryVo.class);
        }
        return new ArrayList<AppAccessQueryVo>();
    }

    @HussarTokenDs
    public Long getAppAccessIdByAppId(String appId) {
        AppAccess appAccess = (AppAccess)this.getOne((Wrapper)new LambdaQueryWrapper().eq(AppAccess::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)appAccess)) {
            return appAccess.getId();
        }
        throw new HussarException("\u8be5\u5e94\u7528\u4e0d\u5b58\u5728");
    }

    public ApiResponse<List<AppAccess>> getStatusApp() {
        return ApiResponse.success((Object)super.list((Wrapper)new LambdaQueryWrapper().eq(AppAccess::getStatus, (Object)1)));
    }

    public List<AppSceneVo> convertServiceMap(AppAccess appAccess) {
        ArrayList<AppSceneVo> list = new ArrayList<AppSceneVo>();
        Map serviceMap = ServiceTypeEnum.getServiceMap();
        if (HussarUtils.isNotEmpty((Object)appAccess) && HussarUtils.isNotEmpty((Object)appAccess.getServiceType())) {
            for (String service : appAccess.getServiceType().split(",")) {
                AppSceneVo appSceneVo = new AppSceneVo();
                appSceneVo.setId(service);
                appSceneVo.setName((String)serviceMap.get(service));
                list.add(appSceneVo);
            }
        }
        return list;
    }

    private AppAccessQueryVo entity2QueryVo(AppAccess entity) {
        AppAccessQueryVo vo = new AppAccessQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }

    private List<AppSceneVo> getAppSceneTemplate(AppAccess appAccess, String sceneCategory) {
        List<AppSceneVo> serviceList = new ArrayList<AppSceneVo>();
        if (HussarUtils.isEmpty((Object)appAccess) || HussarUtils.isEmpty((Object)appAccess.getId())) {
            return serviceList;
        }
        List configJsonDataList = this.appSceneConfigService.getConfigDataTemplate(appAccess.getId(), sceneCategory);
        serviceList = this.convertServiceMap(appAccess);
        if (HussarUtils.isNotEmpty(serviceList) && HussarUtils.isNotEmpty((Object)configJsonDataList)) {
            block20: for (AppSceneVo appSceneVo : serviceList) {
                switch (appSceneVo.getId()) {
                    case "sms": {
                        appSceneVo.setTemplates(this.getSmsTemplates(appSceneVo.getId(), configJsonDataList));
                        continue block20;
                    }
                    case "mail": {
                        appSceneVo.setTemplates(this.getMailTemplates(appSceneVo.getId(), configJsonDataList));
                        continue block20;
                    }
                    case "wx_account": {
                        appSceneVo.setTemplates(this.getMpTemplates(appSceneVo.getId(), configJsonDataList));
                        continue block20;
                    }
                    case "app_push": {
                        appSceneVo.setTemplates(this.getAppPushTemplates(appSceneVo.getId(), configJsonDataList));
                        continue block20;
                    }
                    case "app_im": {
                        appSceneVo.setTemplates(this.getAppImTemplates(appSceneVo.getId(), configJsonDataList));
                        continue block20;
                    }
                    case "cp": {
                        appSceneVo.setTemplates(this.getCpTemplates(appSceneVo.getId(), configJsonDataList));
                        continue block20;
                    }
                    case "dingTalk": {
                        appSceneVo.setTemplates(this.getDingTalkTemplates(appSceneVo.getId(), configJsonDataList));
                        continue block20;
                    }
                    case "notice": {
                        appSceneVo.setTemplates(this.getNoticeTemplates(appSceneVo.getId(), configJsonDataList));
                        continue block20;
                    }
                }
            }
        }
        return serviceList;
    }

    private List<TemplateData> getSmsTemplates(String serviceType, List<ConfigJsonData> configJsonDataList) {
        ArrayList<TemplateData> smsTemplateDatas = new ArrayList<TemplateData>();
        List templateNo = configJsonDataList.stream().filter(o -> serviceType.equals(o.getChannelType())).map(ConfigJsonData::getTemplateNo).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(templateNo)) {
            List smsTemplates = this.smsTemplateService.list((Wrapper)new LambdaQueryWrapper().in(MsgSmsTemplate::getTemplateNo, templateNo));
            for (ConfigJsonData configJsonData : configJsonDataList) {
                if (!serviceType.equals(configJsonData.getChannelType())) continue;
                for (MsgSmsTemplate msgSmsTemplate : smsTemplates) {
                    if (!configJsonData.getTemplateNo().equals(msgSmsTemplate.getTemplateNo())) continue;
                    TemplateData templateData = new TemplateData();
                    templateData.setSceneName(configJsonData.getSceneName());
                    templateData.setTemplate(msgSmsTemplate.getTemplateContent());
                    smsTemplateDatas.add(templateData);
                }
            }
        }
        return smsTemplateDatas;
    }

    private List<TemplateData> getMailTemplates(String serviceType, List<ConfigJsonData> configJsonDataList) {
        ArrayList<TemplateData> mailTemplateDatas = new ArrayList<TemplateData>();
        List templateNo = configJsonDataList.stream().filter(o -> serviceType.equals(o.getChannelType())).map(ConfigJsonData::getTemplateNo).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(templateNo)) {
            List mailTemplates = this.mailTemplateService.list((Wrapper)new LambdaQueryWrapper().in(MsgMailTemplate::getTemplateNo, templateNo));
            for (ConfigJsonData configJsonData : configJsonDataList) {
                if (!serviceType.equals(configJsonData.getChannelType())) continue;
                for (MsgMailTemplate msgMailTemplate : mailTemplates) {
                    if (!configJsonData.getTemplateNo().equals(msgMailTemplate.getTemplateNo())) continue;
                    TemplateData templateData = new TemplateData();
                    templateData.setSceneName(configJsonData.getSceneName());
                    templateData.setTemplate(msgMailTemplate.getTemplateContent());
                    mailTemplateDatas.add(templateData);
                }
            }
        }
        return mailTemplateDatas;
    }

    private List<TemplateData> getMpTemplates(String serviceType, List<ConfigJsonData> configJsonDataList) {
        ArrayList<TemplateData> mpTemplateDatas = new ArrayList<TemplateData>();
        List templateNo = configJsonDataList.stream().filter(o -> serviceType.equals(o.getChannelType())).map(ConfigJsonData::getTemplateNo).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(templateNo)) {
            List mpTemplates = this.mpTemplateService.list((Wrapper)new LambdaQueryWrapper().in(MsgMpTemplate::getTemplateNo, templateNo));
            for (ConfigJsonData configJsonData : configJsonDataList) {
                if (!serviceType.equals(configJsonData.getChannelType())) continue;
                for (MsgMpTemplate mpTemplate : mpTemplates) {
                    if (!configJsonData.getTemplateNo().equals(mpTemplate.getTemplateNo())) continue;
                    TemplateData templateData = new TemplateData();
                    templateData.setSceneName(configJsonData.getSceneName());
                    templateData.setTemplate(mpTemplate.getContent());
                    mpTemplateDatas.add(templateData);
                }
            }
        }
        return mpTemplateDatas;
    }

    private List<TemplateData> getAppPushTemplates(String serviceType, List<ConfigJsonData> configJsonDataList) {
        ArrayList<TemplateData> AppPushTemplateDatas = new ArrayList<TemplateData>();
        List templateNo = configJsonDataList.stream().filter(o -> serviceType.equals(o.getChannelType())).map(ConfigJsonData::getTemplateNo).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(templateNo)) {
            List appPushTemplates = this.appPushTemplateMapper.selectList((Wrapper)new LambdaQueryWrapper().in(MsgAppPushTemplate::getTemplateNo, templateNo));
            for (ConfigJsonData configJsonData : configJsonDataList) {
                if (!serviceType.equals(configJsonData.getChannelType())) continue;
                for (MsgAppPushTemplate mpTemplate : appPushTemplates) {
                    if (!configJsonData.getTemplateNo().equals(mpTemplate.getTemplateNo())) continue;
                    TemplateData templateData = new TemplateData();
                    templateData.setSceneName(configJsonData.getSceneName());
                    templateData.setTemplate(mpTemplate.getContent());
                    AppPushTemplateDatas.add(templateData);
                }
            }
        }
        return AppPushTemplateDatas;
    }

    private List<TemplateData> getAppImTemplates(String serviceType, List<ConfigJsonData> configJsonDataList) {
        ArrayList<TemplateData> appImTemplateDataList = new ArrayList<TemplateData>();
        List templateNo = configJsonDataList.stream().filter(o -> serviceType.equals(o.getChannelType())).map(ConfigJsonData::getTemplateNo).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(templateNo)) {
            List appImTemplates = this.appImTemplateMapper.selectList((Wrapper)new LambdaQueryWrapper().in(MsgAppImTemplate::getTemplateNo, templateNo));
            for (ConfigJsonData configJsonData : configJsonDataList) {
                if (!serviceType.equals(configJsonData.getChannelType())) continue;
                for (MsgAppImTemplate mpTemplate : appImTemplates) {
                    if (!configJsonData.getTemplateNo().equals(mpTemplate.getTemplateNo())) continue;
                    TemplateData templateData = new TemplateData();
                    templateData.setSceneName(configJsonData.getSceneName());
                    templateData.setTemplate(mpTemplate.getContent());
                    appImTemplateDataList.add(templateData);
                }
            }
        }
        return appImTemplateDataList;
    }

    private List<TemplateData> getCpTemplates(String serviceType, List<ConfigJsonData> configJsonDataList) {
        ArrayList<TemplateData> cpTemplateDataList = new ArrayList<TemplateData>();
        List templateNo = configJsonDataList.stream().filter(o -> serviceType.equals(o.getChannelType())).map(ConfigJsonData::getTemplateNo).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(templateNo)) {
            List cpTemplates = this.cpTemplateMapper.selectList((Wrapper)new LambdaQueryWrapper().in(MsgCpTemplate::getTemplateNo, templateNo));
            for (ConfigJsonData configJsonData : configJsonDataList) {
                if (!serviceType.equals(configJsonData.getChannelType())) continue;
                for (MsgCpTemplate mpTemplate : cpTemplates) {
                    if (!configJsonData.getTemplateNo().equals(mpTemplate.getTemplateNo())) continue;
                    TemplateData templateData = new TemplateData();
                    templateData.setSceneName(configJsonData.getSceneName());
                    templateData.setTemplate(mpTemplate.getContent());
                    cpTemplateDataList.add(templateData);
                }
            }
        }
        return cpTemplateDataList;
    }

    private List<TemplateData> getDingTalkTemplates(String serviceType, List<ConfigJsonData> configJsonDataList) {
        ArrayList<TemplateData> dingTalkTemplateDataList = new ArrayList<TemplateData>();
        List templateNo = configJsonDataList.stream().filter(o -> serviceType.equals(o.getChannelType())).map(ConfigJsonData::getTemplateNo).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(templateNo)) {
            List dingTalkTemplates = this.dingTalkTemplateMapper.selectList((Wrapper)new LambdaQueryWrapper().in(MsgDingTalkTemplate::getTemplateNo, templateNo));
            for (ConfigJsonData configJsonData : configJsonDataList) {
                if (!serviceType.equals(configJsonData.getChannelType())) continue;
                for (MsgDingTalkTemplate mpTemplate : dingTalkTemplates) {
                    if (!configJsonData.getTemplateNo().equals(mpTemplate.getTemplateNo())) continue;
                    TemplateData templateData = new TemplateData();
                    templateData.setSceneName(configJsonData.getSceneName());
                    templateData.setTemplate(mpTemplate.getContent());
                    dingTalkTemplateDataList.add(templateData);
                }
            }
        }
        return dingTalkTemplateDataList;
    }

    private List<TemplateData> getNoticeTemplates(String serviceType, List<ConfigJsonData> configJsonDataList) {
        ArrayList<TemplateData> noticeTemplateDataList = new ArrayList<TemplateData>();
        List templateNo = configJsonDataList.stream().filter(o -> serviceType.equals(o.getChannelType())).map(ConfigJsonData::getTemplateNo).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(templateNo)) {
            List noticeTemplates = this.noticeTemplateMapper.selectList((Wrapper)new LambdaQueryWrapper().in(MsgNoticeTemplate::getTemplateNo, templateNo));
            for (ConfigJsonData configJsonData : configJsonDataList) {
                if (!serviceType.equals(configJsonData.getChannelType())) continue;
                for (MsgNoticeTemplate mpTemplate : noticeTemplates) {
                    if (!configJsonData.getTemplateNo().equals(mpTemplate.getTemplateNo())) continue;
                    TemplateData templateData = new TemplateData();
                    templateData.setSceneName(configJsonData.getSceneName());
                    templateData.setTemplate(mpTemplate.getContent());
                    noticeTemplateDataList.add(templateData);
                }
            }
        }
        return noticeTemplateDataList;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterUpdateApp(AppAccessUpdateDto updateDto) {
        this.applicationContext.publishEvent((ApplicationEvent)new MsgAfterUpdateAppEvent(updateDto));
    }

    public void afterDeleteApp(Long id) {
        this.applicationContext.publishEvent((ApplicationEvent)new MsgAfterDeleteAppEvent(id));
    }
}

