/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.thrid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.IdUtil;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordDto;
import com.jxdinfo.hussar.msg.sms.service.SmsSendRecordService;
import com.jxdinfo.hussar.msg.sms.third.service.SmsThirdSendService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.sms.v20210111.SmsClient;
import com.tencentcloudapi.sms.v20210111.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20210111.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20210111.models.SendStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="TENCENT")
public class TencentSmsThirdSendServiceImpl
implements SmsThirdSendService {
    private static final Logger logger = LoggerFactory.getLogger(TencentSmsThirdSendServiceImpl.class);
    private static final String PATTERN_CONTENT = "\\{(.*?)\\}";
    @Autowired
    private SmsSendRecordService smsSendRecordService;
    @Autowired
    private MsgJobService msgJobService;

    private SmsClient createClient(String accessKeyId, String accessKeySecret, String region) {
        Credential cred = new Credential(accessKeyId, accessKeySecret);
        HttpProfile httpProfile = new HttpProfile();
        httpProfile.setEndpoint("sms.tencentcloudapi.com");
        ClientProfile clientProfile = new ClientProfile();
        clientProfile.setHttpProfile(httpProfile);
        return new SmsClient(cred, region, clientProfile);
    }

    public boolean sendSms(SmsSendRecordDto record) throws TencentCloudSDKException {
        SmsClient client = this.createClient(record.getAccessKeyId(), record.getAccessKeySecret(), record.getRegion());
        Object[] phoneNumber = record.getPhoneNumber().split(",");
        if (ToolUtil.isNotEmpty((Object)record.getContent()) && ToolUtil.isNotEmpty((Object)record.getParams())) {
            LinkedList<String> contents = new LinkedList<String>();
            String[] params = record.getParams().split(",");
            Pattern pattern = Pattern.compile(PATTERN_CONTENT);
            Matcher matcher = pattern.matcher(record.getContent());
            while (matcher.find()) {
                String group = matcher.group(1);
                contents.add(group);
            }
            String content = record.getContent();
            for (int i = 0; i < contents.size(); ++i) {
                content = params.length > i ? content.replace("{" + (String)contents.get(i) + "}", params[i]) : content.replace("{" + (String)contents.get(i) + "}", "");
            }
            record.setContent(content);
        }
        boolean flag = true;
        if (record.getTim() != null && record.getTim().booleanValue()) {
            Date now = new Date();
            Date sendTime = record.getJobTime();
            String id = IdUtil.fastSimpleUuid();
            SmsSendRecordDto jobParams = new SmsSendRecordDto();
            jobParams.setMsgId(id);
            jobParams.setPhoneNumber(Arrays.toString(phoneNumber));
            jobParams.setSmsSdkAppId(record.getSmsSdkAppId());
            jobParams.setSignName(record.getSignName());
            jobParams.setTemplateCode(record.getTemplateCode());
            jobParams.setParams(record.getParams());
            jobParams.setChannelType(record.getChannelType());
            jobParams.setAccessKeyId(record.getAccessKeyId());
            jobParams.setAccessKeySecret(record.getAccessKeySecret());
            jobParams.setRegion(record.getRegion());
            this.msgJobService.saveMsgJob(record.getJobTime(), JSONObject.toJSONString((Object)jobParams), MsgJobEnum.MSG_SMS);
            record.setSendTime(sendTime);
            record.setParams(record.getParams());
            record.setPhoneNumber(Arrays.toString(phoneNumber));
            record.setErrMsg("");
            record.setStatus(SendStatusEnum.SENDING.getCode());
            record.setBizId("");
            record.setCreateTime(now);
            record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.smsSendRecordService.save(record);
        } else {
            SendSmsRequest req = new SendSmsRequest();
            req.setPhoneNumberSet((String[])phoneNumber);
            req.setSmsSdkAppId(record.getSmsSdkAppId());
            req.setSignName(record.getSignName());
            req.setTemplateId(record.getTemplateCode());
            if (HussarUtils.isNotEmpty((Object)record.getParams())) {
                req.setTemplateParamSet(record.getParams().split(","));
            }
            SendSmsResponse resp = new SendSmsResponse();
            try {
                resp = client.SendSms(req);
            }
            catch (Exception e) {
                record.setErrMsg(e.getMessage());
                record.setStatus(SendStatusEnum.FAIL.getCode());
                flag = false;
                logger.error("\u53d1\u9001\u77ed\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
            }
            if (flag) {
                SendStatus sendStatus = new ArrayList<SendStatus>(Arrays.asList(resp.getSendStatusSet())).get(0);
                record.setErrMsg(sendStatus.getMessage());
                record.setStatus("Ok".equals(sendStatus.getCode()) ? SendStatusEnum.SUCCESS.getCode() : SendStatusEnum.FAIL.getCode());
                record.setBizId(sendStatus.getSerialNo());
                if (!"Ok".equals(sendStatus.getCode())) {
                    logger.error("\u53d1\u9001\u77ed\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a" + sendStatus.getMessage());
                }
            }
            Date sentTime = new Date();
            Date now = new Date();
            record.setSendTime(sentTime);
            record.setPhoneNumber(Arrays.toString(phoneNumber));
            record.setCreateTime(now);
            record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.smsSendRecordService.save(record);
        }
        return flag;
    }

    public boolean jobSend(SmsSendRecordDto dto) throws Exception {
        SmsClient client = this.createClient(dto.getAccessKeyId(), dto.getAccessKeySecret(), dto.getRegion());
        SmsSendRecordDto msgSmsSendRecord = this.smsSendRecordService.findById(dto.getMsgId());
        if (HussarUtils.isEmpty((Object)msgSmsSendRecord)) {
            logger.error("\u5b9a\u65f6\u63a8\u9001\u77ed\u4fe1\uff0c\u6d88\u606f\u8bb0\u5f55\u67e5\u8be2\u4e0d\u5b58\u5728\uff0c\u6d88\u606fid:{}", (Object)dto.getMsgId());
        }
        if (ToolUtil.isNotEmpty((Object)msgSmsSendRecord.getId())) {
            SendSmsRequest req = new SendSmsRequest();
            req.setPhoneNumberSet(msgSmsSendRecord.getPhoneNumber().split(","));
            req.setSmsSdkAppId(msgSmsSendRecord.getSmsSdkAppId());
            req.setSignName(msgSmsSendRecord.getSignName());
            req.setTemplateId(msgSmsSendRecord.getTemplateCode());
            if (HussarUtils.isNotEmpty((Object)msgSmsSendRecord.getParams())) {
                req.setTemplateParamSet(msgSmsSendRecord.getParams().split(","));
            }
            try {
                SendSmsResponse resp = client.SendSms(req);
                SendStatus sendStatus = resp.getSendStatusSet()[0];
                msgSmsSendRecord.setErrMsg(sendStatus.getMessage());
                msgSmsSendRecord.setStatus("Ok".equals(sendStatus.getCode()) ? SendStatusEnum.SUCCESS.getCode() : SendStatusEnum.FAIL.getCode());
                msgSmsSendRecord.setBizId(sendStatus.getSerialNo());
            }
            catch (Exception e) {
                msgSmsSendRecord.setErrMsg(e.getMessage());
                msgSmsSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
                logger.error("\u53d1\u9001\u77ed\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
            }
            msgSmsSendRecord.setSendTime(new Date());
            this.smsSendRecordService.save(msgSmsSendRecord);
        }
        return true;
    }
}

