/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.sms.dao.MsgSmsChannelMapper;
import com.jxdinfo.hussar.msg.sms.dto.SmsChannelCreateDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsChannelPageDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsChannelQueryVo;
import com.jxdinfo.hussar.msg.sms.dto.SmsChannelUpdateDto;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsChannel;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsSign;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsTemplate;
import com.jxdinfo.hussar.msg.sms.service.SmsChannelService;
import com.jxdinfo.hussar.msg.sms.service.SmsSignService;
import com.jxdinfo.hussar.msg.sms.service.SmsTemplateService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SmsChannelServiceImpl
extends HussarServiceImpl<MsgSmsChannelMapper, MsgSmsChannel>
implements SmsChannelService {
    @Autowired
    private SmsSignService smsSignService;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<MsgSmsChannel> listPage(Page page, SmsChannelPageDto pageDto) {
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelName())) {
            pageDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelName().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelNo())) {
            pageDto.setChannelNo(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelNo().trim()));
        }
        IPage<MsgSmsChannel> pageList = ((MsgSmsChannelMapper)this.baseMapper).queryPage(page, pageDto);
        return pageList;
    }

    public List<SmsChannelQueryVo> queryList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgSmsChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public SmsChannelQueryVo findById(Long id) {
        MsgSmsChannel entity = (MsgSmsChannel)super.getById((Serializable)id);
        return this.entity2QueryVo(entity);
    }

    @HussarTransactional
    public boolean save(SmsChannelCreateDto createDto) {
        MsgSmsChannel entity = new MsgSmsChannel();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        entity.setChannelNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.MSM_CHANNEL));
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(entity))) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + entity.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        super.save((BaseEntity)entity);
        return true;
    }

    @HussarTransactional
    public boolean updateById(SmsChannelUpdateDto updateDto) {
        MsgSmsChannel entity = new MsgSmsChannel();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(entity))) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + entity.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        MsgSmsChannel msgSmsChannel = (MsgSmsChannel)super.getById((Serializable)updateDto.getId());
        if (!HussarUtils.equals((Object)msgSmsChannel.getStatus(), (Object)updateDto.getStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(msgSmsChannel.getChannelNo())))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u65e0\u6cd5\u4fee\u6539\u542f\u52a8\u72b6\u6001\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        super.updateById((BaseEntity)entity);
        return true;
    }

    @HussarTransactional
    public boolean delete(Long id) {
        MsgSmsChannel msgSmsChannel = (MsgSmsChannel)((MsgSmsChannelMapper)this.baseMapper).selectById(id);
        if (this.appSceneConfigService.isExistScene(msgSmsChannel.getChannelNo())) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgSmsSign::getChannelId, (Object)msgSmsChannel.getId());
        long signCount = this.smsSignService.count((Wrapper)qw);
        if (signCount > 0L) {
            throw new HussarException("\u8be5\u901a\u9053\u4e0b\u5b58\u5728\u7b7e\u540d,\u8bf7\u5148\u5220\u9664\u7b7e\u540d");
        }
        QueryWrapper qw1 = new QueryWrapper();
        qw1.lambda().eq(MsgSmsTemplate::getChannelId, (Object)msgSmsChannel.getId());
        long templateCount = this.smsTemplateService.count((Wrapper)qw1);
        if (templateCount > 0L) {
            throw new HussarException("\u8be5\u901a\u9053\u4e0b\u5b58\u5728\u6a21\u677f,\u8bf7\u5148\u5220\u9664\u6a21\u677f");
        }
        super.removeById((Serializable)id);
        return true;
    }

    public boolean updateStatus(Long id) {
        MsgSmsChannel msgSmsChannel = (MsgSmsChannel)super.getById((Serializable)id);
        if (HussarUtils.isEmpty((Object)msgSmsChannel)) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053\u6570\u636e");
        }
        MsgSmsChannel entity = new MsgSmsChannel();
        entity.setId(id);
        entity.setStatus(msgSmsChannel.getStatus().equals(OpenStatusEnum.DISABLED.getCode()) ? OpenStatusEnum.ENABLE.getCode() : OpenStatusEnum.DISABLED.getCode());
        return super.updateById((BaseEntity)entity);
    }

    public List<SmsChannelQueryVo> getChannelList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgSmsChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgSmsChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    @HussarTransactional
    public boolean deleteChannelByIds(Long[] ids) {
        List channelNos = super.listByIds(Arrays.asList(ids)).stream().map(MsgSmsChannel::getChannelNo).collect(Collectors.toList());
        if (this.appSceneConfigService.isExistSceneInBatch(channelNos)) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        for (Long id : ids) {
            MsgSmsChannel msgSmsChannel = (MsgSmsChannel)((MsgSmsChannelMapper)this.baseMapper).selectById(id);
            QueryWrapper qw = new QueryWrapper();
            qw.lambda().eq(MsgSmsSign::getChannelId, (Object)msgSmsChannel.getId());
            long signCount = this.smsSignService.count((Wrapper)qw);
            if (signCount > 0L) {
                throw new HussarException("\u5220\u9664\u5931\u8d25! '" + msgSmsChannel.getChannelName() + "'\u901a\u9053\u4e0b\u5b58\u5728\u7b7e\u540d,\u8bf7\u5148\u5220\u9664\u7b7e\u540d");
            }
            QueryWrapper qw1 = new QueryWrapper();
            qw1.lambda().eq(MsgSmsTemplate::getChannelId, (Object)msgSmsChannel.getId());
            long templateCount = this.smsTemplateService.count((Wrapper)qw1);
            if (templateCount <= 0L) continue;
            throw new HussarException("\u5220\u9664\u5931\u8d25! '" + msgSmsChannel.getChannelName() + "'\u901a\u9053\u4e0b\u5b58\u5728\u6a21\u677f,\u8bf7\u5148\u5220\u9664\u6a21\u677f");
        }
        super.removeByIds(Arrays.asList(ids));
        return true;
    }

    public MsgSmsChannel getChannelInfo(String channelNo) {
        return ((MsgSmsChannelMapper)this.baseMapper).getChannelInfo(channelNo);
    }

    public Map<String, String> getChannelNoAndName(List<String> channelNos) {
        if (HussarUtils.isEmpty(channelNos)) {
            return new HashMap<String, String>();
        }
        Map<String, String> channelNoAndName = super.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{MsgSmsChannel::getChannelNo, MsgSmsChannel::getChannelName}).in(MsgSmsChannel::getChannelNo, channelNos)).stream().collect(Collectors.toMap(MsgSmsChannel::getChannelNo, MsgSmsChannel::getChannelName));
        channelNoAndName.put("null", "\u65e0\u901a\u9053\u6807\u8bc6\u8bb0\u5f55");
        return channelNoAndName;
    }

    private SmsChannelQueryVo entity2QueryVo(MsgSmsChannel entity) {
        SmsChannelQueryVo vo = new SmsChannelQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }

    private String checkChannelUnique(MsgSmsChannel entity) {
        Long id = HussarUtils.isEmpty((Object)entity.getId()) ? -1L : entity.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgSmsChannel::getChannelName, (Object)entity.getChannelName());
        MsgSmsChannel info = (MsgSmsChannel)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)info) && !HussarUtils.equals((Object)info.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

