/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.controller;

import com.jxdinfo.hussar.msg.common.model.MsgAppAccessBean;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.sms.dto.SmsChannelQueryVo;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendMsgCreateDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsSignQueryVo;
import com.jxdinfo.hussar.msg.sms.dto.SmsTemplateQueryVo;
import com.jxdinfo.hussar.msg.sms.service.SmsChannelService;
import com.jxdinfo.hussar.msg.sms.service.SmsSendService;
import com.jxdinfo.hussar.msg.sms.service.SmsSignService;
import com.jxdinfo.hussar.msg.sms.service.SmsTemplateService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.exception.HussarException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u77ed\u4fe1\u53d1\u9001\u6d4b\u8bd5"})
@RequestMapping(value={"msg/sms/test"})
public class SmsTestSendController {
    @Autowired
    private SmsChannelService smsChannelService;
    @Autowired
    private SmsSignService smsSignService;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private SmsSendService smsSendService;

    @GetMapping(value={"/getChannelList"})
    @ApiOperation(value="\u83b7\u53d6\u77ed\u4fe1\u901a\u9053\u5217\u8868", notes="\u83b7\u53d6\u77ed\u4fe1\u901a\u9053\u5217\u8868")
    @AuditLog(moduleName="\u77ed\u4fe1\u53d1\u9001\u6d4b\u8bd5", eventDesc="\u83b7\u53d6\u77ed\u4fe1\u901a\u9053\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SmsChannelQueryVo>> getChannelList() {
        return ApiResponse.success((Object)this.smsChannelService.getChannelList());
    }

    @GetMapping(value={"/getChannelById/{id}"})
    @ApiOperation(value="\u901a\u8fc7\u901a\u9053id\u83b7\u53d6\u77ed\u4fe1\u901a\u9053\u8be6\u60c5", notes="\u901a\u8fc7\u901a\u9053id\u83b7\u53d6\u77ed\u4fe1\u901a\u9053\u8be6\u60c5")
    @AuditLog(moduleName="\u77ed\u4fe1\u53d1\u9001\u6d4b\u8bd5", eventDesc="\u901a\u8fc7\u901a\u9053id\u83b7\u53d6\u77ed\u4fe1\u901a\u9053\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SmsChannelQueryVo> findById(@PathVariable(value="id") Long id) {
        return ApiResponse.success((Object)this.smsChannelService.findById(id));
    }

    @GetMapping(value={"/getSignListByChannelId/{channelId}"})
    @ApiOperation(value="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u7b7e\u540d\u5217\u8868", notes="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u7b7e\u540d\u5217\u8868")
    @AuditLog(moduleName="\u77ed\u4fe1\u53d1\u9001\u6d4b\u8bd5", eventDesc="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u7b7e\u540d\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SmsSignQueryVo>> getSignListByChannelId(@PathVariable(value="channelId") Long channelId) {
        return ApiResponse.success((Object)this.smsSignService.getSignListByChannelId(channelId));
    }

    @GetMapping(value={"/getTemplateListByChannelId/{channelId}"})
    @ApiOperation(value="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u6a21\u677f\u5217\u8868", notes="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u6a21\u677f\u5217\u8868")
    @AuditLog(moduleName="\u77ed\u4fe1\u53d1\u9001\u6d4b\u8bd5", eventDesc="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u6a21\u677f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SmsTemplateQueryVo>> getTemplateListByChannelId(@PathVariable(value="channelId") Long channelId) {
        return ApiResponse.success((Object)this.smsTemplateService.getTemplateListByChannelId(channelId));
    }

    @PostMapping(value={"/sendSmsMsg"})
    @ApiOperation(value="\u53d1\u9001\u6d4b\u8bd5\u6d88\u606f", notes="\u53d1\u9001\u6d4b\u8bd5\u6d88\u606f")
    @AuditLog(moduleName="\u77ed\u4fe1\u53d1\u9001\u6d4b\u8bd5", eventDesc="\u53d1\u9001\u6d4b\u8bd5\u6d88\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> testSendSmsMsg(@Validated @RequestBody SmsSendMsgCreateDto createDto) {
        TenantCodeUtils.fillTestTenantCode((MsgAppAccessBean)createDto);
        if (this.smsSendService.testSendSmsMsg(createDto)) {
            return ApiResponse.success();
        }
        throw new HussarException("\u53d1\u9001\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u53d1\u9001\u8bb0\u5f55\uff01");
    }
}

