/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.notice.third.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.msg.notice.dto.NoticeSendRecordDto;
import com.jxdinfo.hussar.msg.notice.model.Notice;
import com.jxdinfo.hussar.msg.notice.service.NoticeSendRecordService;
import com.jxdinfo.hussar.msg.notice.third.service.NoticeSendThirdService;
import com.jxdinfo.hussar.msg.notice.vo.NoticeSendRecordQueryVo;
import com.jxdinfo.hussar.notice.bo.SysNoticeAttachmentBo;
import com.jxdinfo.hussar.notice.model.SysNotice;
import com.jxdinfo.hussar.notice.service.IMyNoticeAttachmentService;
import com.jxdinfo.hussar.notice.service.IMyNoticeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.time.LocalDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class NoticeSendThirdServiceImpl
implements NoticeSendThirdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoticeSendThirdServiceImpl.class);
    @Autowired
    private MsgJobService msgJobService;
    @Autowired
    private NoticeSendRecordService noticeSendRecordService;
    @Autowired(required=false)
    private IMyNoticeService myNoticeService;
    @Autowired(required=false)
    private IMyNoticeAttachmentService myNoticeAttachmentService;

    public Boolean sendMsgTimNotice(Notice sysNotice) {
        sysNotice.setId(null);
        Date now = new Date();
        Date sendTime = new Date();
        String errMsg = "";
        Integer status = SendStatusEnum.SENDING.getCode();
        if (sysNotice.getTim() != null && sysNotice.getTim().booleanValue()) {
            sendTime = sysNotice.getJobTime();
            this.msgJobService.saveMsgJob(sysNotice.getJobTime(), JSONObject.toJSONString((Object)sysNotice), MsgJobEnum.MSG_NOTICE);
        } else {
            NoticeSendRecordDto resultSend = this.sendThirdNotice(sysNotice);
            status = resultSend.getStatus();
            errMsg = resultSend.getErrMsg();
        }
        NoticeSendRecordDto noticeSendRecordDto = (NoticeSendRecordDto)HussarUtils.copy((Object)sysNotice, NoticeSendRecordDto.class);
        noticeSendRecordDto.setReleaseDate(sendTime);
        noticeSendRecordDto.setSendTime(sendTime);
        noticeSendRecordDto.setStatus(status);
        noticeSendRecordDto.setErrMsg(errMsg);
        noticeSendRecordDto.setCreateTime(now);
        noticeSendRecordDto.setCreateDateNotHour(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        noticeSendRecordDto.setTenantCode(sysNotice.getTenantCode());
        this.noticeSendRecordService.saveRecord(noticeSendRecordDto);
        return !SendStatusEnum.FAIL.getCode().equals(status);
    }

    public Boolean jonSendNotice(Notice notice) {
        NoticeSendRecordDto resultSend = this.sendThirdNotice(notice);
        NoticeSendRecordQueryVo noticeSendRecordQueryVo = this.noticeSendRecordService.findById(notice.getId());
        if (noticeSendRecordQueryVo.getId() != null) {
            noticeSendRecordQueryVo.setSendTime(new Date());
            noticeSendRecordQueryVo.setStatus(resultSend.getStatus());
            noticeSendRecordQueryVo.setErrMsg(resultSend.getErrMsg());
            this.noticeSendRecordService.saveRecord((NoticeSendRecordDto)HussarUtils.copy((Object)noticeSendRecordQueryVo, NoticeSendRecordDto.class));
        }
        return true;
    }

    private NoticeSendRecordDto sendThirdNotice(Notice sysNotice) {
        NoticeSendRecordDto noticeSendRecordDto = new NoticeSendRecordDto();
        try {
            SysNotice sysNotice1 = new SysNotice();
            BeanUtils.copyProperties((Object)sysNotice, (Object)sysNotice1);
            sysNotice1.setCreateTime(LocalDateTime.now());
            if (sysNotice1.getReleaseDate() == null) {
                sysNotice1.setReleaseDate(LocalDateTime.now());
            }
            ApiResponse apiResponse = this.myNoticeService.insertOrUpdate(sysNotice1);
            if (ToolUtil.isNotEmpty((Object)sysNotice.getNoticeAttachmentId())) {
                SysNoticeAttachmentBo sysNoticeAttachment = new SysNoticeAttachmentBo();
                sysNoticeAttachment.setNoticeAttachmentId(sysNotice.getNoticeAttachmentId());
                sysNoticeAttachment.setNoticeId(Long.valueOf(Long.parseLong(apiResponse.getData().toString())));
                sysNoticeAttachment.setCreateTime(LocalDateTime.now());
                this.myNoticeAttachmentService.insertOrUpdate(sysNoticeAttachment);
            }
            noticeSendRecordDto.setStatus(SendStatusEnum.SUCCESS.getCode());
            noticeSendRecordDto.setErrMsg(SendStatusEnum.SUCCESS.getName());
        }
        catch (Exception e) {
            LOGGER.error("\u5185\u90e8\u6d88\u606f\u53d1\u9001\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
            noticeSendRecordDto.setStatus(SendStatusEnum.FAIL.getCode());
            noticeSendRecordDto.setErrMsg(e.getMessage());
        }
        return noticeSendRecordDto;
    }
}

