/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.factory.MsgUnitySendFactory;
import com.jxdinfo.hussar.msg.notice.dto.NoticeSendRecordDto;
import com.jxdinfo.hussar.msg.notice.model.MsgNoticeTemplate;
import com.jxdinfo.hussar.msg.notice.model.Notice;
import com.jxdinfo.hussar.msg.notice.service.MsgNoticeSendAsyncService;
import com.jxdinfo.hussar.msg.notice.service.MsgNoticeTemplateService;
import com.jxdinfo.hussar.msg.notice.service.NoticeSendRecordService;
import com.jxdinfo.hussar.msg.notice.third.service.NoticeSendThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.model.MsgBasicSendRecord;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class NoticeUnitySendServiceImpl
implements MsgUnitySendFrameService,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoticeUnitySendServiceImpl.class);
    @Autowired
    private MsgNoticeSendAsyncService msgNoticeSendAsyncService;
    @Autowired
    private MsgNoticeTemplateService msgNoticeTemplateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired
    private NoticeSendThirdService noticeSendThirdService;
    @Autowired
    private NoticeSendRecordService noticeSendRecordService;

    public MsgBasicSendRecord msgUnitySendBefore(MsgUnitySendDto msgUnitySendDto) {
        Notice notice = new Notice();
        try {
            Map incompleteTemplateParams = msgUnitySendDto.getIncompleteTemplateParams();
            if (HussarUtils.isEmpty((Object)incompleteTemplateParams)) {
                throw new BaseException("\u5185\u90e8\u901a\u77e5incompleteTemplateParams\u53c2\u6570\u4e3a\u7a7a");
            }
            notice = (Notice)JSON.parseObject((String)JSON.toJSONString((Object)incompleteTemplateParams), Notice.class);
            if (HussarUtils.isEmpty((Object)notice.getDepartmentId()) && HussarUtils.isEmpty((Object)notice.getRoleId())) {
                this.saveFailRecord(notice, new RuntimeException("\u65e0\u53ef\u7528\u8054\u7cfb\u5730\u5740\uff01"));
                return null;
            }
            LOGGER.info("\u5f53\u524d\u90e8\u95e8ID\u4e3a{}\uff0c\u89d2\u8272ID\u4e3a{}\uff0c\u6b63\u5728\u8fdb\u884c\u5185\u90e8\u901a\u77e5\u63a8\u9001", (Object)notice.getDepartmentId(), (Object)notice.getRoleId());
            AppSceneConfig appSceneConfig = (AppSceneConfig)this.appSceneConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)msgUnitySendDto.getSceneCode()));
            String sceneCode = appSceneConfig.getSceneCode();
            Long appAccessId = appSceneConfig.getAppPkId();
            notice.setSceneName(appSceneConfig.getSceneName());
            notice.setSceneCode(sceneCode);
            AppAccess appAccess = (AppAccess)this.appAccessService.getById((Serializable)appAccessId);
            notice.setAppId(appAccess.getAppId());
            notice.setAppName(appAccess.getAppName());
            ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(sceneCode, appAccessId.toString(), ServiceTypeEnum.NOTICE.getCode());
            String templateNo = configJsonData.getTemplateNo();
            MsgNoticeTemplate msgNoticeTemplate = (MsgNoticeTemplate)this.msgNoticeTemplateService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgNoticeTemplate::getTemplateNo, (Object)templateNo));
            notice.setTemplateNo(msgNoticeTemplate.getTemplateNo());
            notice.setTemplateName(msgNoticeTemplate.getTemplateName());
            notice.setNoticeTitle(msgNoticeTemplate.getTitle());
            notice.setNoticeContent(msgNoticeTemplate.getContent());
            notice.setNoticeParams(TemplateUtils.getCurrentTemplateParams((Map)msgUnitySendDto.getTemplateParams(), (String)msgNoticeTemplate.getTemplateParams()));
            this.replaceContent(notice);
            notice.setTenantCode(msgUnitySendDto.getTenantCode());
        }
        catch (Exception e) {
            this.saveFailRecord(notice, e);
            throw e;
        }
        this.noticeSendThirdService.sendMsgTimNotice(notice);
        return null;
    }

    public String getMsgSendType() {
        return null;
    }

    public boolean msgUnityThirdSend(MsgBasicSendRecord msgBasicSendRecord) {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        MsgUnitySendFactory.setSendBeansToMap("notice", this);
    }

    private void replaceContent(Notice notice) {
        String content = notice.getNoticeContent();
        String title = notice.getNoticeTitle();
        Map noticeParams = notice.getNoticeParams();
        if (HussarUtils.isNotEmpty((Object)noticeParams)) {
            notice.setNoticeContent(TemplateUtils.replaceParams((String)content, (Map)noticeParams));
            notice.setNoticeTitle(TemplateUtils.replaceParams((String)title, (Map)noticeParams));
        }
    }

    private void saveFailRecord(Notice notice, Exception e) {
        notice.setId(null);
        Date now = new Date();
        Date sendTime = new Date();
        Integer status = SendStatusEnum.FAIL.getCode();
        NoticeSendRecordDto noticeSendRecordDto = new NoticeSendRecordDto();
        HussarUtils.copy((Object)notice, (Object)noticeSendRecordDto);
        noticeSendRecordDto.setReleaseDate(sendTime);
        noticeSendRecordDto.setSendTime(sendTime);
        noticeSendRecordDto.setStatus(status);
        noticeSendRecordDto.setErrMsg("\u7ec4\u88c5\u53d1\u9001\u53c2\u6570\u53d1\u751f\u5f02\u5e38\uff1a" + (HussarUtils.isNotEmpty((Object)e.getMessage()) ? e.getMessage() : e.getClass().getName()));
        noticeSendRecordDto.setCreateTime(now);
        noticeSendRecordDto.setCreateDateNotHour(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        this.noticeSendRecordService.saveRecord(noticeSendRecordDto);
    }
}

