/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mp.thrid.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.IdUtil;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.msg.mp.dto.MpSendMsgConfigDto;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordDto;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordQueryVo;
import com.jxdinfo.hussar.msg.mp.dto.WxMpSendMsgReqDtoDto;
import com.jxdinfo.hussar.msg.mp.service.MpSendRecordService;
import com.jxdinfo.hussar.msg.mp.third.service.MpSendMsgThirdService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class WixiMpSendMsgThirdServiceImpl
implements MpSendMsgThirdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WixiMpSendMsgThirdServiceImpl.class);
    @Autowired
    private MsgJobService msgJobService;
    @Autowired
    private MpSendRecordService mpSendRecordService;

    public boolean sendMpTimMsg(MpSendRecordDto mpSendRecordDto) {
        mpSendRecordDto.setId(null);
        if (mpSendRecordDto.getTim() != null && mpSendRecordDto.getTim().booleanValue()) {
            for (String toUser : mpSendRecordDto.getToUser().split(",")) {
                mpSendRecordDto.setToUser(toUser);
                String msgId = IdUtil.fastSimpleUuid();
                mpSendRecordDto.setMsgId(msgId);
                this.msgJobService.saveMsgJob(mpSendRecordDto.getJobTime(), JSON.toJSONString((Object)mpSendRecordDto), MsgJobEnum.MSG_MP);
                Date now = new Date();
                mpSendRecordDto.setCreateTime(now);
                mpSendRecordDto.setSendTime(mpSendRecordDto.getJobTime());
                mpSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
                this.mpSendRecordService.saveRecord(mpSendRecordDto);
            }
            return true;
        }
        return this.sendCpThirdMsg(mpSendRecordDto);
    }

    public boolean jobMsg(MpSendRecordDto mpSendRecordDto) {
        this.sendCpThirdMsg(mpSendRecordDto);
        MpSendRecordQueryVo mpSendRecordQueryVo = this.mpSendRecordService.findById(mpSendRecordDto.getMsgId());
        if (HussarUtils.isNotEmpty((Object)mpSendRecordQueryVo.getId())) {
            mpSendRecordQueryVo.setStatus(mpSendRecordDto.getStatus());
            mpSendRecordQueryVo.setErrMsg(mpSendRecordDto.getErrMsg());
            this.mpSendRecordService.saveRecord((MpSendRecordDto)HussarUtils.copy((Object)mpSendRecordQueryVo, MpSendRecordDto.class));
        }
        return true;
    }

    private boolean sendCpThirdMsg(MpSendRecordDto mpSendRecordDto) {
        boolean flag = true;
        for (String toUser : mpSendRecordDto.getToUser().split(",")) {
            mpSendRecordDto.setToUser(toUser);
            Integer status = SendStatusEnum.SUCCESS.getCode();
            mpSendRecordDto.setErrMsg(null);
            WxMpSendMsgReqDtoDto mpConfig = new WxMpSendMsgReqDtoDto();
            mpConfig.setToUser(toUser);
            mpConfig.setTemplateId(mpSendRecordDto.getTemplateBizId());
            mpConfig.setUrl(mpSendRecordDto.getUrl());
            Map mpParams = mpSendRecordDto.getMpParams();
            List<WxMpTemplateData> wxMpTemplateDatas = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)mpParams)) {
                for (Map.Entry mpParam : mpParams.entrySet()) {
                    WxMpTemplateData wxMpTemplateData = new WxMpTemplateData();
                    wxMpTemplateData.setName((String)mpParam.getKey());
                    wxMpTemplateData.setValue(mpParam.getValue().toString());
                    wxMpTemplateDatas.add(wxMpTemplateData);
                }
            } else {
                wxMpTemplateDatas = JSON.parseArray((String)mpSendRecordDto.getContent(), WxMpTemplateData.class);
            }
            mpConfig.setData(wxMpTemplateDatas);
            mpConfig.setAppId(mpSendRecordDto.getKeyId());
            mpConfig.setSecret(mpSendRecordDto.getKeySecret());
            try {
                this.sendTemplateMsg(mpConfig);
                mpSendRecordDto.setErrMsg(SendStatusEnum.SUCCESS.getName());
            }
            catch (Exception e) {
                LOGGER.error("\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
                status = SendStatusEnum.FAIL.getCode();
                if (HussarUtils.isNotBlank((CharSequence)e.getMessage())) {
                    mpSendRecordDto.setErrMsg(e.getMessage());
                } else {
                    mpSendRecordDto.setErrMsg("\u53d1\u9001\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a: " + e.getClass().getName());
                }
                flag = false;
            }
            mpSendRecordDto.setStatus(status);
            if (!HussarUtils.isEmpty((Object)mpSendRecordDto.getMsgId())) continue;
            Date now = new Date();
            mpSendRecordDto.setCreateTime(now);
            Date sendTime = new Date();
            mpSendRecordDto.setSendTime(sendTime);
            mpSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.mpSendRecordService.saveRecord(mpSendRecordDto);
        }
        return flag;
    }

    public String sendTemplateMsg(WxMpSendMsgReqDtoDto mpConfig) throws Exception {
        WxMpService wxMpService = this.getWxMpService((MpSendMsgConfigDto)mpConfig);
        WxMpTemplateMessage templateMessage = new WxMpTemplateMessage();
        BeanUtils.copyProperties((Object)mpConfig, (Object)templateMessage);
        String status = wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
        if (status == null) {
            throw new HussarException("\u53d1\u9001\u6a21\u677f\u6d88\u606f\u5931\u8d25");
        }
        return status;
    }

    public WxMpService getWxMpService(MpSendMsgConfigDto mpSendMsgConfigDto) {
        WxMpServiceImpl service = new WxMpServiceImpl();
        HashMap<String, WxMpDefaultConfigImpl> configStorages = new HashMap<String, WxMpDefaultConfigImpl>();
        WxMpDefaultConfigImpl configStorage = new WxMpDefaultConfigImpl();
        configStorage.setAppId(mpSendMsgConfigDto.getAppId());
        configStorage.setSecret(mpSendMsgConfigDto.getSecret());
        configStorages.put(mpSendMsgConfigDto.getAppId(), configStorage);
        service.setMultiConfigStorages(configStorages);
        return service;
    }
}

