/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.utils.PrintPushLogsUtils;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.factory.MsgUnitySendFactory;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordDto;
import com.jxdinfo.hussar.msg.mp.model.MsgMpChannel;
import com.jxdinfo.hussar.msg.mp.model.MsgMpTemplate;
import com.jxdinfo.hussar.msg.mp.service.MpChannelService;
import com.jxdinfo.hussar.msg.mp.service.MpSendRecordService;
import com.jxdinfo.hussar.msg.mp.service.MpTemplateService;
import com.jxdinfo.hussar.msg.mp.service.MsgMpSendAsyncService;
import com.jxdinfo.hussar.msg.mp.third.service.MpSendMsgThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.model.MsgBasicSendRecord;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MpUnitySendServiceImpl
implements MsgUnitySendFrameService,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MpUnitySendServiceImpl.class);
    @Autowired
    private MsgMpSendAsyncService msgMpSendAsyncService;
    @Autowired
    private MpTemplateService mpTemplateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private MpChannelService mpChannelService;
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired
    private MpSendMsgThirdService mpSendMsgThirdService;
    @Autowired
    private MpSendRecordService mpSendRecordService;

    public MsgBasicSendRecord msgUnitySendBefore(MsgUnitySendDto msgUnitySendDto) {
        MpSendRecordDto mpSendRecordDto = new MpSendRecordDto();
        try {
            AppSceneConfig appSceneConfig = (AppSceneConfig)this.appSceneConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)msgUnitySendDto.getSceneCode()));
            String sceneCode = appSceneConfig.getSceneCode();
            Long appAccessId = appSceneConfig.getAppPkId();
            mpSendRecordDto.setSceneName(appSceneConfig.getSceneName());
            mpSendRecordDto.setSceneCode(sceneCode);
            AppAccess appAccess = (AppAccess)this.appAccessService.getById((Serializable)appAccessId);
            mpSendRecordDto.setAppId(appAccess.getAppId());
            mpSendRecordDto.setAppName(appAccess.getAppName());
            ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(sceneCode, appAccessId.toString(), ServiceTypeEnum.WX_ACCOUNT.getCode());
            String templateNo = configJsonData.getTemplateNo();
            MsgMpTemplate msgMpTemplate = (MsgMpTemplate)this.mpTemplateService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgMpTemplate::getTemplateNo, (Object)templateNo));
            MsgMpChannel msgMpChannel = (MsgMpChannel)this.mpChannelService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgMpChannel::getChannelNo, (Object)configJsonData.getChannelNo()));
            HussarUtils.copy((Object)msgMpChannel, (Object)mpSendRecordDto);
            HussarUtils.copy((Object)msgMpTemplate, (Object)mpSendRecordDto);
            mpSendRecordDto.setMpParams(TemplateUtils.getCurrentTemplateParams((Map)msgUnitySendDto.getTemplateParams(), (String)TemplateUtils.getTemplateParams((String)msgMpTemplate.getContent())));
            Map incompleteTemplateParams = msgUnitySendDto.getIncompleteTemplateParams();
            if (HussarUtils.isNotEmpty((Object)incompleteTemplateParams)) {
                mpSendRecordDto.setUrl(Optional.ofNullable(incompleteTemplateParams.get("url")).orElse("").toString());
            }
            this.replaceContent(mpSendRecordDto);
            mpSendRecordDto.setStatus(Integer.valueOf(1));
            mpSendRecordDto.setTenantCode(msgUnitySendDto.getTenantCode());
            ArrayList errorContactInfos = new ArrayList();
            List receiveAddress = this.msgContactInfoService.getReceiveAddress(msgUnitySendDto, ServiceTypeEnum.WX_ACCOUNT.getCode(), appSceneConfig, errorContactInfos);
            if (HussarUtils.isEmpty((Object)receiveAddress)) {
                this.saveFailRecord(mpSendRecordDto, new RuntimeException("\u65e0\u53ef\u7528\u8054\u7cfb\u5730\u5740\uff01" + (HussarUtils.isNotEmpty(errorContactInfos) ? "\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", errorContactInfos) : "")));
                return null;
            }
            mpSendRecordDto.setToUser(String.join((CharSequence)",", receiveAddress));
            PrintPushLogsUtils.printPushReceiveLogs((List)receiveAddress, (String)ServiceTypeEnum.WX_ACCOUNT.getCode(), (Logger)LOGGER);
            mpSendRecordDto.setErrorContactInfos(errorContactInfos);
        }
        catch (Exception e) {
            this.saveFailRecord(mpSendRecordDto, e);
            throw e;
        }
        this.mpSendMsgThirdService.sendMpTimMsg(mpSendRecordDto);
        return null;
    }

    public String getMsgSendType() {
        return null;
    }

    public boolean msgUnityThirdSend(MsgBasicSendRecord msgBasicSendRecord) {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        MsgUnitySendFactory.setSendBeansToMap("wx_account", this);
    }

    private void replaceContent(MpSendRecordDto mpSendRecordDto) {
        String content = mpSendRecordDto.getContent();
        Map mpParams = mpSendRecordDto.getMpParams();
        if (HussarUtils.isNotEmpty((Object)mpParams)) {
            mpSendRecordDto.setContent(TemplateUtils.replaceParams((String)content, (Map)mpParams));
        }
    }

    private void saveFailRecord(MpSendRecordDto mpSendRecordDto, Exception e) {
        Date now = new Date();
        if (HussarUtils.isEmpty((Object)mpSendRecordDto.getChannelNo())) {
            mpSendRecordDto.setChannelNo("null");
            mpSendRecordDto.setChannelName("\u65e0\u901a\u9053\u6807\u8bc6\u8bb0\u5f55");
        }
        mpSendRecordDto.setId(null);
        mpSendRecordDto.setSendTime(now);
        mpSendRecordDto.setCreateTime(now);
        mpSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        mpSendRecordDto.setStatus(SendStatusEnum.FAIL.getCode());
        mpSendRecordDto.setErrMsg("\u7ec4\u88c5\u53d1\u9001\u53c2\u6570\u53d1\u751f\u5f02\u5e38\uff1a" + (HussarUtils.isNotEmpty((Object)e.getMessage()) ? e.getMessage() : e.getClass().getName()));
        this.mpSendRecordService.saveRecord(mpSendRecordDto);
    }
}

