/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mp.controller;

import com.jxdinfo.hussar.msg.common.model.MsgAppAccessBean;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.mp.dto.MpChannelQueryVo;
import com.jxdinfo.hussar.msg.mp.dto.MpSendMsgCreateDto;
import com.jxdinfo.hussar.msg.mp.dto.MpTemplateQueryVo;
import com.jxdinfo.hussar.msg.mp.service.MpChannelService;
import com.jxdinfo.hussar.msg.mp.service.MpSendService;
import com.jxdinfo.hussar.msg.mp.service.MpTemplateService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.exception.HussarException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u516c\u4f17\u53f7\u53d1\u9001\u6d4b\u8bd5\u6d88\u606f"})
@RequestMapping(value={"msg/mp/test"})
public class MpTestSendController {
    private Logger logger = LogManager.getLogger(MpTestSendController.class);
    @Autowired
    private MpChannelService mpChannelService;
    @Autowired
    private MpTemplateService mpTemplateService;
    @Autowired
    private MpSendService mpSendService;

    @GetMapping(value={"/getChannelList"})
    @ApiOperation(value="\u83b7\u53d6\u516c\u4f17\u53f7\u901a\u9053\u5217\u8868", notes="\u83b7\u53d6\u516c\u4f17\u53f7\u901a\u9053\u5217\u8868")
    @AuditLog(moduleName="\u516c\u4f17\u53f7\u53d1\u9001\u6d4b\u8bd5\u6d88\u606f", eventDesc="\u83b7\u53d6\u516c\u4f17\u53f7\u901a\u9053\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<MpChannelQueryVo>> getChannelList() {
        return ApiResponse.success((Object)this.mpChannelService.getChannelList());
    }

    @GetMapping(value={"/getTemplateListByChannelId/{channelId}"})
    @ApiOperation(value="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u6a21\u677f\u5217\u8868", notes="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u6a21\u677f\u5217\u8868")
    @AuditLog(moduleName="\u516c\u4f17\u53f7\u53d1\u9001\u6d4b\u8bd5\u6d88\u606f", eventDesc="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u6a21\u677f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<MpTemplateQueryVo>> getTemplateListByChannelId(@PathVariable(value="channelId") Long channelId) {
        return ApiResponse.success((Object)this.mpTemplateService.getTemplateListByChannelId(channelId));
    }

    @PostMapping(value={"/sendMpMsg"})
    @ApiOperation(value="\u53d1\u9001\u6d88\u606f", notes="\u53d1\u9001\u6d88\u606f")
    @AuditLog(moduleName="\u516c\u4f17\u53f7\u53d1\u9001\u6d4b\u8bd5\u6d88\u606f", eventDesc="\u53d1\u9001\u6d88\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> sendMpMsg(@Validated @RequestBody MpSendMsgCreateDto createDto) {
        TenantCodeUtils.fillTestTenantCode((MsgAppAccessBean)createDto);
        if (this.mpSendService.testSendMpMsg(createDto)) {
            return ApiResponse.success();
        }
        throw new HussarException("\u53d1\u9001\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u53d1\u9001\u8bb0\u5f55\uff01");
    }
}

