/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.controller;

import com.jxdinfo.hussar.msg.common.model.MsgAppAccessBean;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailSendDto;
import com.jxdinfo.hussar.msg.mail.service.MsgMailChannelService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailReciverService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailSendService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailTemplateService;
import com.jxdinfo.hussar.msg.mail.vo.MailChannelQueryVo;
import com.jxdinfo.hussar.msg.mail.vo.MsgMailReciverQueryVo;
import com.jxdinfo.hussar.msg.mail.vo.MsgMailTemplateQueryVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.exception.HussarException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u90ae\u4ef6\u6d4b\u8bd5\u53d1\u9001"})
@RequestMapping(value={"msg/msgMailTest"})
public class MailSenderTestController {
    private Logger logger = LogManager.getLogger(MailSenderTestController.class);
    @Autowired
    private MsgMailSendService msgMailSendService;
    @Autowired
    private MsgMailChannelService msgMailChannelService;
    @Autowired
    private MsgMailTemplateService mailTemplateService;
    @Autowired
    private MsgMailReciverService msgMailReciverService;

    @GetMapping(value={"/getChannelList"})
    @ApiOperation(value="\u83b7\u53d6\u90ae\u4ef6\u901a\u9053\u5217\u8868", notes="\u83b7\u53d6\u90ae\u4ef6\u901a\u9053\u5217\u8868")
    @AuditLog(moduleName="\u90ae\u4ef6\u6d4b\u8bd5\u53d1\u9001", eventDesc="\u83b7\u53d6\u90ae\u4ef6\u901a\u9053\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<MailChannelQueryVo>> getChannelList() {
        return ApiResponse.success((Object)this.msgMailChannelService.getChannelList());
    }

    @GetMapping(value={"/getTemplateList"})
    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f\u5217\u8868", notes="\u83b7\u53d6\u6a21\u677f\u5217\u8868")
    @AuditLog(moduleName="\u90ae\u4ef6\u6d4b\u8bd5\u53d1\u9001", eventDesc="\u83b7\u53d6\u6a21\u677f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<MsgMailTemplateQueryVo>> getTemplateList() {
        return ApiResponse.success((Object)this.mailTemplateService.getTemplateList());
    }

    @GetMapping(value={"/getReciverList"})
    @ApiOperation(value="\u90ae\u4ef6\u6536\u4ef6\u4eba\u5217\u8868", notes="\u90ae\u4ef6\u6536\u4ef6\u4eba\u5217\u8868")
    @AuditLog(moduleName="\u90ae\u4ef6\u6d4b\u8bd5\u53d1\u9001", eventDesc="\u90ae\u4ef6\u6536\u4ef6\u4eba\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<MsgMailReciverQueryVo>> getReciverList() {
        return ApiResponse.success((Object)this.msgMailReciverService.getReciverList());
    }

    @PostMapping(value={"/send"})
    @ApiOperation(value="\u5355\u6b21\u53d1\u9001\u90ae\u4ef6", notes="\u5355\u6b21\u53d1\u9001\u90ae\u4ef6")
    @AuditLog(moduleName="\u90ae\u4ef6\u6d4b\u8bd5\u53d1\u9001", eventDesc="\u5355\u6b21\u53d1\u9001\u90ae\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> send(@Validated @RequestBody MsgMailSendDto msgMailSendDto) {
        TenantCodeUtils.fillTestTenantCode((MsgAppAccessBean)msgMailSendDto);
        if (this.msgMailSendService.sendTest(msgMailSendDto)) {
            return ApiResponse.success();
        }
        throw new HussarException("\u53d1\u9001\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u53d1\u9001\u8bb0\u5f55\uff01");
    }

    @PostMapping(value={"/bathsend"})
    @ApiOperation(value="\u6279\u91cf\u53d1\u9001\u90ae\u4ef6", notes="\u6279\u91cf\u53d1\u9001\u90ae\u4ef6")
    @AuditLog(moduleName="\u90ae\u4ef6\u6d4b\u8bd5\u53d1\u9001", eventDesc="\u6279\u91cf\u53d1\u9001\u90ae\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> bathSend(@Validated @RequestBody MsgMailSendDto msgMailSendDto) {
        TenantCodeUtils.fillTestTenantCode((MsgAppAccessBean)msgMailSendDto);
        if (this.msgMailSendService.bathSendTest(msgMailSendDto)) {
            return ApiResponse.success();
        }
        throw new HussarException("\u53d1\u9001\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u53d1\u9001\u8bb0\u5f55\uff01");
    }
}

