/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.dingtalk.dao.MsgDingTalkTemplateMapper;
import com.jxdinfo.hussar.msg.dingtalk.dto.MsgDingTalkTemplateDto;
import com.jxdinfo.hussar.msg.dingtalk.model.MsgDingTalkTemplate;
import com.jxdinfo.hussar.msg.dingtalk.service.MsgDingTalkTemplateService;
import com.jxdinfo.hussar.msg.dingtalk.vo.MsgDingTalkTemplateVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgDingTalkTemplateServiceImpl
extends HussarServiceImpl<MsgDingTalkTemplateMapper, MsgDingTalkTemplate>
implements MsgDingTalkTemplateService {
    @Autowired
    private MsgDingTalkTemplateMapper msgDingTalkTemplateMapper;
    @Autowired
    private IHussarValidateService validateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public ApiResponse<Page<MsgDingTalkTemplateVo>> getList(PageInfo pageInfo, String templateNo, String templateName, String content, Integer openStatus, String messageType) {
        Page msgDingTalkTemplateVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        return ApiResponse.success(this.msgDingTalkTemplateMapper.getListPage((Page<MsgDingTalkTemplateVo>)msgDingTalkTemplateVoPage, SqlQueryUtil.transferSpecialChar((String)templateNo), SqlQueryUtil.transferSpecialChar((String)templateName), SqlQueryUtil.transferSpecialChar((String)content), openStatus, messageType));
    }

    public ApiResponse<MsgDingTalkTemplateVo> listById(Long id) {
        return ApiResponse.success((Object)HussarUtils.copy((Object)super.getById((Serializable)id), MsgDingTalkTemplateVo.class));
    }

    public ApiResponse<List<MsgDingTalkTemplateVo>> getTemplateList() {
        List msgDingTalkTemplateVos = HussarUtils.copy((Collection)super.list((Wrapper)new LambdaQueryWrapper().eq(MsgDingTalkTemplate::getOpenStatus, (Object)OpenStatusEnum.ENABLE.getCode())), MsgDingTalkTemplateVo.class);
        for (MsgDingTalkTemplateVo msgDingTalkTemplateVo : msgDingTalkTemplateVos) {
            String templateParams = msgDingTalkTemplateVo.getTemplateParams();
            if (!HussarUtils.isNotEmpty((Object)templateParams)) continue;
            msgDingTalkTemplateVo.setTemplateParamsList(Arrays.asList(templateParams.split(",")));
        }
        return ApiResponse.success((Object)msgDingTalkTemplateVos);
    }

    @HussarTransactional
    public ApiResponse<Boolean> addTemplate(MsgDingTalkTemplateDto msgDingTalkTemplateDto) {
        List btnJsonLists;
        String validateMsg = this.validateService.validate((Object)msgDingTalkTemplateDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String templateName = msgDingTalkTemplateDto.getTemplateName();
        long count = super.count((Wrapper)new LambdaQueryWrapper().eq(MsgDingTalkTemplate::getTemplateName, (Object)templateName));
        if (count > 0L) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0" + templateName + "\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
        }
        if (HussarUtils.isNotEmpty((Object)msgDingTalkTemplateDto.getBtnJsonList()) && (btnJsonLists = JSON.parseArray((String)msgDingTalkTemplateDto.getBtnJsonList(), OapiMessageCorpconversationAsyncsendV2Request.BtnJsonList.class)).size() > 2 && "1".equals(msgDingTalkTemplateDto.getBtnOrientation())) {
            throw new HussarException("\u6309\u94ae\u6570\u91cf\u8d85\u8fc7\u4e24\u4e2a\uff0c\u8bf7\u9009\u62e9\u7ad6\u76f4\u6392\u5217\u65b9\u5f0f");
        }
        MsgDingTalkTemplate msgDingTalkTemplate = (MsgDingTalkTemplate)HussarUtils.copy((Object)msgDingTalkTemplateDto, MsgDingTalkTemplate.class);
        msgDingTalkTemplate.setTemplateNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.DING_TALK_TEMPLATE));
        msgDingTalkTemplate.setTemplateParams(TemplateUtils.getTemplateParams((String)(msgDingTalkTemplateDto.getContent() + msgDingTalkTemplateDto.getTitle() + msgDingTalkTemplateDto.getBtnJsonList() + msgDingTalkTemplateDto.getSingleTitle() + msgDingTalkTemplateDto.getSingleUrl())));
        return ApiResponse.success((Object)super.save((BaseEntity)msgDingTalkTemplate));
    }

    @HussarTransactional
    public ApiResponse<Boolean> updateTemplate(MsgDingTalkTemplateDto msgDingTalkTemplateDto) {
        List btnJsonLists;
        long count;
        String validateMsg = this.validateService.validate((Object)msgDingTalkTemplateDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String templateName = msgDingTalkTemplateDto.getTemplateName();
        MsgDingTalkTemplate msgDingTalkTemplate = (MsgDingTalkTemplate)super.getById((Serializable)msgDingTalkTemplateDto.getId());
        if (!HussarUtils.equals((Object)msgDingTalkTemplate.getTemplateName(), (Object)templateName) && (count = super.count((Wrapper)new LambdaQueryWrapper().eq(MsgDingTalkTemplate::getTemplateName, (Object)templateName))) > 0L) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0" + templateName + "\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
        }
        if (HussarUtils.isNotEmpty((Object)msgDingTalkTemplateDto.getBtnJsonList()) && (btnJsonLists = JSON.parseArray((String)msgDingTalkTemplateDto.getBtnJsonList(), OapiMessageCorpconversationAsyncsendV2Request.BtnJsonList.class)).size() > 2 && "1".equals(msgDingTalkTemplateDto.getBtnOrientation())) {
            throw new HussarException("\u6309\u94ae\u6570\u91cf\u8d85\u8fc7\u4e24\u4e2a\uff0c\u8bf7\u9009\u62e9\u7ad6\u76f4\u6392\u5217\u65b9\u5f0f");
        }
        if (!HussarUtils.equals((Object)msgDingTalkTemplate.getOpenStatus(), (Object)msgDingTalkTemplateDto.getOpenStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(msgDingTalkTemplate.getTemplateNo())))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u65e0\u6cd5\u4fee\u6539\u542f\u52a8\u72b6\u6001\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        HussarUtils.copy((Object)msgDingTalkTemplateDto, (Object)msgDingTalkTemplate);
        msgDingTalkTemplate.setTemplateParams(TemplateUtils.getTemplateParams((String)(msgDingTalkTemplateDto.getContent() + msgDingTalkTemplateDto.getTitle() + msgDingTalkTemplateDto.getBtnJsonList() + msgDingTalkTemplateDto.getSingleTitle() + msgDingTalkTemplateDto.getSingleUrl())));
        return ApiResponse.success((Object)super.updateById((BaseEntity)msgDingTalkTemplate));
    }

    @HussarTransactional
    public ApiResponse<Boolean> delTemplate(List<Long> ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(ids).stream().map(MsgDingTalkTemplate::getTemplateNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        return ApiResponse.success((Object)super.removeByIds(ids));
    }
}

