/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.utils.PrintPushLogsUtils;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordDto;
import com.jxdinfo.hussar.msg.cp.model.MsgCpChannel;
import com.jxdinfo.hussar.msg.cp.model.MsgCpTemplate;
import com.jxdinfo.hussar.msg.cp.service.CpChannelService;
import com.jxdinfo.hussar.msg.cp.service.CpSendRecordService;
import com.jxdinfo.hussar.msg.cp.service.MsgCpSendAsyncService;
import com.jxdinfo.hussar.msg.cp.service.MsgCpTemplateService;
import com.jxdinfo.hussar.msg.cp.third.service.MsgCpSendThirdService;
import com.jxdinfo.hussar.msg.factory.MsgUnitySendFactory;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.model.MsgBasicSendRecord;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class CpUnitySendServiceImpl
implements MsgUnitySendFrameService,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(CpUnitySendServiceImpl.class);
    @Autowired
    private MsgCpSendAsyncService msgCpSendAsyncService;
    @Autowired
    private MsgCpTemplateService msgCpTemplateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private CpChannelService cpChannelService;
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired
    private MsgCpSendThirdService cpSendThirdService;
    @Autowired
    private CpSendRecordService cpSendRecordService;

    public MsgBasicSendRecord msgUnitySendBefore(MsgUnitySendDto msgUnitySendDto) {
        CpSendRecordDto cpSendRecordDto = new CpSendRecordDto();
        try {
            AppSceneConfig appSceneConfig = (AppSceneConfig)this.appSceneConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)msgUnitySendDto.getSceneCode()));
            String sceneCode = appSceneConfig.getSceneCode();
            Long appAccessId = appSceneConfig.getAppPkId();
            cpSendRecordDto.setSceneName(appSceneConfig.getSceneName());
            cpSendRecordDto.setSceneCode(sceneCode);
            AppAccess appAccess = (AppAccess)this.appAccessService.getById((Serializable)appAccessId);
            cpSendRecordDto.setAppId(appAccess.getAppId());
            cpSendRecordDto.setAppName(appAccess.getAppName());
            ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(sceneCode, appAccessId.toString(), ServiceTypeEnum.CP.getCode());
            String templateNo = configJsonData.getTemplateNo();
            MsgCpTemplate msgCpTemplate = (MsgCpTemplate)this.msgCpTemplateService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgCpTemplate::getTemplateNo, (Object)templateNo));
            MsgCpChannel msgCpChannel = (MsgCpChannel)this.cpChannelService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgCpChannel::getChannelNo, (Object)configJsonData.getChannelNo()));
            HussarUtils.copy((Object)msgCpChannel, (Object)cpSendRecordDto);
            HussarUtils.copy((Object)msgCpTemplate, (Object)cpSendRecordDto);
            cpSendRecordDto.setCorpId(msgCpChannel.getCorpID());
            cpSendRecordDto.setCpParams(TemplateUtils.getCurrentTemplateParams((Map)msgUnitySendDto.getTemplateParams(), (String)msgCpTemplate.getTemplateParams()));
            this.replaceContent(cpSendRecordDto);
            cpSendRecordDto.setStatus(Integer.valueOf(1));
            cpSendRecordDto.setTenantCode(msgUnitySendDto.getTenantCode());
            ArrayList errorContactInfos = new ArrayList();
            List receiveAddress = this.msgContactInfoService.getReceiveAddress(msgUnitySendDto, ServiceTypeEnum.CP.getCode(), appSceneConfig, errorContactInfos);
            if (HussarUtils.isEmpty((Object)receiveAddress)) {
                this.saveFailRecord(cpSendRecordDto, new RuntimeException("\u65e0\u53ef\u7528\u8054\u7cfb\u5730\u5740\uff01" + (HussarUtils.isNotEmpty(errorContactInfos) ? "\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", errorContactInfos) : "")));
                return null;
            }
            cpSendRecordDto.setToUser(String.join((CharSequence)",", receiveAddress));
            PrintPushLogsUtils.printPushReceiveLogs((List)receiveAddress, (String)ServiceTypeEnum.CP.getCode(), (Logger)LOGGER);
            cpSendRecordDto.setErrorContactInfos(errorContactInfos);
        }
        catch (Exception e) {
            this.saveFailRecord(cpSendRecordDto, e);
            throw e;
        }
        this.cpSendThirdService.sendCpTimMsg(cpSendRecordDto);
        return null;
    }

    public String getMsgSendType() {
        return null;
    }

    public boolean msgUnityThirdSend(MsgBasicSendRecord msgBasicSendRecord) {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        MsgUnitySendFactory.setSendBeansToMap("cp", this);
    }

    private void replaceContent(CpSendRecordDto cpSendRecordDto) {
        String title = cpSendRecordDto.getTitle();
        String url = cpSendRecordDto.getUrl();
        String content = cpSendRecordDto.getContent();
        Map cpParams = cpSendRecordDto.getCpParams();
        if (HussarUtils.isNotEmpty((Object)cpParams)) {
            cpSendRecordDto.setTitle(TemplateUtils.replaceParams((String)title, (Map)cpParams));
            cpSendRecordDto.setUrl(TemplateUtils.replaceParams((String)url, (Map)cpParams));
            cpSendRecordDto.setContent(TemplateUtils.replaceParams((String)content, (Map)cpParams));
        }
    }

    private void saveFailRecord(CpSendRecordDto cpSendRecordDto, Exception e) {
        Date now = new Date();
        if (HussarUtils.isEmpty((Object)cpSendRecordDto.getChannelNo())) {
            cpSendRecordDto.setChannelNo("null");
            cpSendRecordDto.setChannelName("\u65e0\u901a\u9053\u6807\u8bc6\u8bb0\u5f55");
        }
        cpSendRecordDto.setId(null);
        cpSendRecordDto.setSendTime(now);
        cpSendRecordDto.setCreateTime(now);
        cpSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        cpSendRecordDto.setStatus(SendStatusEnum.FAIL.getCode());
        cpSendRecordDto.setErrMsg("\u7ec4\u88c5\u53d1\u9001\u53c2\u6570\u53d1\u751f\u5f02\u5e38\uff1a" + (HussarUtils.isNotEmpty((Object)e.getMessage()) ? e.getMessage() : e.getClass().getName()));
        this.cpSendRecordService.saveRecord(cpSendRecordDto);
    }
}

