/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.cp.dao.MsgCpChannelMapper;
import com.jxdinfo.hussar.msg.cp.dto.CpChannelCreateDto;
import com.jxdinfo.hussar.msg.cp.dto.CpChannelPageDto;
import com.jxdinfo.hussar.msg.cp.dto.CpChannelUpdateDto;
import com.jxdinfo.hussar.msg.cp.model.MsgCpChannel;
import com.jxdinfo.hussar.msg.cp.service.CpChannelService;
import com.jxdinfo.hussar.msg.cp.vo.CpChannelQueryVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class CpChannelServiceImpl
extends HussarServiceImpl<MsgCpChannelMapper, MsgCpChannel>
implements CpChannelService {
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<MsgCpChannel> listPage(Page page, CpChannelPageDto pageDto) {
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelName())) {
            pageDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelName().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelNo())) {
            pageDto.setChannelNo(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelNo().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getCorpName())) {
            pageDto.setCorpName(SqlQueryUtil.transferSpecialChar((String)pageDto.getCorpName().trim()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getAgentName())) {
            pageDto.setAgentName(SqlQueryUtil.transferSpecialChar((String)pageDto.getAgentName().trim()));
        }
        IPage<MsgCpChannel> pageList = ((MsgCpChannelMapper)this.baseMapper).queryPage(page, pageDto);
        return pageList;
    }

    @HussarTransactional
    public boolean save(CpChannelCreateDto createDto) {
        MsgCpChannel entity = new MsgCpChannel();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        Long id = IdWorker.getId((Object)entity);
        entity.setId(id);
        entity.setChannelNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.CP_CHANNEL));
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(entity))) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + entity.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        super.save((BaseEntity)entity);
        return true;
    }

    @HussarTransactional
    public boolean update(CpChannelUpdateDto updateDto) {
        MsgCpChannel entity = new MsgCpChannel();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgCpChannel::getId, (Object)updateDto.getId());
        MsgCpChannel info = (MsgCpChannel)((MsgCpChannelMapper)this.baseMapper).selectOne((Wrapper)qw);
        if (HussarUtils.isEmpty((Object)info)) {
            throw new HussarException("\u8be5\u901a\u9053\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\uff01");
        }
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(entity))) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + entity.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        if (!HussarUtils.equals((Object)info.getStatus(), (Object)updateDto.getStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(info.getChannelNo())))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u65e0\u6cd5\u4fee\u6539\u542f\u52a8\u72b6\u6001\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        super.updateById((BaseEntity)entity);
        return true;
    }

    @HussarTransactional
    public boolean delete(Long id) {
        MsgCpChannel msgCpChannel = (MsgCpChannel)((MsgCpChannelMapper)this.baseMapper).selectById(id);
        if (this.appSceneConfigService.isExistScene(msgCpChannel.getChannelNo())) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgCpChannel::getId, (Object)id);
        MsgCpChannel info = (MsgCpChannel)((MsgCpChannelMapper)this.baseMapper).selectOne((Wrapper)qw);
        if (HussarUtils.isEmpty((Object)info)) {
            throw new HussarException("\u8be5\u901a\u9053\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\uff01");
        }
        super.removeById((Serializable)id);
        return true;
    }

    @HussarTransactional
    public boolean deleteChannelByIds(Long[] ids) {
        List channelNos = super.listByIds(Arrays.asList(ids)).stream().map(MsgCpChannel::getChannelNo).collect(Collectors.toList());
        if (this.appSceneConfigService.isExistSceneInBatch(channelNos)) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        super.removeByIds(Arrays.asList(ids));
        return true;
    }

    private CpChannelQueryVo entity2QueryVo(MsgCpChannel entity) {
        CpChannelQueryVo vo = new CpChannelQueryVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        return vo;
    }

    public List<CpChannelQueryVo> getChannelList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgCpChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgCpChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public MsgCpChannel selectChannel(Long id, String channelNo) {
        MsgCpChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (id != null) {
            qw.lambda().eq(MsgCpChannel::getId, (Object)id);
        }
        if ((channel = (MsgCpChannel)((MsgCpChannelMapper)this.baseMapper).selectOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }

    public Map<String, String> getChannelNoAndName(List<String> channelNos) {
        if (HussarUtils.isEmpty(channelNos)) {
            return new HashMap<String, String>();
        }
        Map<String, String> channelNoAndName = super.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{MsgCpChannel::getChannelNo, MsgCpChannel::getChannelName}).in(MsgCpChannel::getChannelNo, channelNos)).stream().collect(Collectors.toMap(MsgCpChannel::getChannelNo, MsgCpChannel::getChannelName));
        channelNoAndName.put("null", "\u65e0\u901a\u9053\u6807\u8bc6\u8bb0\u5f55");
        return channelNoAndName;
    }

    private String checkChannelUnique(MsgCpChannel entity) {
        Long id = HussarUtils.isEmpty((Object)entity.getId()) ? -1L : entity.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgCpChannel::getChannelName, (Object)entity.getChannelName());
        MsgCpChannel info = (MsgCpChannel)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)info) && !HussarUtils.equals((Object)info.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

