/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.contact.utils;

import com.jxdinfo.hussar.msg.contact.utils.MsgFormatCheckResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;

public class MsgFormatCheckUtil {
    public static MsgFormatCheckResult checkContactId(String contactId) {
        int supportLength = 85;
        MsgFormatCheckResult msgFormatCheckResult = new MsgFormatCheckResult();
        if (HussarUtils.isEmpty((Object)contactId)) {
            msgFormatCheckResult.setMsg("\u8054\u7cfb\u4eba\u6807\u8bc6\u4e0d\u53ef\u4e3a\u7a7a");
            return msgFormatCheckResult;
        }
        if (contactId.length() > supportLength) {
            msgFormatCheckResult.setMsg("\u8054\u7cfb\u4eba\u6807\u8bc6\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc7" + supportLength);
            return msgFormatCheckResult;
        }
        if (!contactId.matches("^[a-zA-Z0-9]*$")) {
            msgFormatCheckResult.setMsg("\u8054\u7cfb\u4eba\u6807\u8bc6\u53ea\u53ef\u586b\u5199\u5927\u5c0f\u5199\u82f1\u6587\u3001\u6570\u5b57");
            return msgFormatCheckResult;
        }
        msgFormatCheckResult.setSuccess(true);
        return msgFormatCheckResult;
    }

    public static MsgFormatCheckResult checkContactName(String contactName, boolean isEmptyName) {
        int supportLength = 128;
        MsgFormatCheckResult msgFormatCheckResult = new MsgFormatCheckResult();
        if (!isEmptyName) {
            if (HussarUtils.isEmpty((Object)contactName)) {
                msgFormatCheckResult.setMsg("\u8054\u7cfb\u4eba\u59d3\u540d\u4e0d\u53ef\u4e3a\u7a7a");
                return msgFormatCheckResult;
            }
            if (contactName.length() > supportLength) {
                msgFormatCheckResult.setMsg("\u8054\u7cfb\u4eba\u59d3\u540d\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc7" + supportLength);
                return msgFormatCheckResult;
            }
            if (!contactName.matches("^[\u4e00-\u9fa5a-zA-Z0-9]*$")) {
                msgFormatCheckResult.setMsg("\u8054\u7cfb\u4eba\u59d3\u540d\u53ea\u53ef\u586b\u5199\u6c49\u5b57\u3001\u5927\u5c0f\u5199\u82f1\u6587\u3001\u6570\u5b57");
                return msgFormatCheckResult;
            }
        }
        msgFormatCheckResult.setSuccess(true);
        return msgFormatCheckResult;
    }

    public static MsgFormatCheckResult checkContactType(String contactType, List<String> contactTypes) {
        MsgFormatCheckResult msgFormatCheckResult = new MsgFormatCheckResult();
        if (HussarUtils.isEmpty((Object)contactType)) {
            msgFormatCheckResult.setMsg("\u8054\u7cfb\u4eba\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
            return msgFormatCheckResult;
        }
        if (!contactTypes.contains(contactType)) {
            msgFormatCheckResult.setMsg("\u76ee\u524d\u652f\u6301\u8054\u7cfb\u4eba\u7c7b\u578b\u4e2d\u4e0d\u5b58\u5728\u6240\u586b\u5185\u5bb9");
            return msgFormatCheckResult;
        }
        msgFormatCheckResult.setSuccess(true);
        return msgFormatCheckResult;
    }

    public static MsgFormatCheckResult checkTagName(String tagName, List<String> tagNames) {
        MsgFormatCheckResult msgFormatCheckResult = new MsgFormatCheckResult();
        if (HussarUtils.isEmpty((Object)tagName)) {
            msgFormatCheckResult.setMsg("\u6807\u7b7e\u4e0d\u53ef\u4e3a\u7a7a");
            return msgFormatCheckResult;
        }
        if (!tagNames.contains(tagName)) {
            msgFormatCheckResult.setMsg("\u6807\u7b7e\u7ba1\u7406\u4e2d\u7ef4\u62a4\u6807\u7b7e\u4e0d\u5b58\u5728\u6240\u586b\u5185\u5bb9");
            return msgFormatCheckResult;
        }
        msgFormatCheckResult.setSuccess(true);
        return msgFormatCheckResult;
    }

    public static MsgFormatCheckResult checkSendType(String sendType, List<String> sendTypes) {
        MsgFormatCheckResult msgFormatCheckResult = new MsgFormatCheckResult();
        if (HussarUtils.isEmpty((Object)sendType)) {
            msgFormatCheckResult.setMsg("\u53d1\u9001\u7c7b\u578b\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return msgFormatCheckResult;
        }
        if (!sendTypes.contains(sendType)) {
            msgFormatCheckResult.setMsg("\u76ee\u524d\u652f\u6301\u53d1\u9001\u7c7b\u578b\u7f16\u7801\u4e0d\u5b58\u5728\u6240\u586b\u5185\u5bb9");
            return msgFormatCheckResult;
        }
        msgFormatCheckResult.setSuccess(true);
        return msgFormatCheckResult;
    }

    public static MsgFormatCheckResult checkReceiveAddress(String receiveAddress, String sendType) {
        int supportLength = 128;
        MsgFormatCheckResult msgFormatCheckResult = new MsgFormatCheckResult();
        if (HussarUtils.isEmpty((Object)receiveAddress)) {
            msgFormatCheckResult.setMsg("\u901a\u8baf\u5730\u5740\u4e0d\u53ef\u4e3a\u7a7a");
            return msgFormatCheckResult;
        }
        if (receiveAddress.length() > supportLength) {
            msgFormatCheckResult.setMsg("\u901a\u8baf\u5730\u5740\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc7" + supportLength);
            return msgFormatCheckResult;
        }
        if ("sms".equals(sendType) && !receiveAddress.matches("^1[3-9]\\d{9}$")) {
            msgFormatCheckResult.setMsg("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
            return msgFormatCheckResult;
        }
        if ("mail".equals(sendType) && !receiveAddress.matches("^[^\\s@]+@[^\\s@]+\\.[^\\s@]+$")) {
            msgFormatCheckResult.setMsg("\u90ae\u7bb1\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
            return msgFormatCheckResult;
        }
        msgFormatCheckResult.setSuccess(true);
        return msgFormatCheckResult;
    }
}

