/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.contact.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.msg.contact.dao.MsgSupportedSendTypeMapper;
import com.jxdinfo.hussar.msg.contact.model.MsgSupportedSendType;
import com.jxdinfo.hussar.msg.contact.service.MsgSupportedSendTypeService;
import com.jxdinfo.hussar.msg.contact.vo.MsgSupportedSendTypeVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgSupportedSendTypeServiceImpl
extends HussarServiceImpl<MsgSupportedSendTypeMapper, MsgSupportedSendType>
implements MsgSupportedSendTypeService {
    @Autowired
    private MsgSupportedSendTypeMapper supportedSendTypeMapper;

    public ApiResponse<List<MsgSupportedSendTypeVo>> getSendTypeStructure() {
        List msgSupportedSendTypes = super.list((Wrapper)new LambdaQueryWrapper().eq(MsgSupportedSendType::getNeedFrontDisplay, (Object)true));
        return ApiResponse.success((Object)HussarUtils.copy((Collection)msgSupportedSendTypes, MsgSupportedSendTypeVo.class));
    }

    public String getChannelNoBySendTypeCode(String sendTypeCode) {
        if (HussarUtils.isEmpty((Object)sendTypeCode)) {
            throw new HussarException("\u53d1\u9001\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a");
        }
        return ((MsgSupportedSendType)super.getOne((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{MsgSupportedSendType::getChannelNo}).eq(MsgSupportedSendType::getSendTypeCode, (Object)sendTypeCode))).getChannelNo();
    }

    @HussarTransactional
    public Boolean saveSupportedSendType(String sendTypeCode, String channelNo, String channelName) {
        MsgSupportedSendType msgSupportedSendTypeOne = (MsgSupportedSendType)super.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgSupportedSendType::getSendTypeCode, (Object)sendTypeCode));
        MsgSupportedSendType msgSupportedSendType = new MsgSupportedSendType();
        msgSupportedSendType.setSendTypeCode(sendTypeCode + ":" + channelNo);
        msgSupportedSendType.setSendTypeName(msgSupportedSendTypeOne.getSendTypeName() + "\uff08" + channelName + "\uff09");
        msgSupportedSendType.setChannelNo(channelNo);
        msgSupportedSendType.setReceiveMode(msgSupportedSendTypeOne.getReceiveMode());
        msgSupportedSendType.setReceiveAddressExample(msgSupportedSendTypeOne.getReceiveAddressExample());
        msgSupportedSendType.setNeedFrontDisplay(Boolean.TRUE);
        return super.save((BaseEntity)msgSupportedSendType);
    }

    @HussarTransactional
    public Boolean updateSupportedSendType(String sendTypeCode, String channelNo, String channelName) {
        MsgSupportedSendType msgSupportedSendTypeOne = (MsgSupportedSendType)super.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgSupportedSendType::getSendTypeCode, (Object)sendTypeCode));
        return super.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(MsgSupportedSendType::getChannelNo, (Object)channelNo)).set(MsgSupportedSendType::getSendTypeName, (Object)(msgSupportedSendTypeOne.getSendTypeName() + "\uff08" + channelName + "\uff09")));
    }

    @HussarTransactional
    public Boolean delSupportedSendType(String sendTypeCode, String channelNo) {
        return super.remove((Wrapper)new LambdaQueryWrapper().eq(MsgSupportedSendType::getSendTypeCode, (Object)(sendTypeCode + ":" + channelNo)));
    }

    @HussarTransactional
    public Boolean bathDelSupportedSendType(String sendTypeCode, List<String> channelNos) {
        List sendTypeCodeChannel = channelNos.stream().map(channelNo -> sendTypeCode + ":" + channelNo).collect(Collectors.toList());
        return super.remove((Wrapper)new LambdaQueryWrapper().in(MsgSupportedSendType::getSendTypeCode, sendTypeCodeChannel));
    }
}

