/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.apppush.dao.MsgAppPushTemplateMapper;
import com.jxdinfo.hussar.msg.apppush.dto.MsgAppPushTemplateDto;
import com.jxdinfo.hussar.msg.apppush.model.MsgAppPushTemplate;
import com.jxdinfo.hussar.msg.apppush.service.MsgAppPushTemplateService;
import com.jxdinfo.hussar.msg.apppush.vo.MsgAppPushTemplateVo;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgAppPushTemplateServiceImpl
extends HussarServiceImpl<MsgAppPushTemplateMapper, MsgAppPushTemplate>
implements MsgAppPushTemplateService {
    @Autowired
    private MsgAppPushTemplateMapper msgAppPushTemplateMapper;
    @Autowired
    private IHussarValidateService validateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public ApiResponse<Page<MsgAppPushTemplateVo>> getList(PageInfo pageInfo, String templateNo, String templateName, String content, String title, Integer openStatus) {
        Page msgAppPushTemplateVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        return ApiResponse.success(this.msgAppPushTemplateMapper.getListPage((Page<MsgAppPushTemplateVo>)msgAppPushTemplateVoPage, SqlQueryUtil.transferSpecialChar((String)templateNo), SqlQueryUtil.transferSpecialChar((String)templateName), SqlQueryUtil.transferSpecialChar((String)content), SqlQueryUtil.transferSpecialChar((String)title), openStatus));
    }

    public ApiResponse<MsgAppPushTemplateVo> listById(Long id) {
        return ApiResponse.success((Object)HussarUtils.copy((Object)super.getById((Serializable)id), MsgAppPushTemplateVo.class));
    }

    public ApiResponse<List<MsgAppPushTemplateVo>> getTemplateList() {
        List msgAppPushTemplateVos = HussarUtils.copy((Collection)super.list((Wrapper)new LambdaQueryWrapper().eq(MsgAppPushTemplate::getOpenStatus, (Object)OpenStatusEnum.ENABLE.getCode())), MsgAppPushTemplateVo.class);
        for (MsgAppPushTemplateVo msgAppPushTemplateVo : msgAppPushTemplateVos) {
            String templateParams = msgAppPushTemplateVo.getTemplateParams();
            if (!HussarUtils.isNotEmpty((Object)templateParams)) continue;
            msgAppPushTemplateVo.setTemplateParamsList(Arrays.asList(templateParams.split(",")));
        }
        return ApiResponse.success((Object)msgAppPushTemplateVos);
    }

    @HussarTransactional
    public ApiResponse<Boolean> addTemplate(MsgAppPushTemplateDto msgAppPushTemplateDto) {
        String validateMsg = this.validateService.validate((Object)msgAppPushTemplateDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String templateName = msgAppPushTemplateDto.getTemplateName();
        long count = super.count((Wrapper)new LambdaQueryWrapper().eq(MsgAppPushTemplate::getTemplateName, (Object)templateName));
        if (count > 0L) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0" + templateName + "\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
        }
        MsgAppPushTemplate msgAppPushTemplate = (MsgAppPushTemplate)HussarUtils.copy((Object)msgAppPushTemplateDto, MsgAppPushTemplate.class);
        msgAppPushTemplate.setTemplateNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.APP_PUSH_TEMPLATE));
        msgAppPushTemplate.setTemplateParams(TemplateUtils.getTemplateParams((String)(msgAppPushTemplateDto.getContent() + msgAppPushTemplateDto.getTitle())));
        return ApiResponse.success((Object)super.save((BaseEntity)msgAppPushTemplate));
    }

    @HussarTransactional
    public ApiResponse<Boolean> updateTemplate(MsgAppPushTemplateDto msgAppPushTemplateDto) {
        long count;
        String validateMsg = this.validateService.validate((Object)msgAppPushTemplateDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String templateName = msgAppPushTemplateDto.getTemplateName();
        MsgAppPushTemplate msgAppPushTemplate = (MsgAppPushTemplate)super.getById((Serializable)msgAppPushTemplateDto.getId());
        if (!HussarUtils.equals((Object)msgAppPushTemplate.getTemplateName(), (Object)templateName) && (count = super.count((Wrapper)new LambdaQueryWrapper().eq(MsgAppPushTemplate::getTemplateName, (Object)templateName))) > 0L) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0" + templateName + "\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
        }
        if (!HussarUtils.equals((Object)msgAppPushTemplate.getOpenStatus(), (Object)msgAppPushTemplateDto.getOpenStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(msgAppPushTemplate.getTemplateNo())))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u65e0\u6cd5\u4fee\u6539\u542f\u52a8\u72b6\u6001\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        HussarUtils.copy((Object)msgAppPushTemplateDto, (Object)msgAppPushTemplate);
        msgAppPushTemplate.setTemplateParams(TemplateUtils.getTemplateParams((String)(msgAppPushTemplateDto.getContent() + msgAppPushTemplateDto.getTitle())));
        return ApiResponse.success((Object)super.updateById((BaseEntity)msgAppPushTemplate));
    }

    @HussarTransactional
    public ApiResponse<Boolean> delTemplate(List<Long> ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(ids).stream().map(MsgAppPushTemplate::getTemplateNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        return ApiResponse.success((Object)super.removeByIds(ids));
    }
}

