/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.appim.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.appim.dao.MsgAppImTemplateMapper;
import com.jxdinfo.hussar.msg.appim.dto.MsgAppImTemplateDto;
import com.jxdinfo.hussar.msg.appim.dto.MsgImTemplateQueryDto;
import com.jxdinfo.hussar.msg.appim.model.MsgAppImTemplate;
import com.jxdinfo.hussar.msg.appim.service.MsgAppImTemplateService;
import com.jxdinfo.hussar.msg.appim.vo.MsgAppImTemplateVo;
import com.jxdinfo.hussar.msg.common.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.common.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.msg.appim.service.impl.msgImTemplateServiceImpl")
@HussarTokenDs
public class MsgAppImTemplateServiceImpl
extends HussarServiceImpl<MsgAppImTemplateMapper, MsgAppImTemplate>
implements MsgAppImTemplateService {
    @Autowired
    private MsgAppImTemplateMapper msgAppImTemplateMapper;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public ApiResponse<Page<MsgAppImTemplateVo>> getList(PageInfo pageInfo, MsgImTemplateQueryDto msgImTemplateQueryDto) {
        Page msgCpTemplateVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        msgImTemplateQueryDto.setTemplateNo(SqlQueryUtil.transferSpecialChar((String)msgImTemplateQueryDto.getTemplateNo()));
        msgImTemplateQueryDto.setTemplateName(SqlQueryUtil.transferSpecialChar((String)msgImTemplateQueryDto.getTemplateName()));
        msgImTemplateQueryDto.setContent(SqlQueryUtil.transferSpecialChar((String)msgImTemplateQueryDto.getContent()));
        msgImTemplateQueryDto.setTitle(SqlQueryUtil.transferSpecialChar((String)msgImTemplateQueryDto.getTitle()));
        return ApiResponse.success(this.msgAppImTemplateMapper.getListPage((Page<MsgAppImTemplateVo>)msgCpTemplateVoPage, msgImTemplateQueryDto));
    }

    public ApiResponse<MsgAppImTemplateVo> listById(Long id) {
        return ApiResponse.success((Object)HussarUtils.copy((Object)super.getById((Serializable)id), MsgAppImTemplateVo.class));
    }

    public ApiResponse<List<MsgAppImTemplateVo>> getTemplateList() {
        List msgAppImTemplateVos = HussarUtils.copy((Collection)super.list((Wrapper)new LambdaQueryWrapper().eq(MsgAppImTemplate::getOpenStatus, (Object)OpenStatusEnum.ENABLE.getCode())), MsgAppImTemplateVo.class);
        for (MsgAppImTemplateVo msgAppImTemplateVo : msgAppImTemplateVos) {
            String templateParams = msgAppImTemplateVo.getTemplateParams();
            if (!HussarUtils.isNotEmpty((Object)templateParams)) continue;
            msgAppImTemplateVo.setTemplateParamsList(Arrays.asList(templateParams.split(",")));
        }
        return ApiResponse.success((Object)msgAppImTemplateVos);
    }

    @HussarTransactional
    public ApiResponse<Boolean> addTemplate(MsgAppImTemplateDto msgAppImTemplateDto) {
        String templateName = msgAppImTemplateDto.getTemplateName();
        long count = super.count((Wrapper)new LambdaQueryWrapper().eq(MsgAppImTemplate::getTemplateName, (Object)templateName));
        if (count > 0L) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0" + templateName + "\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
        }
        MsgAppImTemplate msgAppImTemplate = (MsgAppImTemplate)HussarUtils.copy((Object)msgAppImTemplateDto, MsgAppImTemplate.class);
        msgAppImTemplate.setTemplateNo(BizCodeUtils.generalBizCode((BizCodeEnum)BizCodeEnum.APP_IM_TEMPLATE));
        msgAppImTemplate.setTemplateParams(TemplateUtils.getTemplateParams((String)(msgAppImTemplateDto.getContent() + msgAppImTemplateDto.getTitle() + msgAppImTemplateDto.getUrl())));
        return ApiResponse.success((Object)super.save((BaseEntity)msgAppImTemplate));
    }

    @HussarTransactional
    public ApiResponse<Boolean> updateTemplate(MsgAppImTemplateDto msgAppImTemplateDto) {
        long count;
        String templateName = msgAppImTemplateDto.getTemplateName();
        MsgAppImTemplate msgAppImTemplate = (MsgAppImTemplate)super.getById((Serializable)msgAppImTemplateDto.getId());
        if (!HussarUtils.equals((Object)msgAppImTemplate.getTemplateName(), (Object)templateName) && (count = super.count((Wrapper)new LambdaQueryWrapper().eq(MsgAppImTemplate::getTemplateName, (Object)templateName))) > 0L) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0" + templateName + "\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
        }
        if (!HussarUtils.equals((Object)msgAppImTemplate.getOpenStatus(), (Object)msgAppImTemplateDto.getOpenStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(msgAppImTemplate.getTemplateNo())))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u65e0\u6cd5\u4fee\u6539\u542f\u52a8\u72b6\u6001\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        HussarUtils.copy((Object)msgAppImTemplateDto, (Object)msgAppImTemplate);
        msgAppImTemplate.setTemplateParams(TemplateUtils.getTemplateParams((String)(msgAppImTemplateDto.getContent() + msgAppImTemplateDto.getTitle() + msgAppImTemplateDto.getUrl())));
        return ApiResponse.success((Object)super.updateById((BaseEntity)msgAppImTemplate));
    }

    @HussarTransactional
    public ApiResponse<Boolean> delTemplate(List<Long> ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(ids).stream().map(MsgAppImTemplate::getTemplateNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        return ApiResponse.success((Object)super.removeByIds(ids));
    }
}

