/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.appim.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordDto;
import com.jxdinfo.hussar.msg.appim.model.AppImChannel;
import com.jxdinfo.hussar.msg.appim.model.MsgAppImTemplate;
import com.jxdinfo.hussar.msg.appim.service.AppImChannelService;
import com.jxdinfo.hussar.msg.appim.service.AppImSendRecordService;
import com.jxdinfo.hussar.msg.appim.service.MsgAppImSendAsyncService;
import com.jxdinfo.hussar.msg.appim.service.MsgAppImTemplateService;
import com.jxdinfo.hussar.msg.appim.third.service.AppImPushThirdService;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.common.utils.PrintPushLogsUtils;
import com.jxdinfo.hussar.msg.common.utils.TemplateUtils;
import com.jxdinfo.hussar.msg.contact.service.MsgContactInfoService;
import com.jxdinfo.hussar.msg.factory.MsgUnitySendFactory;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.model.MsgBasicSendRecord;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class AppImUnitySendServiceImpl
implements MsgUnitySendFrameService,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppImUnitySendServiceImpl.class);
    @Autowired
    private MsgAppImSendAsyncService msgAppImSendAsyncService;
    @Autowired
    private MsgAppImTemplateService msgAppImTemplateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppImChannelService appImChannelService;
    @Autowired
    private MsgContactInfoService msgContactInfoService;
    @Autowired
    private AppImPushThirdService appImPushThirdService;
    @Autowired
    private AppImSendRecordService appImSendRecordService;

    public MsgBasicSendRecord msgUnitySendBefore(MsgUnitySendDto msgUnitySendDto) {
        AppImSendRecordDto appImSendRecordDto = new AppImSendRecordDto();
        try {
            AppSceneConfig appSceneConfig = (AppSceneConfig)this.appSceneConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)msgUnitySendDto.getSceneCode()));
            String sceneCode = appSceneConfig.getSceneCode();
            Long appAccessId = appSceneConfig.getAppPkId();
            appImSendRecordDto.setSceneName(appSceneConfig.getSceneName());
            appImSendRecordDto.setSceneCode(sceneCode);
            AppAccess appAccess = (AppAccess)this.appAccessService.getById((Serializable)appAccessId);
            appImSendRecordDto.setAppId(appAccess.getAppId());
            appImSendRecordDto.setAppName(appAccess.getAppName());
            ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(sceneCode, appAccessId.toString(), ServiceTypeEnum.APP_IM.getCode());
            String templateNo = configJsonData.getTemplateNo();
            MsgAppImTemplate msgAppImTemplate = (MsgAppImTemplate)this.msgAppImTemplateService.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgAppImTemplate::getTemplateNo, (Object)templateNo));
            AppImChannel appImChannel = (AppImChannel)this.appImChannelService.getOne((Wrapper)new LambdaQueryWrapper().eq(AppImChannel::getChannelNo, (Object)configJsonData.getChannelNo()));
            HussarUtils.copy((Object)appImChannel, (Object)appImSendRecordDto);
            HussarUtils.copy((Object)msgAppImTemplate, (Object)appImSendRecordDto);
            appImSendRecordDto.setImParams(TemplateUtils.getCurrentTemplateParams((Map)msgUnitySendDto.getTemplateParams(), (String)msgAppImTemplate.getTemplateParams()));
            this.replaceContent(appImSendRecordDto);
            appImSendRecordDto.setStatus(Integer.valueOf(1));
            appImSendRecordDto.setTenantCode(msgUnitySendDto.getTenantCode());
            ArrayList errorContactInfos = new ArrayList();
            List receiveAddress = this.msgContactInfoService.getReceiveAddress(msgUnitySendDto, ServiceTypeEnum.APP_IM.getCode(), appSceneConfig, errorContactInfos);
            if (HussarUtils.isEmpty((Object)receiveAddress)) {
                this.saveFailRecord(appImSendRecordDto, new RuntimeException("\u65e0\u53ef\u7528\u8054\u7cfb\u5730\u5740\uff01" + (HussarUtils.isNotEmpty(errorContactInfos) ? "\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", errorContactInfos) : "")));
                return null;
            }
            appImSendRecordDto.setUserIds(receiveAddress);
            PrintPushLogsUtils.printPushReceiveLogs((List)receiveAddress, (String)ServiceTypeEnum.APP_IM.getCode(), (Logger)LOGGER);
            appImSendRecordDto.setErrorContactInfos(errorContactInfos);
        }
        catch (Exception e) {
            this.saveFailRecord(appImSendRecordDto, e);
            throw e;
        }
        this.appImPushThirdService.thirdSendAppIm(appImSendRecordDto);
        return null;
    }

    public String getMsgSendType() {
        return null;
    }

    public boolean msgUnityThirdSend(MsgBasicSendRecord msgBasicSendRecord) {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        MsgUnitySendFactory.setSendBeansToMap("app_im", this);
    }

    private void replaceContent(AppImSendRecordDto appImSendRecordDto) {
        String title = appImSendRecordDto.getTitle();
        String url = appImSendRecordDto.getUrl();
        String content = appImSendRecordDto.getContent();
        Map imParams = appImSendRecordDto.getImParams();
        if (HussarUtils.isNotEmpty((Object)imParams)) {
            appImSendRecordDto.setTitle(TemplateUtils.replaceParams((String)title, (Map)imParams));
            appImSendRecordDto.setUrl(TemplateUtils.replaceParams((String)url, (Map)imParams));
            appImSendRecordDto.setContent(TemplateUtils.replaceParams((String)content, (Map)imParams));
        }
    }

    private void saveFailRecord(AppImSendRecordDto appImSendRecordDto, Exception e) {
        Date now = new Date();
        if (HussarUtils.isEmpty((Object)appImSendRecordDto.getChannelNo())) {
            appImSendRecordDto.setChannelNo("null");
            appImSendRecordDto.setChannelName("\u65e0\u901a\u9053\u6807\u8bc6\u8bb0\u5f55");
        }
        appImSendRecordDto.setId(null);
        appImSendRecordDto.setSendTime(now);
        appImSendRecordDto.setCreateTime(now);
        appImSendRecordDto.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        appImSendRecordDto.setStatus(SendStatusEnum.FAIL.getCode());
        appImSendRecordDto.setErrMsg("\u7ec4\u88c5\u53d1\u9001\u53c2\u6570\u53d1\u751f\u5f02\u5e38\uff1a" + (HussarUtils.isNotEmpty((Object)e.getMessage()) ? e.getMessage() : e.getClass().getName()));
        this.appImSendRecordService.saveRecord(appImSendRecordDto);
    }
}

