/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.dao.AppSceneConfigMapper;
import com.jxdinfo.hussar.msg.app.dao.SceneChannelConfigMapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.dto.SceneConfigDataDto;
import com.jxdinfo.hussar.msg.app.dto.SceneConfigQueryDto;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.model.MsgSceneContact;
import com.jxdinfo.hussar.msg.app.model.SceneChannelConfig;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.app.service.MsgSceneContactService;
import com.jxdinfo.hussar.msg.app.service.SceneChannelConfigService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
@HussarTransactional
public class AppSceneConfigServiceImpl
extends HussarServiceImpl<AppSceneConfigMapper, AppSceneConfig>
implements AppSceneConfigService {
    @Autowired
    private SceneChannelConfigService sceneChannelConfigService;
    @Autowired
    private AppSceneConfigMapper appSceneConfigMapper;
    @Autowired
    private SceneChannelConfigMapper sceneChannelConfigMapper;
    @Autowired
    private MsgSceneContactService msgSceneContactService;
    private static final String EXCEPTION_SCENE_CODE = "exception";

    public IPage<SceneConfigDataDto> listScene(Page<SceneConfigDataDto> page, SceneConfigQueryDto queryDto) {
        queryDto.setAppId(SqlQueryUtil.transferSpecialChar((String)queryDto.getAppId()));
        queryDto.setAppName(SqlQueryUtil.transferSpecialChar((String)queryDto.getAppName()));
        queryDto.setSceneName(SqlQueryUtil.transferSpecialChar((String)queryDto.getSceneName()));
        queryDto.setSceneCode(SqlQueryUtil.transferSpecialChar((String)queryDto.getSceneCode()));
        return this.appSceneConfigMapper.queryPage(page, queryDto);
    }

    public List<SceneChannelConfig> findById(Long sceneId) {
        if (HussarUtils.isEmpty((Object)sceneId)) {
            throw new HussarException("\u573a\u666fid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SceneChannelConfig::getSceneId, (Object)sceneId);
        List list = this.sceneChannelConfigService.list((Wrapper)queryWrapper);
        List msgSceneContacts = this.msgSceneContactService.list((Wrapper)new LambdaQueryWrapper().eq(MsgSceneContact::getSceneId, (Object)sceneId));
        Map<String, List<MsgSceneContact>> sceneContactMap = msgSceneContacts.stream().collect(Collectors.groupingBy(MsgSceneContact::getSendType));
        list.forEach(o -> o.setDefaultContacts((List)sceneContactMap.get(o.getChannelType())));
        return list;
    }

    public boolean saveScene(SceneConfigDataDto createDto) {
        LambdaQueryWrapper sceneNameQw = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)this.list((Wrapper)sceneNameQw.eq(AppSceneConfig::getSceneName, (Object)createDto.getSceneName())))) {
            throw new HussarException("\u573a\u666f\u540d\u79f0'" + createDto.getSceneName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        LambdaQueryWrapper sceneCodeQw = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)this.list((Wrapper)sceneCodeQw.eq(AppSceneConfig::getSceneCode, (Object)createDto.getSceneCode())))) {
            throw new HussarException("\u573a\u666f\u7f16\u7801'" + createDto.getSceneCode() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        this.save((BaseEntity)createDto);
        ArrayList<MsgSceneContact> msgSceneContacts = new ArrayList<MsgSceneContact>();
        for (SceneChannelConfig sceneChannelConfig : createDto.getSceneChannelConfigs()) {
            sceneChannelConfig.setSceneId(createDto.getId());
            for (MsgSceneContact defaultContact : sceneChannelConfig.getDefaultContacts()) {
                if (!HussarUtils.isNotEmpty((Object)defaultContact.getMsgContactId()) || !HussarUtils.isNotEmpty((Object)defaultContact.getContactName())) continue;
                MsgSceneContact msgSceneContact = new MsgSceneContact();
                msgSceneContact.setMsgContactId(defaultContact.getMsgContactId());
                msgSceneContact.setContactName(defaultContact.getContactName());
                msgSceneContact.setSceneId(createDto.getId());
                msgSceneContact.setSendType(sceneChannelConfig.getChannelType());
                msgSceneContacts.add(msgSceneContact);
            }
        }
        this.sceneChannelConfigService.saveBatch((Collection)createDto.getSceneChannelConfigs());
        this.msgSceneContactService.saveBatch(msgSceneContacts);
        return true;
    }

    public boolean updateScene(SceneConfigDataDto updateDto) {
        LambdaQueryWrapper sceneNameQw = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)this.list((Wrapper)((LambdaQueryWrapper)sceneNameQw.eq(AppSceneConfig::getSceneName, (Object)updateDto.getSceneName())).ne(AppSceneConfig::getId, (Object)updateDto.getId())))) {
            throw new HussarException("\u573a\u666f\u540d\u79f0'" + updateDto.getSceneName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        LambdaQueryWrapper sceneCodeQw = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)this.list((Wrapper)((LambdaQueryWrapper)sceneCodeQw.eq(AppSceneConfig::getSceneCode, (Object)updateDto.getSceneCode())).ne(AppSceneConfig::getId, (Object)updateDto.getId())))) {
            throw new HussarException("\u573a\u666f\u7f16\u7801'" + updateDto.getSceneCode() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        this.updateById((BaseEntity)updateDto);
        ArrayList<SceneChannelConfig> updateScene = new ArrayList<SceneChannelConfig>();
        ArrayList<SceneChannelConfig> addScene = new ArrayList<SceneChannelConfig>();
        List delSceneId = this.sceneChannelConfigService.list((Wrapper)new LambdaQueryWrapper().eq(SceneChannelConfig::getSceneId, (Object)updateDto.getId())).stream().map(SceneChannelConfig::getId).collect(Collectors.toList());
        delSceneId.removeAll(updateDto.getSceneChannelConfigs().stream().map(SceneChannelConfig::getId).collect(Collectors.toList()));
        for (SceneChannelConfig sceneChannelConfig : updateDto.getSceneChannelConfigs()) {
            if (HussarUtils.isEmpty((Object)sceneChannelConfig.getId())) {
                sceneChannelConfig.setSceneId(updateDto.getId());
                addScene.add(sceneChannelConfig);
                continue;
            }
            updateScene.add(sceneChannelConfig);
        }
        this.sceneChannelConfigService.updateBatchById(updateScene);
        if (HussarUtils.isNotEmpty(addScene)) {
            this.sceneChannelConfigService.saveBatch(addScene);
        }
        if (HussarUtils.isNotEmpty(delSceneId)) {
            this.sceneChannelConfigService.removeByIds(delSceneId);
        }
        this.msgSceneContactService.remove((Wrapper)new LambdaQueryWrapper().eq(MsgSceneContact::getSceneId, (Object)updateDto.getId()));
        ArrayList<MsgSceneContact> msgSceneContacts = new ArrayList<MsgSceneContact>();
        for (SceneChannelConfig sceneChannelConfig : updateDto.getSceneChannelConfigs()) {
            for (MsgSceneContact defaultContact : sceneChannelConfig.getDefaultContacts()) {
                if (!HussarUtils.isNotEmpty((Object)defaultContact.getMsgContactId()) || !HussarUtils.isNotEmpty((Object)defaultContact.getContactName())) continue;
                MsgSceneContact msgSceneContact = new MsgSceneContact();
                msgSceneContact.setMsgContactId(defaultContact.getMsgContactId());
                msgSceneContact.setContactName(defaultContact.getContactName());
                msgSceneContact.setSceneId(updateDto.getId());
                msgSceneContact.setSendType(sceneChannelConfig.getChannelType());
                msgSceneContacts.add(msgSceneContact);
            }
        }
        this.msgSceneContactService.saveBatch(msgSceneContacts);
        return true;
    }

    public boolean deleteScene(Long id) {
        this.removeById(id);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SceneChannelConfig::getSceneId, (Object)id);
        this.sceneChannelConfigService.remove((Wrapper)queryWrapper);
        this.msgSceneContactService.remove((Wrapper)new LambdaQueryWrapper().eq(MsgSceneContact::getSceneId, (Object)id));
        return true;
    }

    public boolean deleteSceneByIds(Long[] ids) {
        this.removeByIds(Arrays.asList(ids));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SceneChannelConfig::getSceneId, Arrays.asList(ids));
        this.sceneChannelConfigService.remove((Wrapper)queryWrapper);
        this.msgSceneContactService.remove((Wrapper)new LambdaQueryWrapper().in(MsgSceneContact::getSceneId, Arrays.asList(ids)));
        return true;
    }

    public boolean isExistScene(String data) {
        if (HussarUtils.isEmpty((Object)data)) {
            return false;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(SceneChannelConfig::getChannelConfigJson, (Object)data);
        return HussarUtils.isNotEmpty((Object)this.sceneChannelConfigService.list((Wrapper)queryWrapper));
    }

    public boolean isExistSceneInBatch(List<String> data) {
        data.removeAll(Collections.singleton(null));
        if (HussarUtils.isEmpty(data)) {
            return false;
        }
        return this.sceneChannelConfigMapper.selectSceneCount(data) > 0;
    }

    public ConfigJsonData getConfigData(String sceneCode, String appPkId, String serviceType) {
        List<SceneChannelConfig> configData = this.appSceneConfigMapper.getConfigData(sceneCode, Long.parseLong(appPkId), serviceType);
        if (HussarUtils.isEmpty(configData)) {
            throw new HussarException("\u8be5\u573a\u666f\u4e0b\u7f3a\u5c11\u914d\u7f6e\u4fe1\u606f");
        }
        ConfigJsonData configJsonData = (ConfigJsonData)JSON.parseObject((String)configData.get(0).getChannelConfigJson(), ConfigJsonData.class);
        configJsonData.setSceneName(configData.get(0).getSceneName());
        return configJsonData;
    }

    public ConfigJsonData getConfigData(String sceneCode, String sendType) {
        AppSceneConfig appSceneConfig = (AppSceneConfig)super.getOne((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getSceneCode, (Object)sceneCode));
        SceneChannelConfig sceneChannelConfig = (SceneChannelConfig)this.sceneChannelConfigService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SceneChannelConfig::getSceneId, (Object)appSceneConfig.getId())).eq(SceneChannelConfig::getChannelType, (Object)sendType));
        if (HussarUtils.isEmpty((Object)sceneChannelConfig)) {
            throw new HussarException("\u8be5\u573a\u666f\u4e0b\u7f3a\u5c11\u914d\u7f6e\u4fe1\u606f");
        }
        return (ConfigJsonData)JSON.parseObject((String)sceneChannelConfig.getChannelConfigJson(), ConfigJsonData.class);
    }

    public List<ConfigJsonData> getConfigDataTemplate(Long appPkId, String sceneCategory) {
        ArrayList<ConfigJsonData> configJsonDatas = new ArrayList<ConfigJsonData>();
        List<SceneChannelConfig> configData = this.appSceneConfigMapper.getConfigDataTemplate(appPkId, EXCEPTION_SCENE_CODE, sceneCategory);
        if (HussarUtils.isNotEmpty(configData)) {
            for (SceneChannelConfig sceneChannelConfig : configData) {
                ConfigJsonData configJsonData = (ConfigJsonData)JSON.parseObject((String)sceneChannelConfig.getChannelConfigJson(), ConfigJsonData.class);
                configJsonData.setSceneName(sceneChannelConfig.getSceneName());
                configJsonData.setChannelType(sceneChannelConfig.getChannelType());
                configJsonDatas.add(configJsonData);
            }
        }
        return configJsonDatas;
    }

    public List<AppSceneConfig> getAppSceneConfigBytag(String tagName) {
        return this.appSceneConfigMapper.getAppSceneConfigBytag(tagName);
    }
}

