/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.thrid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.IdUtil;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.msg.sms.config.mongodb.repository.MsgSmsSendRecordRepository;
import com.jxdinfo.hussar.msg.sms.mongodb.document.MsgSmsSendRecord;
import com.jxdinfo.hussar.msg.sms.third.service.SmsSendService;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="ALIYUN")
public class AliyunSmsSendServiceImpl
implements SmsSendService {
    private static final Logger logger = LoggerFactory.getLogger(AliyunSmsSendServiceImpl.class);
    @Autowired
    private MsgSmsSendRecordRepository msgSmsSendRecordRepository;
    @Autowired
    private MsgJobService msgJobService;

    public Client createClient(String accessKeyId, String accessKeySecret) throws Exception {
        Config config = new Config().setAccessKeyId(accessKeyId).setAccessKeySecret(accessKeySecret);
        config.endpoint = "dysmsapi.aliyuncs.com";
        return new Client(config);
    }

    public boolean sendSms(MsgSmsSendRecord record) throws Exception {
        Client client = this.createClient(record.getAccessKeyId(), record.getAccessKeySecret());
        String[] phoneNumbersList = record.getPhoneNumber().split(",");
        if (ToolUtil.isNotEmpty((Object)record.getContent()) && ToolUtil.isNotEmpty((Object)record.getParams())) {
            String[] content = new String[]{record.getContent()};
            JSONObject.parseObject((String)record.getParams()).forEach((k, v) -> {
                content[0] = content[0].replace("#{" + k + "}", String.valueOf(v));
            });
            record.setContent(content[0]);
        }
        boolean flag = true;
        if (record.getTim() != null && record.getTim().booleanValue()) {
            Date sendTime = record.getJobTime();
            Date now = new Date();
            for (String phone : phoneNumbersList) {
                String id = IdUtil.fastSimpleUuid();
                MsgSmsSendRecord jobParams = new MsgSmsSendRecord();
                jobParams.setMsgId(id);
                jobParams.setPhoneNumber(phone);
                jobParams.setSignName(record.getSignName());
                jobParams.setTemplateCode(record.getTemplateCode());
                jobParams.setParams(record.getParams());
                jobParams.setChannelType(record.getChannelType());
                jobParams.setAccessKeyId(record.getAccessKeyId());
                jobParams.setAccessKeySecret(record.getAccessKeySecret());
                this.msgJobService.saveMsgJob(record.getJobTime(), JSONObject.toJSONString((Object)jobParams), MsgJobEnum.MSG_SMS);
                record.setId(id);
                record.setSendTime(sendTime);
                record.setParams(record.getParams());
                record.setPhoneNumber(phone);
                record.setErrMsg("");
                record.setStatus(SendStatusEnum.SENDING.getCode());
                record.setBizId("");
                record.setCreateTime(now);
                record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
                this.msgSmsSendRecordRepository.save(record);
            }
        } else {
            for (String phoneNumber : phoneNumbersList) {
                Date now = new Date();
                String id = IdUtil.fastSimpleUuid();
                record.setId(id);
                SendSmsRequest sendSmsRequest = new SendSmsRequest().setPhoneNumbers(phoneNumber).setSignName(record.getSignName()).setTemplateCode(record.getTemplateCode()).setTemplateParam(record.getParams());
                SendSmsResponse res = new SendSmsResponse();
                try {
                    res = client.sendSms(sendSmsRequest);
                }
                catch (Exception e) {
                    record.setErrMsg(e.getMessage());
                    record.setStatus(SendStatusEnum.FAIL.getCode());
                    flag = false;
                    logger.error("\u53d1\u9001\u77ed\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
                }
                if (flag) {
                    record.setErrMsg(res.getBody().getMessage());
                    record.setStatus("OK".equals(res.getBody().getCode()) ? SendStatusEnum.SUCCESS.getCode() : SendStatusEnum.FAIL.getCode());
                    record.setBizId(res.getBody().getBizId());
                    if (!"OK".equals(res.getBody().getCode())) {
                        logger.error("\u53d1\u9001\u77ed\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a" + res.getBody().getMessage());
                    }
                }
                record.setPhoneNumber(phoneNumber);
                record.setSendTime(now);
                record.setCreateTime(now);
                record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
                this.msgSmsSendRecordRepository.save(record);
            }
        }
        return flag;
    }

    public boolean jobSend(MsgSmsSendRecord record) throws Exception {
        Client client = this.createClient(record.getAccessKeyId(), record.getAccessKeySecret());
        String[] phoneNumbersList = record.getPhoneNumber().split(",");
        Optional optional = this.msgSmsSendRecordRepository.findById(record.getMsgId());
        MsgSmsSendRecord msgSmsSendRecord = (MsgSmsSendRecord)optional.get();
        SendSmsRequest sendSmsRequest = new SendSmsRequest().setPhoneNumbers(phoneNumbersList[0]).setSignName(record.getSignName()).setTemplateCode(record.getTemplateCode()).setTemplateParam(record.getParams());
        try {
            SendSmsResponse res = client.sendSms(sendSmsRequest);
            msgSmsSendRecord.setErrMsg(res.getBody().getMessage());
            msgSmsSendRecord.setStatus("OK".equals(res.getBody().getCode()) ? SendStatusEnum.SUCCESS.getCode() : SendStatusEnum.FAIL.getCode());
        }
        catch (Exception e) {
            msgSmsSendRecord.setErrMsg(e.getMessage());
            msgSmsSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
            logger.error("\u53d1\u9001\u77ed\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
        }
        msgSmsSendRecord.setSendTime(new Date());
        this.msgSmsSendRecordRepository.save(msgSmsSendRecord);
        return true;
    }
}

