/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.constant.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.sms.dao.MsgSmsSignMapper;
import com.jxdinfo.hussar.msg.sms.dto.SmsChannelQueryVo;
import com.jxdinfo.hussar.msg.sms.dto.SmsSignCreateDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsSignPageDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsSignQueryVo;
import com.jxdinfo.hussar.msg.sms.dto.SmsSignUpdateDto;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsSign;
import com.jxdinfo.hussar.msg.sms.service.SmsChannelService;
import com.jxdinfo.hussar.msg.sms.service.SmsSignService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SmsSignServiceImpl
extends HussarServiceImpl<MsgSmsSignMapper, MsgSmsSign>
implements SmsSignService {
    @Autowired
    private SmsChannelService smsChannelService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<MsgSmsSign> listPage(Page page, SmsSignPageDto pageDto) {
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getSignName())) {
            pageDto.setSignName(pageDto.getSignName().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getSignNo())) {
            pageDto.setSignNo(pageDto.getSignNo().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelName())) {
            pageDto.setChannelName(pageDto.getChannelName().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelNo())) {
            pageDto.setChannelNo(pageDto.getChannelNo().trim());
        }
        IPage<MsgSmsSign> pageList = ((MsgSmsSignMapper)this.baseMapper).queryPage(page, pageDto);
        return pageList;
    }

    public SmsSignQueryVo findById(Long id) {
        MsgSmsSign entity = (MsgSmsSign)super.getById((Serializable)id);
        return this.entity2QueryVo(entity);
    }

    public boolean save(SmsSignCreateDto createDto) {
        MsgSmsSign entity = new MsgSmsSign();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        entity.setSignNo(BizCodeUtils.generalBizCode(BizCodeEnum.MSM_SIGN));
        if (HussarUtils.equals((Object)"1", (Object)this.checkSignUnique(entity))) {
            throw new HussarException("\u7b7e\u540d'" + entity.getSignName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.save((BaseEntity)entity);
    }

    public boolean updateById(SmsSignUpdateDto updateDto) {
        MsgSmsSign entity = new MsgSmsSign();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        if (HussarUtils.equals((Object)"1", (Object)this.checkSignUnique(entity))) {
            throw new HussarException("\u7b7e\u540d'" + entity.getSignName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.updateById((BaseEntity)entity);
    }

    public boolean delete(Long id) {
        MsgSmsSign msgSmsSign = (MsgSmsSign)super.getById((Serializable)id);
        if (HussarUtils.isEmpty((Object)msgSmsSign)) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7b7e\u540d\u6570\u636e");
        }
        if (this.appSceneConfigService.isExistScene(msgSmsSign.getSignNo())) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        SmsChannelQueryVo smsChannelQueryVo = this.smsChannelService.findById(msgSmsSign.getChannelId());
        if (HussarUtils.isEmpty((Object)smsChannelQueryVo)) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        return super.removeById((Serializable)id);
    }

    public boolean updateStatus(Long id) {
        MsgSmsSign msgSmsSign = (MsgSmsSign)super.getById((Serializable)id);
        if (HussarUtils.isEmpty((Object)msgSmsSign)) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7b7e\u540d\u6570\u636e");
        }
        MsgSmsSign entity = new MsgSmsSign();
        entity.setId(id);
        entity.setStatus(msgSmsSign.getStatus().equals(OpenStatusEnum.DISABLED.getCode()) ? OpenStatusEnum.ENABLE.getCode() : OpenStatusEnum.DISABLED.getCode());
        return super.updateById((BaseEntity)entity);
    }

    public List<SmsSignQueryVo> getSignListByChannelId(Long channelId) {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgSmsSign::getChannelId, (Object)channelId);
        qw.lambda().eq(MsgSmsSign::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgSmsSignMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public boolean deleteSignByIds(Long[] ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(Arrays.asList(ids)).stream().map(MsgSmsSign::getSignNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        return super.removeByIds(Arrays.asList(ids));
    }

    private SmsSignQueryVo entity2QueryVo(MsgSmsSign entity) {
        SmsSignQueryVo vo = new SmsSignQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }

    private String checkSignUnique(MsgSmsSign entity) {
        Long id = HussarUtils.isEmpty((Object)entity.getId()) ? -1L : entity.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgSmsSign::getSignName, (Object)entity.getSignName());
        MsgSmsSign info = (MsgSmsSign)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)info) && !HussarUtils.equals((Object)info.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

