/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.Strings;
import com.jxdinfo.hussar.msg.sms.config.mongodb.repository.MsgSmsSendRecordRepository;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordPageDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordQueryDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordQueryVo;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordStatisticsVo;
import com.jxdinfo.hussar.msg.sms.mongodb.document.MsgSmsSendRecord;
import com.jxdinfo.hussar.msg.sms.service.SmsChannelService;
import com.jxdinfo.hussar.msg.sms.service.SmsSendRecordService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SmsSendRecordServiceImpl
implements SmsSendRecordService {
    @Autowired
    private MsgSmsSendRecordRepository msgSmsSendRecordRepository;
    @Autowired
    private SmsChannelService smsChannelService;
    @Autowired
    private MongoTemplate mongoTemplate;

    public Page<MsgSmsSendRecord> listPage(Page pageable, SmsSendRecordPageDto pageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)pageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getAppName())) {
            criteria.and("appName").regex(Strings.format("%s%s%s", ".*", pageDto.getAppName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getPhoneNumber())) {
            criteria.and("phoneNumber").regex(Strings.format("%s%s%s", ".*", pageDto.getPhoneNumber(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelNo())) {
            criteria.and("channelNo").regex(Strings.format("%s%s%s", ".*", pageDto.getChannelNo(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelName())) {
            criteria.and("channelName").regex(Strings.format("%s%s%s", ".*", pageDto.getChannelName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSignNo())) {
            criteria.and("signNo").regex(Strings.format("%s%s%s", ".*", pageDto.getSignNo(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSignName())) {
            criteria.and("signName").regex(Strings.format("%s%s%s", ".*", pageDto.getSignName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getTemplateNo())) {
            criteria.and("templateNo").regex(Strings.format("%s%s%s", ".*", pageDto.getTemplateNo(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getTemplateName())) {
            criteria.and("templateName").regex(Strings.format("%s%s%s", ".*", pageDto.getTemplateName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format("%s%s%s", ".*", pageDto.getSceneCode(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format("%s%s%s", ".*", pageDto.getSceneName(), ".*"));
        }
        if (pageDto.getStatus() != null) {
            criteria.and("status").is((Object)pageDto.getStatus());
        }
        if (pageDto.getContent() != null) {
            String reges = Strings.format("%s%s%s", "^.*", pageDto.getContent().trim(), ".*$");
            Pattern pattern = Pattern.compile(reges, 2);
            criteria.and("content").regex(pattern);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, MsgSmsSendRecord.class);
        query.skip((pageable.getCurrent() - 1L) * pageable.getSize());
        query.limit((int)pageable.getSize());
        List list = this.mongoTemplate.find(query, MsgSmsSendRecord.class);
        list.forEach(e -> {
            if (e.getPhoneNumber().length() == 11) {
                e.setPhoneNumber(e.getPhoneNumber().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));
            } else {
                e.setPhoneNumber(e.getPhoneNumber().replaceAll("(\\d{5})(-?)\\d*(\\d{4})", "$1$2****$3"));
            }
        });
        Page page = new Page();
        page.setCurrent(pageable.getCurrent());
        page.setSize(pageable.getSize());
        page.setTotal(total);
        page.setRecords(list);
        return page;
    }

    public SmsSendRecordQueryVo findById(String id) {
        Optional entity = this.msgSmsSendRecordRepository.findById(id);
        return entity.map(this::entity2QueryVo).orElse(null);
    }

    public List<ChannelsVo> getAllChannels() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"channelNo", "channelName"})});
        return this.mongoTemplate.aggregate(agg, MsgSmsSendRecord.class, ChannelsVo.class).getMappedResults();
    }

    public List<SmsSendRecordStatisticsVo> sendStatistics(SmsSendRecordQueryDto queryDto) {
        Criteria criteria = new Criteria();
        if (queryDto.getBeginTime() != null && queryDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)queryDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)queryDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)queryDto.getChannelNo());
        }
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createDate", "status", "channelName"}).count().as("count")});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, MsgSmsSendRecord.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDate).distinct().sorted().collect(Collectors.toList());
        ArrayList<SmsSendRecordStatisticsVo> result = new ArrayList<SmsSendRecordStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            SmsSendRecordStatisticsVo statisticsVo = new SmsSendRecordStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName(HussarUtils.isNotEmpty((Object)aggs) ? ((SendRecordAgg)aggs.get(0)).getChannelName() : null);
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createDate, aggs1) -> {
                SmsSendRecordStatisticsVo.SmsChannelSendStatisticAgg aggVo = new SmsSendRecordStatisticsVo.SmsChannelSendStatisticAgg();
                aggVo.setSendDate(createDate);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    private SmsSendRecordQueryVo entity2QueryVo(MsgSmsSendRecord entity) {
        SmsSendRecordQueryVo vo = new SmsSendRecordQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String createDate;
        private String channelName;
        private Integer status;
        private Long count;

        public String getChannelNo() {
            return this.channelNo;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }
    }
}

