/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.controller;

import com.jxdinfo.hussar.msg.sms.config.mq.SmsRabbitMqSendService;
import com.jxdinfo.hussar.msg.sms.dto.SmsChannelQueryVo;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendMsgCreateDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsSignQueryVo;
import com.jxdinfo.hussar.msg.sms.dto.SmsTemplateQueryVo;
import com.jxdinfo.hussar.msg.sms.service.SmsChannelService;
import com.jxdinfo.hussar.msg.sms.service.SmsSignService;
import com.jxdinfo.hussar.msg.sms.service.SmsTemplateService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u77ed\u4fe1\u53d1\u9001"})
@RequestMapping(value={"msg/sms"})
public class SmsSendController {
    @Autowired
    private SmsChannelService smsChannelService;
    @Autowired
    private SmsSignService smsSignService;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private SmsRabbitMqSendService smsRabbitMqSendService;

    @GetMapping(value={"/getChannelList"})
    @ApiOperation(value="\u83b7\u53d6\u77ed\u4fe1\u901a\u9053\u5217\u8868", notes="\u83b7\u53d6\u77ed\u4fe1\u901a\u9053\u5217\u8868")
    @AuditLog(moduleName="\u77ed\u4fe1\u53d1\u9001", eventDesc="\u83b7\u53d6\u77ed\u4fe1\u901a\u9053\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SmsChannelQueryVo>> getChannelList() {
        return ApiResponse.success((Object)this.smsChannelService.getChannelList());
    }

    @GetMapping(value={"/getSignListByChannelId"})
    @ApiOperation(value="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u7b7e\u540d\u5217\u8868", notes="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u7b7e\u540d\u5217\u8868")
    @AuditLog(moduleName="\u77ed\u4fe1\u53d1\u9001", eventDesc="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u7b7e\u540d\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SmsSignQueryVo>> getSignListByChannelId(@RequestParam Long channelId) {
        return ApiResponse.success((Object)this.smsSignService.getSignListByChannelId(channelId));
    }

    @GetMapping(value={"/getTemplateListByChannelId"})
    @ApiOperation(value="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u6a21\u677f\u5217\u8868", notes="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u6a21\u677f\u5217\u8868")
    @AuditLog(moduleName="\u77ed\u4fe1\u53d1\u9001", eventDesc="\u6839\u636e\u901a\u9053id\u83b7\u53d6\u6a21\u677f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SmsTemplateQueryVo>> getTemplateListByChannelId(@RequestParam Long channelId) {
        return ApiResponse.success((Object)this.smsTemplateService.getTemplateListByChannelId(channelId));
    }

    @PostMapping(value={"/sendSmsMsg"})
    @ApiOperation(value="\u53d1\u9001\u6d88\u606f", notes="\u53d1\u9001\u6d88\u606f")
    @AuditLog(moduleName="\u77ed\u4fe1\u53d1\u9001", eventDesc="\u53d1\u9001\u6d88\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> sendSmsMsg(@Validated @RequestBody SmsSendMsgCreateDto createDto) {
        return ApiResponse.status((boolean)this.smsRabbitMqSendService.sendSmsMsgMq(createDto));
    }
}

