/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.constant.enums.ChannelTypeEnum;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.QueueEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendMsgCreateDto;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsChannel;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsSign;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsTemplate;
import com.jxdinfo.hussar.msg.sms.mongodb.document.MsgSmsSendRecord;
import com.jxdinfo.hussar.msg.sms.service.SmsChannelService;
import com.jxdinfo.hussar.msg.sms.service.SmsSignService;
import com.jxdinfo.hussar.msg.sms.service.SmsTemplateService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsRabbitMqSendService {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private SmsChannelService smsChannelService;
    @Autowired
    private SmsSignService smsSignService;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public boolean sendSmsMsgMq(SmsSendMsgCreateDto createDto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(createDto.getAppId(), createDto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(createDto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.SMS.getCode());
        createDto.setChannelNo(configJsonData.getChannelNo());
        createDto.setTemplateNo(configJsonData.getTemplateNo());
        createDto.setSignNo(configJsonData.getSignNo());
        MsgSmsChannel channel = this.getSmsChannel(createDto.getChannelId(), createDto.getChannelNo());
        MsgSmsSign sign = this.getSmsSign(createDto.getSignId(), createDto.getSignNo());
        MsgSmsTemplate template = this.getSmsTemplate(createDto.getTemplateId(), createDto.getTemplateNo());
        String aliyunTemplateParams = this.getTemplateParams(createDto, channel);
        CharSequence[] tencentTemplateParams = this.getTencentTemplateParams(createDto, channel);
        MsgSmsSendRecord record = new MsgSmsSendRecord();
        record.setChannelId(channel.getId());
        record.setChannelNo(channel.getChannelNo());
        record.setChannelName(channel.getChannelName());
        record.setSignId(sign.getId());
        record.setSignNo(sign.getSignNo());
        record.setSignName(sign.getSignName());
        record.setTemplateId(template.getId());
        record.setTemplateNo(template.getTemplateNo());
        record.setTemplateName(template.getTemplateName());
        String phone = StringUtils.join((Object[])createDto.getPhoneNumbers().toArray(), (String)",");
        record.setPhoneNumber(phone);
        record.setTemplateCode(template.getTemplateCode());
        record.setAccessKeyId(channel.getKeyId());
        record.setAccessKeySecret(channel.getKeySecret());
        record.setSmsSdkAppId(channel.getAppKey());
        record.setRegion(channel.getRegion());
        String channelTypeName = ChannelTypeEnum.getName(channel.getChannelType());
        record.setContent(template.getTemplateContent());
        record.setChannelType(channelTypeName);
        record.setTim(createDto.getTim());
        record.setJobTime(createDto.getJobTime());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(createDto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(createDto.getAppSecret());
        record.setSceneCode(createDto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        String aliyun = "ALIYUN";
        String tencent = "TENCENT";
        if (aliyun.equals(channelTypeName)) {
            record.setParams(aliyunTemplateParams);
        } else if (tencent.equals(channelTypeName)) {
            record.setParams(String.join((CharSequence)",", tencentTemplateParams));
        }
        String s = JSONObject.toJSONString((Object)record);
        Message message = new Message(s.getBytes(), new MessageProperties());
        this.rabbitTemplate.convertAndSend(QueueEnum.QUEUE_MSG_SMS.getExchange(), QueueEnum.QUEUE_MSG_SMS.getRouteKey(), (Object)message);
        return true;
    }

    private MsgSmsChannel getSmsChannel(Long channelId, String channelNo) {
        MsgSmsChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(MsgSmsChannel::getId, (Object)channelId);
        }
        if (HussarUtils.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(MsgSmsChannel::getChannelNo, (Object)channelNo);
        }
        if ((channel = (MsgSmsChannel)this.smsChannelService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }

    private MsgSmsSign getSmsSign(Long signId, String signNo) {
        MsgSmsSign sign;
        QueryWrapper qw = new QueryWrapper();
        if (signId != null) {
            qw.lambda().eq(MsgSmsSign::getId, (Object)signId);
        }
        if (HussarUtils.isNotEmpty((Object)signNo)) {
            qw.lambda().eq(MsgSmsSign::getSignNo, (Object)signNo);
        }
        if ((sign = (MsgSmsSign)this.smsSignService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7b7e\u540d");
        }
        if (sign.getStatus() == null || !sign.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u7b7e\u540d\u672a\u542f\u7528");
        }
        QueryWrapper qw1 = new QueryWrapper();
        qw1.lambda().eq(MsgSmsChannel::getId, (Object)sign.getChannelId());
        qw1.lambda().eq(MsgSmsChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        long count = this.smsChannelService.count((Wrapper)qw1);
        if (count == 0L) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        return sign;
    }

    private MsgSmsTemplate getSmsTemplate(Long templateId, String templateNo) {
        MsgSmsTemplate template;
        QueryWrapper qw = new QueryWrapper();
        if (templateId != null) {
            qw.lambda().eq(MsgSmsTemplate::getId, (Object)templateId);
        }
        if (HussarUtils.isNotEmpty((Object)templateNo)) {
            qw.lambda().eq(MsgSmsTemplate::getTemplateNo, (Object)templateNo);
        }
        if ((template = (MsgSmsTemplate)this.smsTemplateService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677f");
        }
        if (template.getStatus() == null || !template.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u6a21\u677f\u672a\u542f\u7528");
        }
        QueryWrapper qw1 = new QueryWrapper();
        qw1.lambda().eq(MsgSmsChannel::getId, (Object)template.getChannelId());
        qw1.lambda().eq(MsgSmsChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        long count = this.smsChannelService.count((Wrapper)qw1);
        if (count == 0L) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        return template;
    }

    private String getTemplateParams(SmsSendMsgCreateDto createDto, MsgSmsChannel channel) {
        Map aliyunTemplateParams = new HashMap();
        if (ChannelTypeEnum.ALIYUN.getType().equals(channel.getChannelType()) && createDto.getAliyunParams() != null) {
            aliyunTemplateParams = createDto.getAliyunParams();
        }
        return JSONObject.toJSONString(aliyunTemplateParams);
    }

    private String[] getTencentTemplateParams(SmsSendMsgCreateDto createDto, MsgSmsChannel channel) {
        String[] tencentTemplateParams = new String[]{};
        if (ChannelTypeEnum.TENCENT.getType().equals(channel.getChannelType()) && createDto.getTencentParams() != null) {
            tencentTemplateParams = createDto.getTencentParams();
        }
        return tencentTemplateParams;
    }
}

