/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.sms.mongodb.document.MsgSmsSendRecord;
import com.jxdinfo.hussar.msg.sms.third.service.SmsPushService;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SmsRabbitMqReceiver {
    private static final Logger logger = LoggerFactory.getLogger(SmsRabbitMqReceiver.class);
    @Autowired
    private SmsPushService smsPushService;

    @RabbitHandler
    @RabbitListener(queues={"#{smsQueue.name}"})
    public void handlePay(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            logger.info("msg sms json:{}", (Object)json);
            MsgSmsSendRecord record = (MsgSmsSendRecord)JSONObject.parseObject((String)json, MsgSmsSendRecord.class);
            boolean b = this.smsPushService.sendMsg(record);
            logger.info("msg sms res:{}", (Object)b);
        }
        catch (Exception e) {
            logger.error("\u77ed\u4fe1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

