/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.notice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.msg.constant.enums.AppEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.IdUtil;
import com.jxdinfo.hussar.msg.constant.utils.Strings;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.msg.notice.config.mongodb.repository.NoticeSendRecordRepository;
import com.jxdinfo.hussar.msg.notice.dto.NoticeInfoPageDto;
import com.jxdinfo.hussar.msg.notice.dto.NoticeSendRecordQueryVo;
import com.jxdinfo.hussar.msg.notice.dto.NoticeSendStatisticsVo;
import com.jxdinfo.hussar.msg.notice.model.Notice;
import com.jxdinfo.hussar.msg.notice.mongodb.document.NoticeSendRecord;
import com.jxdinfo.hussar.msg.notice.service.NoticeSendRecordService;
import com.jxdinfo.hussar.notice.bo.SysNoticeAttachmentBo;
import com.jxdinfo.hussar.notice.model.SysNotice;
import com.jxdinfo.hussar.notice.service.IMyNoticeAttachmentService;
import com.jxdinfo.hussar.notice.service.IMyNoticeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class NoticeSendRecordServiceImpl
implements NoticeSendRecordService {
    private static final Logger logger = LoggerFactory.getLogger(NoticeSendRecordServiceImpl.class);
    @Autowired
    private IMyNoticeService myNoticeService;
    @Autowired
    private NoticeSendRecordRepository noticeSendRecordRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private IMyNoticeAttachmentService myNoticeAttachmentService;
    @Autowired
    private MsgJobService msgJobService;

    public Boolean sendMsgNotice(Notice sysNotice) {
        Date now = new Date();
        Date sendTime = new Date();
        String errMsg = "";
        Integer status = SendStatusEnum.SENDING.getCode();
        sysNotice.setId(IdUtil.fastSimpleUuid());
        if (sysNotice.getTim() != null && sysNotice.getTim().booleanValue()) {
            sendTime = sysNotice.getJobTime();
            this.msgJobService.saveMsgJob(sysNotice.getJobTime(), JSONObject.toJSONString((Object)sysNotice), MsgJobEnum.MSG_NOTICE);
        } else {
            NoticeSendRecord resultSend = this.sendNotice(sysNotice);
            status = resultSend.getStatus();
            errMsg = resultSend.getErrMsg();
        }
        NoticeSendRecord noticeSendRecord = new NoticeSendRecord();
        BeanUtils.copyProperties((Object)sysNotice, (Object)noticeSendRecord);
        noticeSendRecord.setReleaseDate(sendTime);
        noticeSendRecord.setSendTime(sendTime);
        noticeSendRecord.setStatus(status);
        noticeSendRecord.setErrMsg(errMsg);
        noticeSendRecord.setCreateTime(now);
        noticeSendRecord.setCreateDateNotHour(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        this.noticeSendRecordRepository.save(noticeSendRecord);
        return !SendStatusEnum.FAIL.getCode().equals(status);
    }

    public Boolean sendTestMsgNotice(Notice notice) {
        notice.setAppId(AppEnum.TEST.getAppId());
        notice.setAppName(AppEnum.TEST.getAppName());
        notice.setAppSecret(AppEnum.TEST.getAppSecret());
        notice.setSceneCode(AppEnum.TEST.getSceneCode());
        notice.setSceneName(AppEnum.TEST.getSceneName());
        return this.sendMsgNotice(notice);
    }

    public Boolean jonSendNotice(Notice notice) {
        NoticeSendRecord resultSend = this.sendNotice(notice);
        Optional optional = this.noticeSendRecordRepository.findById(notice.getId());
        NoticeSendRecord entity = optional.orElse(new NoticeSendRecord());
        if (entity.getId() != null) {
            entity.setSendTime(new Date());
            entity.setStatus(resultSend.getStatus());
            entity.setErrMsg(resultSend.getErrMsg());
            this.noticeSendRecordRepository.save(entity);
        }
        return true;
    }

    private NoticeSendRecord sendNotice(Notice sysNotice) {
        NoticeSendRecord noticeSendRecord = new NoticeSendRecord();
        try {
            SysNotice sysNotice1 = new SysNotice();
            BeanUtils.copyProperties((Object)sysNotice, (Object)sysNotice1);
            sysNotice1.setCreateTime(LocalDateTime.now());
            if (sysNotice1.getReleaseDate() == null) {
                sysNotice1.setReleaseDate(LocalDateTime.now());
            }
            ApiResponse apiResponse = this.myNoticeService.insertOrUpdate(sysNotice1);
            if (ToolUtil.isNotEmpty((Object)sysNotice.getNoticeAttachmentId())) {
                SysNoticeAttachmentBo sysNoticeAttachment = new SysNoticeAttachmentBo();
                sysNoticeAttachment.setNoticeAttachmentId(sysNotice.getNoticeAttachmentId());
                sysNoticeAttachment.setNoticeId(Long.valueOf(Long.parseLong(apiResponse.getData().toString())));
                sysNoticeAttachment.setCreateTime(LocalDateTime.now());
                this.myNoticeAttachmentService.insertOrUpdate(sysNoticeAttachment);
            }
            noticeSendRecord.setStatus(SendStatusEnum.SUCCESS.getCode());
        }
        catch (Exception e) {
            logger.error("\u5185\u90e8\u6d88\u606f\u53d1\u9001\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
            noticeSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
            noticeSendRecord.setErrMsg(e.getMessage());
        }
        return noticeSendRecord;
    }

    public NoticeSendRecordQueryVo findById(String id) {
        Optional entity = this.noticeSendRecordRepository.findById(id);
        return entity.map(this::entity2QueryVo).orElse(null);
    }

    public IPage<NoticeSendRecord> listPage(Page pageable, NoticeInfoPageDto noticeInfoPageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (noticeInfoPageDto.getBeginTime() != null && noticeInfoPageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)noticeInfoPageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)noticeInfoPageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (ToolUtil.isNotEmpty((Object)noticeInfoPageDto.getAppName())) {
            criteria.and("appName").regex(Strings.format("%s%s%s", ".*", noticeInfoPageDto.getAppName().trim(), ".*"));
        }
        if (ToolUtil.isNotEmpty((Object)noticeInfoPageDto.getNoticeTitle())) {
            String reges = Strings.format("%s%s%s", "^.*", noticeInfoPageDto.getNoticeTitle().trim(), ".*$");
            Pattern pattern = Pattern.compile(reges, 2);
            criteria.and("noticeTitle").regex(pattern);
        }
        if (noticeInfoPageDto.getStatus() != null) {
            criteria.and("status").is((Object)noticeInfoPageDto.getStatus());
        }
        if (noticeInfoPageDto.getNoticeTypeId() != null) {
            criteria.and("noticeTypeId").is((Object)noticeInfoPageDto.getNoticeTypeId());
        }
        if (HussarUtils.isNotEmpty((Object)noticeInfoPageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format("%s%s%s", ".*", noticeInfoPageDto.getSceneCode(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)noticeInfoPageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format("%s%s%s", ".*", noticeInfoPageDto.getSceneName(), ".*"));
        }
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, NoticeSendRecord.class);
        query.skip((pageable.getCurrent() - 1L) * pageable.getSize());
        query.limit((int)pageable.getSize());
        List list = this.mongoTemplate.find(query, NoticeSendRecord.class);
        for (NoticeSendRecord noticeSendRecord : list) {
            if (!Objects.equals(noticeSendRecord.getStatus(), SendStatusEnum.SUCCESS.getCode())) continue;
            noticeSendRecord.setErrMsg("\u6210\u529f");
        }
        Page page = new Page();
        page.setCurrent(pageable.getCurrent());
        page.setSize(pageable.getSize());
        page.setTotal(total);
        page.setRecords(list);
        return page;
    }

    public ApiResponse sendStatistics(Date beginTime, Date endTime, String channelNo) {
        Criteria criteria = new Criteria();
        if (beginTime != null && endTime != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)beginTime);
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)endTime);
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (ToolUtil.isNotEmpty((Object)channelNo)) {
            criteria.and("noticeTypeId").is((Object)Long.parseLong(channelNo));
        }
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"noticeTypeId", "createDateNotHour", "status"}).count().as("count")});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, NoticeSendRecord.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getNoticeTypeId));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDateNotHour).distinct().sorted().collect(Collectors.toList());
        ArrayList result = new ArrayList();
        listMap.forEach((noticeTypeId, aggs) -> {
            NoticeSendStatisticsVo statisticsVo = new NoticeSendStatisticsVo();
            statisticsVo.setChannelNo(noticeTypeId);
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDateNotHour, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createDateNotHour, aggs1) -> {
                NoticeSendStatisticsVo.NoticeSendStatisticAgg aggVo = new NoticeSendStatisticsVo.NoticeSendStatisticAgg();
                aggVo.setSendDate(createDateNotHour);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return ApiResponse.success(result);
    }

    private NoticeSendRecordQueryVo entity2QueryVo(NoticeSendRecord entity) {
        NoticeSendRecordQueryVo vo = new NoticeSendRecordQueryVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        return vo;
    }

    public static class SendRecordAgg {
        private String createDateNotHour;
        private String createDate;
        private Date createTime;
        private Long count;
        private Integer status;
        private String noticeTypeId;

        public String getNoticeTypeId() {
            return this.noticeTypeId;
        }

        public void setNoticeTypeId(String noticeTypeId) {
            this.noticeTypeId = noticeTypeId;
        }

        public Date getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Date createTime) {
            this.createTime = createTime;
        }

        public String getCreateDateNotHour() {
            return this.createDateNotHour;
        }

        public void setCreateDateNotHour(String createDateNotHour) {
            this.createDateNotHour = createDateNotHour;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }
    }
}

