/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.notice.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.notice.model.Notice;
import com.jxdinfo.hussar.msg.notice.service.NoticeSendRecordService;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NoticeRabbitMqReceiver {
    private static final Logger logger = LoggerFactory.getLogger(NoticeRabbitMqReceiver.class);
    @Autowired
    private NoticeSendRecordService noticeSendRecordService;

    @RabbitHandler
    @RabbitListener(queues={"#{noticeQueue.name}"})
    public void handlePay(Message message) {
        try {
            logger.info(String.valueOf(message));
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            logger.info("msg notice json:{}", (Object)json);
            Notice notice = (Notice)JSONObject.parseObject((String)json, Notice.class);
            this.noticeSendRecordService.sendMsgNotice(notice);
        }
        catch (Exception e) {
            logger.error("notice\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

