/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mp.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.constant.enums.AppEnum;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.IdUtil;
import com.jxdinfo.hussar.msg.constant.utils.Strings;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.msg.mp.config.mongodb.repository.MsgMpSendRecordRepository;
import com.jxdinfo.hussar.msg.mp.dto.MpChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.mp.dto.MpSendMsgCreateDto;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordPageDto;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordQueryVo;
import com.jxdinfo.hussar.msg.mp.model.MsgMpChannel;
import com.jxdinfo.hussar.msg.mp.model.MsgMpTemplate;
import com.jxdinfo.hussar.msg.mp.mongodb.document.MsgMpSendRecord;
import com.jxdinfo.hussar.msg.mp.service.MpChannelService;
import com.jxdinfo.hussar.msg.mp.service.MpSendRecordService;
import com.jxdinfo.hussar.msg.mp.service.MpTemplateService;
import com.jxdinfo.hussar.msg.mp.third.dto.WxMpSendMsgReqDtoDto;
import com.jxdinfo.hussar.msg.mp.third.service.MpSendMsgService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MpSendRecordServiceImpl
implements MpSendRecordService {
    private static final Logger logger = LoggerFactory.getLogger(MpSendRecordServiceImpl.class);
    @Autowired
    private MsgMpSendRecordRepository msgMpSendRecordRepository;
    @Autowired
    private MpChannelService mpChannelService;
    @Autowired
    private MpTemplateService mpTemplateService;
    @Autowired
    private MpSendMsgService mpSendMsgService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MsgJobService msgJobService;

    public boolean sendMpMsg(MsgMpSendRecord info) {
        if (info.getTim() != null && info.getTim().booleanValue()) {
            for (String toUser : info.getToUser().split(",")) {
                info.setToUser(toUser);
                String msgId = IdUtil.fastSimpleUuid();
                info.setMsgId(msgId);
                this.msgJobService.saveMsgJob(info.getJobTime(), JSONObject.toJSONString((Object)info), MsgJobEnum.MSG_MP);
                Date now = new Date();
                info.setId(msgId);
                info.setCreateTime(now);
                info.setSendTime(info.getJobTime());
                info.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
                this.msgMpSendRecordRepository.save(info);
            }
            return true;
        }
        return this.sendMsg(info);
    }

    public boolean testSendMpMsg(MpSendMsgCreateDto createDto) {
        MsgMpChannel channel = this.getMpChannel(createDto.getChannelId(), createDto.getChannelNo());
        MsgMpTemplate template = this.getMpTemplate(createDto.getTemplateId(), createDto.getTemplateNo());
        MsgMpSendRecord info = new MsgMpSendRecord();
        info.setChannelId(channel.getId());
        info.setChannelNo(channel.getChannelNo());
        info.setChannelName(channel.getChannelName());
        info.setKeyId(channel.getKeyId());
        info.setKeySecret(channel.getKeySecret());
        info.setTemplateId(template.getId());
        info.setTemplateNo(template.getTemplateNo());
        info.setTemplateName(template.getTemplateName());
        info.setTemplateBizId(template.getTemplateBizId());
        info.setToUser(createDto.getToUser());
        info.setUrl(createDto.getUrl());
        info.setContent(JSONObject.toJSONString((Object)createDto.getData()));
        info.setStatus(SendStatusEnum.SENDING.getCode());
        info.setTim(createDto.getTim());
        info.setJobTime(createDto.getJobTime());
        info.setAppId(AppEnum.TEST.getAppId());
        info.setAppName(AppEnum.TEST.getAppName());
        info.setAppSecret(AppEnum.TEST.getAppSecret());
        info.setSceneCode(AppEnum.TEST.getSceneCode());
        info.setSceneName(AppEnum.TEST.getSceneName());
        return this.sendMpMsg(info);
    }

    public boolean jobMsg(MsgMpSendRecord info) {
        this.sendMsg(info);
        Optional optional = this.msgMpSendRecordRepository.findById(info.getMsgId());
        MsgMpSendRecord entity = optional.orElse(new MsgMpSendRecord());
        if (HussarUtils.isNotEmpty((Object)entity.getId())) {
            entity.setStatus(info.getStatus());
            entity.setErrMsg(info.getErrMsg());
            this.msgMpSendRecordRepository.save(entity);
        }
        return true;
    }

    private boolean sendMsg(MsgMpSendRecord info) {
        boolean flag = true;
        for (String toUser : info.getToUser().split(",")) {
            info.setToUser(toUser);
            Integer status = SendStatusEnum.SUCCESS.getCode();
            info.setErrMsg(null);
            WxMpSendMsgReqDtoDto mpConfig = new WxMpSendMsgReqDtoDto();
            mpConfig.setToUser(toUser);
            mpConfig.setTemplateId(info.getTemplateBizId());
            mpConfig.setUrl(info.getUrl());
            mpConfig.setData(JSONArray.parseArray((String)info.getContent(), WxMpTemplateData.class));
            mpConfig.setAppId(info.getKeyId());
            mpConfig.setSecret(info.getKeySecret());
            try {
                this.mpSendMsgService.sendTemplateMsg(mpConfig);
            }
            catch (Exception e) {
                logger.error("\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
                status = SendStatusEnum.FAIL.getCode();
                info.setErrMsg(e.getMessage());
                flag = false;
            }
            info.setStatus(status);
            if (!HussarUtils.isEmpty((Object)info.getMsgId())) continue;
            String msgId = IdUtil.fastSimpleUuid();
            Date now = new Date();
            info.setId(msgId);
            info.setCreateTime(now);
            Date sendTime = new Date();
            info.setSendTime(sendTime);
            info.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.msgMpSendRecordRepository.save(info);
        }
        return flag;
    }

    private MsgMpChannel getMpChannel(Long channelId, String channelNo) {
        MsgMpChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(MsgMpChannel::getId, (Object)channelId);
        }
        if (HussarUtils.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(MsgMpChannel::getChannelNo, (Object)channelNo);
        }
        if ((channel = (MsgMpChannel)this.mpChannelService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }

    private MsgMpTemplate getMpTemplate(Long templateId, String templateNo) {
        MsgMpTemplate template;
        QueryWrapper qw = new QueryWrapper();
        if (templateId != null) {
            qw.lambda().eq(MsgMpTemplate::getId, (Object)templateId);
        }
        if (HussarUtils.isNotEmpty((Object)templateNo)) {
            qw.lambda().eq(MsgMpTemplate::getTemplateNo, (Object)templateNo);
        }
        if ((template = (MsgMpTemplate)this.mpTemplateService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677f");
        }
        if (template.getStatus() == null || !template.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u6a21\u677f\u672a\u542f\u7528");
        }
        QueryWrapper qw1 = new QueryWrapper();
        qw1.lambda().eq(MsgMpChannel::getId, (Object)template.getChannelId());
        qw1.lambda().eq(MsgMpChannel::getStatus, (Object)1);
        long count = this.mpChannelService.count((Wrapper)qw1);
        if (count == 0L) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        return template;
    }

    public IPage<MsgMpSendRecord> listPage(Page pageable, MpSendRecordPageDto pageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)pageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (pageDto.getToUser() != null) {
            criteria.and("toUser").is((Object)pageDto.getToUser());
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getAppName())) {
            criteria.and("appName").regex(Strings.format("%s%s%s", ".*", pageDto.getAppName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelName())) {
            criteria.and("channelName").regex(Strings.format("%s%s%s", ".*", pageDto.getChannelName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelNo())) {
            criteria.and("channelNo").regex(Strings.format("%s%s%s", ".*", pageDto.getChannelNo(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getTemplateNo())) {
            criteria.and("templateNo").regex(Strings.format("%s%s%s", ".*", pageDto.getTemplateNo(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getTemplateName())) {
            criteria.and("templateName").regex(Strings.format("%s%s%s", ".*", pageDto.getTemplateName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format("%s%s%s", ".*", pageDto.getSceneCode(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format("%s%s%s", ".*", pageDto.getSceneName(), ".*"));
        }
        if (pageDto.getStatus() != null) {
            criteria.and("status").is((Object)pageDto.getStatus());
        }
        if (pageDto.getContent() != null) {
            String reges = Strings.format("%s%s%s", "^.*", pageDto.getContent().trim(), ".*$");
            Pattern pattern = Pattern.compile(reges, 2);
            criteria.and("content").regex(pattern);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, MsgMpSendRecord.class);
        query.skip((pageable.getCurrent() - 1L) * pageable.getSize());
        query.limit((int)pageable.getSize());
        List list = this.mongoTemplate.find(query, MsgMpSendRecord.class);
        Page page = new Page();
        page.setCurrent(pageable.getCurrent());
        page.setSize(pageable.getSize());
        page.setTotal(total);
        page.setRecords(list);
        return page;
    }

    public MpSendRecordQueryVo findById(String id) {
        Optional entity = this.msgMpSendRecordRepository.findById(id);
        return entity.map(this::entity2QueryVo).orElse(null);
    }

    public List<ChannelsVo> getAllChannels() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"channelNo", "channelName"})});
        return this.mongoTemplate.aggregate(agg, MsgMpSendRecord.class, ChannelsVo.class).getMappedResults();
    }

    public List<MpChannelSendStatisticsVo> sendStatistics(MpSendRecordPageDto pageDto) {
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)pageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)pageDto.getChannelNo());
        }
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createDate", "status", "channelName"}).count().as("count")});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, MsgMpSendRecord.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDate).distinct().sorted().collect(Collectors.toList());
        ArrayList<MpChannelSendStatisticsVo> result = new ArrayList<MpChannelSendStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            MpChannelSendStatisticsVo statisticsVo = new MpChannelSendStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName(HussarUtils.isNotEmpty((Object)aggs) ? ((SendRecordAgg)aggs.get(0)).getChannelName() : null);
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createDate, aggs1) -> {
                MpChannelSendStatisticsVo.MpChannelSendStatisticAgg aggVo = new MpChannelSendStatisticsVo.MpChannelSendStatisticAgg();
                aggVo.setSendDate(createDate);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    private MpSendRecordQueryVo entity2QueryVo(MsgMpSendRecord entity) {
        MpSendRecordQueryVo vo = new MpSendRecordQueryVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        return vo;
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String channelName;
        private String createDate;
        private Integer status;
        private Long count;

        public String getChannelNo() {
            return this.channelNo;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }
    }
}

