/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.constant.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.mp.dao.MsgMpChannelMapper;
import com.jxdinfo.hussar.msg.mp.dto.MpChannelCreateDto;
import com.jxdinfo.hussar.msg.mp.dto.MpChannelPageDto;
import com.jxdinfo.hussar.msg.mp.dto.MpChannelQueryVo;
import com.jxdinfo.hussar.msg.mp.dto.MpChannelUpdateDto;
import com.jxdinfo.hussar.msg.mp.model.MsgMpChannel;
import com.jxdinfo.hussar.msg.mp.model.MsgMpTemplate;
import com.jxdinfo.hussar.msg.mp.service.MpChannelService;
import com.jxdinfo.hussar.msg.mp.service.MpTemplateService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MpChannelServiceImpl
extends HussarServiceImpl<MsgMpChannelMapper, MsgMpChannel>
implements MpChannelService {
    @Autowired
    private MpTemplateService mpTemplateService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<MsgMpChannel> listPage(Page page, MpChannelPageDto pageDto) {
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelName())) {
            pageDto.setChannelName(pageDto.getChannelName().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelNo())) {
            pageDto.setChannelNo(pageDto.getChannelNo().trim());
        }
        IPage<MsgMpChannel> pageList = ((MsgMpChannelMapper)this.baseMapper).queryPage(page, pageDto);
        return pageList;
    }

    public List<MpChannelQueryVo> queryList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgMpChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public MpChannelQueryVo findById(Long id) {
        MsgMpChannel entity = (MsgMpChannel)super.getById((Serializable)id);
        return this.entity2QueryVo(entity);
    }

    public boolean save(MpChannelCreateDto createDto) {
        MsgMpChannel entity = new MsgMpChannel();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        entity.setChannelNo(BizCodeUtils.generalBizCode(BizCodeEnum.MP_CHANNEL));
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(entity))) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + entity.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.save((BaseEntity)entity);
    }

    public boolean updateById(MpChannelUpdateDto updateDto) {
        MsgMpChannel entity = new MsgMpChannel();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(entity))) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + entity.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.updateById((BaseEntity)entity);
    }

    public boolean delete(Long id) {
        MsgMpChannel msgMpChannel = (MsgMpChannel)((MsgMpChannelMapper)this.baseMapper).selectById(id);
        if (this.appSceneConfigService.isExistScene(msgMpChannel.getChannelNo())) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgMpTemplate::getChannelId, (Object)msgMpChannel.getId());
        long count = this.mpTemplateService.count((Wrapper)qw);
        if (count > 0L) {
            throw new HussarException("\u8be5\u901a\u9053\u4e0b\u5b58\u5728\u6a21\u677f,\u8bf7\u5148\u5220\u9664\u6a21\u677f");
        }
        return super.removeById((Serializable)id);
    }

    public boolean deleteChannelByIds(Long[] ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(Arrays.asList(ids)).stream().map(MsgMpChannel::getChannelNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        for (Long id : ids) {
            MsgMpChannel msgMpChannel = (MsgMpChannel)((MsgMpChannelMapper)this.baseMapper).selectById(id);
            QueryWrapper qw = new QueryWrapper();
            qw.lambda().eq(MsgMpTemplate::getChannelId, (Object)msgMpChannel.getId());
            long count = this.mpTemplateService.count((Wrapper)qw);
            if (count <= 0L) continue;
            throw new HussarException("\u5220\u9664\u5931\u8d25! '" + msgMpChannel.getChannelName() + "'\u901a\u9053\u4e0b\u5b58\u5728\u6a21\u677f,\u8bf7\u5148\u5220\u9664\u6a21\u677f");
        }
        return super.removeByIds(Arrays.asList(ids));
    }

    public List<MpChannelQueryVo> getChannelList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgMpChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgMpChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public MsgMpChannel getChannelInfo(String channelNo) {
        return ((MsgMpChannelMapper)this.baseMapper).getChannelInfo(channelNo);
    }

    private MpChannelQueryVo entity2QueryVo(MsgMpChannel entity) {
        MpChannelQueryVo vo = new MpChannelQueryVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        return vo;
    }

    private String checkChannelUnique(MsgMpChannel entity) {
        Long id = HussarUtils.isEmpty((Object)entity.getId()) ? -1L : entity.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgMpChannel::getChannelName, (Object)entity.getChannelName());
        MsgMpChannel info = (MsgMpChannel)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)info) && !HussarUtils.equals((Object)info.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

