/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.utils;

import com.jxdinfo.hussar.msg.mail.mongodb.document.MailSendRecord;
import com.jxdinfo.hussar.msg.mail.utils.MailConst;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailSendUtils {
    public static void messageSend(MailSendRecord record, List<AttachmentManagerModel> attachmentModels) throws Exception {
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", MailConst.getMailProtocol(record.getMailProtocol()));
        props.setProperty("mail.smtp.host", record.getMailServerAddress());
        props.setProperty("mail.smtp.auth", "true");
        if (HussarUtils.isNotEmpty((Object)record.getSafeType())) {
            props.setProperty("mail.smtp.port", record.getMailPort());
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.socketFactory.port", record.getMailPort());
        }
        Session session = Session.getInstance((Properties)props);
        session.setDebug(true);
        MimeMessage message = MailSendUtils.createMimeMessage(session, record, attachmentModels);
        Transport transport = session.getTransport();
        transport.connect(record.getMailAddress(), record.getMailPassword());
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    private static MimeMessage createMimeMessage(Session session, MailSendRecord record, List<AttachmentManagerModel> attachmentModels) throws Exception {
        String mailSubject;
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(record.getMailAddress(), record.getSenderName(), "UTF-8"));
        String[] receiveMails = record.getReciverMail().split(";");
        String[] receiveMailNames = record.getReciverName().split(";");
        for (int i = 0; i < receiveMails.length; ++i) {
            message.addRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(receiveMails[i], receiveMailNames[i], "UTF-8"));
        }
        if (!HussarUtils.isEmpty((Object)record.getCc())) {
            String[] ccs = record.getCc().split(";");
            for (int i = 0; i < ccs.length; ++i) {
                message.addRecipient(MimeMessage.RecipientType.CC, (Address)new InternetAddress(ccs[i], ccs[i], "UTF-8"));
            }
        }
        if (HussarUtils.isEmpty((Object)(mailSubject = record.getMailSubject()))) {
            mailSubject = "\u65e0\u4e3b\u9898";
        }
        message.setSubject(mailSubject, "UTF-8");
        MimeMultipart mm = new MimeMultipart();
        MimeBodyPart text = new MimeBodyPart();
        text.setContent((Object)record.getMailContent(), "text/html;charset=UTF-8");
        mm.addBodyPart((BodyPart)text);
        if (HussarUtils.isNotEmpty(attachmentModels)) {
            for (AttachmentManagerModel attach : attachmentModels) {
                Long id = attach.getId();
                String fileName = attach.getAttachmentName();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                String path = attach.getAttachmentDir() + id + suffix;
                MimeBodyPart attachment = new MimeBodyPart();
                DataHandler dh2 = new DataHandler((DataSource)new FileDataSource(path));
                attachment.setDataHandler(dh2);
                attachment.setFileName(MimeUtility.encodeText((String)fileName));
                mm.addBodyPart((BodyPart)attachment);
            }
        }
        mm.setSubType("mixed");
        message.setContent((Multipart)mm);
        message.setSentDate(new Date());
        message.saveChanges();
        return message;
    }
}

