/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.utils;

import com.jxdinfo.hussar.msg.mail.mongodb.document.MailSendRecord;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import microsoft.exchange.webservices.data.property.complex.MessageBody;

public class ExchangeClient {
    private final String hostname;
    private final ExchangeVersion exchangeVersion;
    private final String domain;
    private final String username;
    private final String password;
    private final String subject;
    private final List<String> recipientTo;
    private final List<String> recipientCc;
    private final List<String> recipientBcc;
    private final List<String> attachments;
    private final String message;

    private ExchangeClient(ExchangeClientBuilder builder) {
        this.hostname = builder.hostname;
        this.exchangeVersion = builder.exchangeVersion;
        this.domain = builder.domain;
        this.username = builder.username;
        this.password = builder.password;
        this.subject = builder.subject;
        this.recipientTo = builder.recipientTo;
        this.recipientCc = builder.recipientCc;
        this.recipientBcc = builder.recipientBcc;
        this.attachments = builder.attachments;
        this.message = builder.message;
    }

    public boolean sendExchange() throws Exception {
        ExchangeService exchangeService = new ExchangeService(this.exchangeVersion);
        WebCredentials exchangeCredentials = new WebCredentials(this.username, this.password, this.domain);
        exchangeService.setCredentials((ExchangeCredentials)exchangeCredentials);
        exchangeService.setUrl(new URI(this.hostname));
        EmailMessage emailMessage = new EmailMessage(exchangeService);
        emailMessage.setSubject(this.subject);
        emailMessage.setBody(MessageBody.getMessageBodyFromText((String)this.message));
        for (String toPerson : this.recipientTo) {
            emailMessage.getToRecipients().add(toPerson);
        }
        for (String recipient : this.recipientCc) {
            emailMessage.getCcRecipients().add(recipient);
        }
        for (String recipient : this.recipientBcc) {
            emailMessage.getBccRecipients().add(recipient);
        }
        for (String attachmentPath : this.attachments) {
            emailMessage.getAttachments().addFileAttachment(attachmentPath);
        }
        emailMessage.send();
        return true;
    }

    public static void messageSend(MailSendRecord record, List<AttachmentManagerModel> attachmentModels) throws Exception {
        List<String> recipientTo = Arrays.asList(record.getReciverMail().split(";"));
        ExchangeClientBuilder clientBuilder = new ExchangeClientBuilder();
        clientBuilder.hostname(record.getMailServerAddress());
        clientBuilder.exchangeVersion(ExchangeVersion.Exchange2010_SP1);
        clientBuilder.username(record.getMailAddress());
        clientBuilder.password(record.getMailPassword());
        clientBuilder.subject(record.getMailSubject());
        clientBuilder.recipientTo(recipientTo);
        clientBuilder.message(record.getMailContent());
        if (record.getCc() != null) {
            clientBuilder.recipientCc(record.getCc(), new String[0]);
        }
        if (!attachmentModels.isEmpty()) {
            List<String> attachments = attachmentModels.stream().map(AttachmentManagerModel::getAttachmentDir).collect(Collectors.toList());
            clientBuilder.attachments(attachments);
        }
        clientBuilder.build().sendExchange();
    }

    public static class ExchangeClientBuilder {
        private String hostname = "";
        private ExchangeVersion exchangeVersion = ExchangeVersion.Exchange2010_SP1;
        private String domain;
        private String username = "";
        private String password = "";
        private String subject = "";
        private List<String> recipientTo = new ArrayList<String>(0);
        private List<String> recipientCc = new ArrayList<String>(0);
        private List<String> recipientBcc = new ArrayList<String>(0);
        private List<String> attachments = new ArrayList<String>(0);
        private String message = "";

        public ExchangeClientBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public ExchangeClientBuilder exchangeVersion(ExchangeVersion exchangeVersion) {
            this.exchangeVersion = exchangeVersion;
            return this;
        }

        public ExchangeClientBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public ExchangeClientBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ExchangeClientBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ExchangeClientBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public ExchangeClientBuilder recipientTo(List<String> recipientTo) {
            this.recipientTo = recipientTo;
            return this;
        }

        public ExchangeClientBuilder recipientCc(String recipientCc, String ... recipientsCc) {
            ArrayList<String> recipients = new ArrayList<String>(1 + recipientsCc.length);
            recipients.add(recipientCc);
            recipients.addAll(Arrays.asList(recipientsCc));
            this.recipientCc = recipients;
            return this;
        }

        public ExchangeClientBuilder recipientCc(List<String> recipientCc) {
            this.recipientCc = recipientCc;
            return this;
        }

        public ExchangeClientBuilder recipientBcc(String recipientBcc, String ... recipientsBcc) {
            ArrayList<String> recipients = new ArrayList<String>(1 + recipientsBcc.length);
            recipients.add(recipientBcc);
            recipients.addAll(Arrays.asList(recipientsBcc));
            this.recipientBcc = recipients;
            return this;
        }

        public ExchangeClientBuilder recipientBcc(List<String> recipientBcc) {
            this.recipientBcc = recipientBcc;
            return this;
        }

        public ExchangeClientBuilder attachments(String attachment, String ... attachments) {
            ArrayList<String> attachmentsToUse = new ArrayList<String>(1 + attachments.length);
            attachmentsToUse.add(attachment);
            attachmentsToUse.addAll(Arrays.asList(attachments));
            this.attachments = attachmentsToUse;
            return this;
        }

        public ExchangeClientBuilder attachments(List<String> attachments) {
            this.attachments = attachments;
            return this;
        }

        public ExchangeClientBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ExchangeClient build() {
            return new ExchangeClient(this);
        }
    }
}

