/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.thrid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.msg.constant.enums.MailProtocolEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.IdUtil;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.msg.mail.config.mongodb.repository.MailSendRecordRepository;
import com.jxdinfo.hussar.msg.mail.mongodb.document.MailSendRecord;
import com.jxdinfo.hussar.msg.mail.third.service.MailPushService;
import com.jxdinfo.hussar.msg.mail.utils.ExchangeClient;
import com.jxdinfo.hussar.msg.mail.utils.MailSendUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MailPushServiceImpl
implements MailPushService {
    private static final Logger logger = LoggerFactory.getLogger(MailPushServiceImpl.class);
    @Autowired
    private AttachmentManagerService attachmentManagerService;
    @Autowired
    private MailSendRecordRepository mailSendRecordRepository;
    @Autowired
    private MsgJobService msgJobService;

    public boolean send(MailSendRecord record) {
        String msgId = IdUtil.fastSimpleUuid();
        Date now = new Date();
        Date sendTime = new Date();
        if (record.getTim() != null && record.getTim().booleanValue()) {
            sendTime = record.getJobTime();
            record.setId(msgId);
            this.msgJobService.saveMsgJob(record.getJobTime(), JSONObject.toJSONString((Object)record), MsgJobEnum.MSG_MAIL);
            record.setStatus(SendStatusEnum.SENDING.getCode());
        } else {
            this.sendMail(record);
        }
        record.setId(msgId);
        record.setSendTime(sendTime);
        record.setCreateTime(now);
        record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        this.mailSendRecordRepository.save(record);
        return !SendStatusEnum.FAIL.getCode().equals(record.getStatus());
    }

    public void jobSend(MailSendRecord record) {
        Optional optional = this.mailSendRecordRepository.findById(record.getId());
        MailSendRecord mailSendRecord = optional.orElse(new MailSendRecord());
        if (ToolUtil.isNotEmpty((Object)mailSendRecord.getId())) {
            this.sendMail(mailSendRecord);
            mailSendRecord.setSendTime(new Date());
            this.mailSendRecordRepository.save(mailSendRecord);
        }
    }

    public boolean bathSend(MailSendRecord record) {
        String msgId = IdUtil.fastSimpleUuid();
        Date now = new Date();
        Date sendTime = new Date();
        if (record.getTim() != null && record.getTim().booleanValue()) {
            sendTime = record.getJobTime();
            record.setId(msgId);
            this.msgJobService.saveMsgJob(record.getJobTime(), JSONObject.toJSONString((Object)record), MsgJobEnum.MSG_MAIL_BATH);
            record.setStatus(SendStatusEnum.SENDING.getCode());
        } else {
            this.sendMail(record);
        }
        record.setId(msgId);
        record.setSendTime(sendTime);
        record.setCreateTime(now);
        record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        this.mailSendRecordRepository.save(record);
        return !SendStatusEnum.FAIL.getCode().equals(record.getStatus());
    }

    public void jobBathSend(MailSendRecord record) {
        Optional optional = this.mailSendRecordRepository.findById(record.getId());
        MailSendRecord entity = optional.orElse(new MailSendRecord());
        entity.setSendTime(new Date());
        this.sendMail(entity);
        this.mailSendRecordRepository.save(entity);
    }

    private void sendMail(MailSendRecord record) {
        try {
            List<AttachmentManagerModel> attachmentManagerModels = this.getAttachmentModels(record.getFileIds());
            if (record.getMailProtocol().equals(MailProtocolEnum.SMTP.getCode())) {
                MailSendUtils.messageSend(record, attachmentManagerModels);
            } else {
                ExchangeClient.messageSend(record, attachmentManagerModels);
            }
            record.setStatus(SendStatusEnum.SUCCESS.getCode());
        }
        catch (Exception e) {
            logger.error("\u90ae\u4ef6\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            record.setStatus(SendStatusEnum.FAIL.getCode());
            record.setErrMsg(e.getMessage());
        }
    }

    private List<AttachmentManagerModel> getAttachmentModels(String ids) {
        ArrayList<AttachmentManagerModel> attachmentManagerModels = new ArrayList<AttachmentManagerModel>();
        if (ToolUtil.isEmpty((Object)ids)) {
            return attachmentManagerModels;
        }
        List<String> fileIdList = Arrays.asList(ids.split(","));
        return this.attachmentManagerService.listByIds((Collection)fileIdList.stream().map(Long::valueOf).collect(Collectors.toList()));
    }
}

