/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.constant.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.mail.dao.MsgMailTemplateMapper;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailTemplateCreateDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailTemplatePageDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailTemplateQueryVo;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailTemplateUpdateDto;
import com.jxdinfo.hussar.msg.mail.model.MsgMailTemplate;
import com.jxdinfo.hussar.msg.mail.service.MsgMailTemplateService;
import com.jxdinfo.hussar.msg.mail.utils.TemplateUtils;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MsgMailTemplateServiceImpl
extends HussarServiceImpl<MsgMailTemplateMapper, MsgMailTemplate>
implements MsgMailTemplateService {
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<MsgMailTemplate> listPage(Page page, MsgMailTemplatePageDto pageDto) {
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getTemplateContent())) {
            pageDto.setTemplateContent(pageDto.getTemplateContent().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getTemplateName())) {
            pageDto.setTemplateName(pageDto.getTemplateName().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getTemplateNo())) {
            pageDto.setTemplateNo(pageDto.getTemplateNo().trim());
        }
        IPage<MsgMailTemplate> pageList = ((MsgMailTemplateMapper)this.baseMapper).queryPage(page, pageDto);
        for (MsgMailTemplate msgMailTemplate : pageList.getRecords()) {
            String parmas = TemplateUtils.getTemplateParams(msgMailTemplate.getTemplateContent());
            msgMailTemplate.setTemplateParams(parmas);
        }
        return pageList;
    }

    public List<MsgMailTemplateQueryVo> queryList(MsgMailTemplatePageDto pageDto) {
        QueryWrapper qw = new QueryWrapper();
        List list = ((MsgMailTemplateMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public MsgMailTemplateQueryVo findById(Long id) {
        MsgMailTemplate entity = (MsgMailTemplate)super.getById((Serializable)id);
        return this.entity2QueryVo(entity);
    }

    public boolean save(MsgMailTemplateCreateDto createDto) {
        MsgMailTemplate entity = new MsgMailTemplate();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        entity.setTemplateNo(BizCodeUtils.generalBizCode(BizCodeEnum.MAIL_TEMPLATE));
        if (HussarUtils.equals((Object)"1", (Object)this.checkTemplateUnique(entity))) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0'" + entity.getTemplateName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        String params = TemplateUtils.getTemplateParams(entity.getTemplateContent());
        entity.setTemplateParams(params);
        return super.save((BaseEntity)entity);
    }

    public boolean updateById(MsgMailTemplateUpdateDto updateDto) {
        MsgMailTemplate entity = new MsgMailTemplate();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        if (HussarUtils.equals((Object)"1", (Object)this.checkTemplateUnique(entity))) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0'" + entity.getTemplateName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        String params = TemplateUtils.getTemplateParams(entity.getTemplateContent());
        entity.setTemplateParams(params);
        return super.updateById((BaseEntity)entity);
    }

    public boolean delete(Long id) {
        if (this.appSceneConfigService.isExistScene(((MsgMailTemplate)super.getById((Serializable)id)).getTemplateNo())) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        return super.removeById((Serializable)id);
    }

    public boolean deleteTemplateByIds(Long[] ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(Arrays.asList(ids)).stream().map(MsgMailTemplate::getTemplateNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        return super.removeByIds(Arrays.asList(ids));
    }

    public List<MsgMailTemplateQueryVo> getTemplateList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgMailTemplate::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgMailTemplateMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    private MsgMailTemplateQueryVo entity2QueryVo(MsgMailTemplate entity) {
        MsgMailTemplateQueryVo vo = new MsgMailTemplateQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }

    private String checkTemplateUnique(MsgMailTemplate entity) {
        Long id = HussarUtils.isEmpty((Object)entity.getId()) ? -1L : entity.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgMailTemplate::getTemplateName, (Object)entity.getTemplateName());
        MsgMailTemplate info = (MsgMailTemplate)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)info) && !HussarUtils.equals((Object)info.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

