/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.constant.enums.AppEnum;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.QueueEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailSendDto;
import com.jxdinfo.hussar.msg.mail.model.MsgMailChannel;
import com.jxdinfo.hussar.msg.mail.model.MsgMailReciver;
import com.jxdinfo.hussar.msg.mail.model.MsgMailTemplate;
import com.jxdinfo.hussar.msg.mail.mongodb.document.MailSendRecord;
import com.jxdinfo.hussar.msg.mail.service.MsgMailChannelService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailReciverService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailSendService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailTemplateService;
import com.jxdinfo.hussar.msg.mail.third.service.MailPushService;
import com.jxdinfo.hussar.msg.mail.utils.TemplateUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MsgMailSendServiceImpl
implements MsgMailSendService {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private MailPushService mailPushService;
    @Autowired
    private MsgMailChannelService mailChannelService;
    @Autowired
    private MsgMailTemplateService msgMailTemplateService;
    @Autowired
    private MsgMailReciverService msgMailReciverService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public boolean send(MsgMailSendDto msgMailSendDto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(msgMailSendDto.getAppId(), msgMailSendDto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(msgMailSendDto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.MAIL.getCode());
        msgMailSendDto.setChannelNo(configJsonData.getChannelNo());
        msgMailSendDto.setTemplateNo(configJsonData.getTemplateNo());
        this.checkBeforSend(msgMailSendDto);
        this.replaceContent(msgMailSendDto);
        msgMailSendDto.setBath(Boolean.FALSE);
        MailSendRecord record = this.entity2MonDbRecordVo(msgMailSendDto);
        MsgMailChannel mailChannel = this.getMailChannel(msgMailSendDto.getChannelId(), msgMailSendDto.getChannelNo());
        if (ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateId()) || ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateNo())) {
            MsgMailTemplate mailTemplate = this.getMailTemplate(msgMailSendDto.getTemplateId(), msgMailSendDto.getTemplateNo());
            record.setMailTemplateId(mailTemplate.getId());
            record.setTemplateNo(mailTemplate.getTemplateNo());
            record.setTemplateName(mailTemplate.getTemplateName());
        }
        record.setChannelId(mailChannel.getId());
        record.setChannelNo(mailChannel.getChannelNo());
        record.setChannelName(mailChannel.getChannelName());
        record.setMailAddress(mailChannel.getMailAddress());
        record.setMailProtocol(mailChannel.getMailProtocol());
        record.setMailPassword(mailChannel.getMailPassword());
        record.setSenderName(mailChannel.getSenderName());
        record.setMailServerAddress(mailChannel.getMailServerAddress());
        record.setMailPort(mailChannel.getMailPort());
        record.setSafeType(mailChannel.getSafeType());
        record.setFileIds(msgMailSendDto.getFileIds());
        record.setTim(msgMailSendDto.getTim());
        record.setJobTime(msgMailSendDto.getJobTime());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(msgMailSendDto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(msgMailSendDto.getAppSecret());
        record.setSceneCode(msgMailSendDto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        String s = JSON.toJSONString((Object)record);
        Message message = new Message(s.getBytes(), new MessageProperties());
        this.rabbitTemplate.convertAndSend(QueueEnum.QUEUE_MSG_MAIL.getExchange(), QueueEnum.QUEUE_MSG_MAIL.getRouteKey(), (Object)message);
        return true;
    }

    public boolean sendTest(MsgMailSendDto msgMailSendDto) {
        this.checkBeforSend(msgMailSendDto);
        this.replaceContent(msgMailSendDto);
        msgMailSendDto.setBath(Boolean.FALSE);
        MailSendRecord record = this.entity2MonDbRecordVo(msgMailSendDto);
        MsgMailChannel mailChannel = this.getMailChannel(msgMailSendDto.getChannelId(), msgMailSendDto.getChannelNo());
        if (ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateId()) || ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateNo())) {
            MsgMailTemplate mailTemplate = this.getMailTemplate(msgMailSendDto.getTemplateId(), msgMailSendDto.getTemplateNo());
            record.setMailTemplateId(mailTemplate.getId());
            record.setTemplateNo(mailTemplate.getTemplateNo());
            record.setTemplateName(mailTemplate.getTemplateName());
        }
        record.setChannelId(mailChannel.getId());
        record.setChannelNo(mailChannel.getChannelNo());
        record.setChannelName(mailChannel.getChannelName());
        record.setMailAddress(mailChannel.getMailAddress());
        record.setMailProtocol(mailChannel.getMailProtocol());
        record.setMailPassword(mailChannel.getMailPassword());
        record.setSenderName(mailChannel.getSenderName());
        record.setMailServerAddress(mailChannel.getMailServerAddress());
        record.setMailPort(mailChannel.getMailPort());
        record.setSafeType(mailChannel.getSafeType());
        record.setFileIds(msgMailSendDto.getFileIds());
        record.setTim(msgMailSendDto.getTim());
        record.setJobTime(msgMailSendDto.getJobTime());
        record.setAppId(AppEnum.TEST.getAppId());
        record.setAppName(AppEnum.TEST.getAppName());
        record.setAppSecret(AppEnum.TEST.getAppSecret());
        record.setSceneName(AppEnum.TEST.getSceneName());
        record.setSceneCode(AppEnum.TEST.getSceneCode());
        return this.mailPushService.send(record);
    }

    public boolean batchSend(MsgMailSendDto msgMailSendDto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(msgMailSendDto.getAppId(), msgMailSendDto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(msgMailSendDto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.MAIL.getCode());
        msgMailSendDto.setChannelNo(configJsonData.getChannelNo());
        msgMailSendDto.setTemplateNo(configJsonData.getTemplateNo());
        this.checkBeforSend(msgMailSendDto);
        this.replaceContent(msgMailSendDto);
        msgMailSendDto.setBath(Boolean.TRUE);
        MailSendRecord record = this.entity2MonDbRecordVo(msgMailSendDto);
        MsgMailChannel mailChannel = this.getMailChannel(msgMailSendDto.getChannelId(), msgMailSendDto.getChannelNo());
        if (ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateId()) || ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateNo())) {
            MsgMailTemplate mailTemplate = this.getMailTemplate(msgMailSendDto.getTemplateId(), msgMailSendDto.getTemplateNo());
            record.setMailTemplateId(mailTemplate.getId());
            record.setTemplateNo(mailTemplate.getTemplateNo());
            record.setTemplateName(mailTemplate.getTemplateName());
        }
        record.setChannelId(mailChannel.getId());
        record.setChannelNo(mailChannel.getChannelNo());
        record.setChannelName(mailChannel.getChannelName());
        record.setMailAddress(mailChannel.getMailAddress());
        record.setMailProtocol(mailChannel.getMailProtocol());
        record.setMailPassword(mailChannel.getMailPassword());
        record.setSenderName(mailChannel.getSenderName());
        record.setMailServerAddress(mailChannel.getMailServerAddress());
        record.setMailPort(mailChannel.getMailPort());
        record.setSafeType(mailChannel.getSafeType());
        record.setFileIds(msgMailSendDto.getFileIds());
        record.setGropuIds(msgMailSendDto.getGropuIds());
        record.setTim(msgMailSendDto.getTim());
        record.setJobTime(msgMailSendDto.getJobTime());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(msgMailSendDto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(msgMailSendDto.getAppSecret());
        record.setSceneCode(msgMailSendDto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        this.setRecivers(record);
        String s = JSON.toJSONString((Object)record);
        Message message = new Message(s.getBytes(), new MessageProperties());
        this.rabbitTemplate.convertAndSend(QueueEnum.QUEUE_MSG_MAIL.getExchange(), QueueEnum.QUEUE_MSG_MAIL.getRouteKey(), (Object)message);
        return true;
    }

    public boolean bathSendTest(MsgMailSendDto msgMailSendDto) {
        this.checkBeforSend(msgMailSendDto);
        this.replaceContent(msgMailSendDto);
        msgMailSendDto.setBath(Boolean.TRUE);
        MailSendRecord record = this.entity2MonDbRecordVo(msgMailSendDto);
        MsgMailChannel mailChannel = this.getMailChannel(msgMailSendDto.getChannelId(), msgMailSendDto.getChannelNo());
        if (ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateId()) || ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateNo())) {
            MsgMailTemplate mailTemplate = this.getMailTemplate(msgMailSendDto.getTemplateId(), msgMailSendDto.getTemplateNo());
            record.setMailTemplateId(mailTemplate.getId());
            record.setTemplateNo(mailTemplate.getTemplateNo());
            record.setTemplateName(mailTemplate.getTemplateName());
        }
        record.setChannelId(mailChannel.getId());
        record.setChannelNo(mailChannel.getChannelNo());
        record.setChannelName(mailChannel.getChannelName());
        record.setMailAddress(mailChannel.getMailAddress());
        record.setMailProtocol(mailChannel.getMailProtocol());
        record.setMailPassword(mailChannel.getMailPassword());
        record.setSenderName(mailChannel.getSenderName());
        record.setMailServerAddress(mailChannel.getMailServerAddress());
        record.setMailPort(mailChannel.getMailPort());
        record.setSafeType(mailChannel.getSafeType());
        record.setFileIds(msgMailSendDto.getFileIds());
        record.setGropuIds(msgMailSendDto.getGropuIds());
        record.setTim(msgMailSendDto.getTim());
        record.setJobTime(msgMailSendDto.getJobTime());
        this.setRecivers(record);
        record.setAppId(AppEnum.TEST.getAppId());
        record.setAppName(AppEnum.TEST.getAppName());
        record.setAppSecret(AppEnum.TEST.getAppSecret());
        record.setSceneName(AppEnum.TEST.getSceneName());
        record.setSceneCode(AppEnum.TEST.getSceneCode());
        return this.mailPushService.bathSend(record);
    }

    private void checkBeforSend(MsgMailSendDto msgMailSendDto) {
        if (ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateId()) || ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateNo())) {
            String mailSubject = msgMailSendDto.getMailSubject();
            MsgMailTemplate msgMailTemplate = this.getMailTemplate(msgMailSendDto.getTemplateId(), msgMailSendDto.getTemplateNo());
            String mailContent = msgMailTemplate.getTemplateContent();
            LinkedHashSet<String> params = new LinkedHashSet<String>();
            params.addAll(TemplateUtils.getTemplateParmas(mailSubject));
            params.addAll(TemplateUtils.getTemplateParmas(mailContent));
            Map mailParms = msgMailSendDto.getMailParams();
            for (String str : params) {
                if (mailParms.containsKey(str)) continue;
                throw new HussarException("\u6a21\u677f\u53c2\u6570\uff1a" + str + ",\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\uff01");
            }
        }
    }

    private void replaceContent(MsgMailSendDto msgMailSendDto) {
        if (ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateId()) || ToolUtil.isNotEmpty((Object)msgMailSendDto.getTemplateNo())) {
            MsgMailTemplate msgMailTemplate;
            String mailContent;
            String mailSubject = msgMailSendDto.getMailSubject();
            if (ToolUtil.isNotEmpty((Object)mailSubject) && ToolUtil.isNotEmpty((Object)msgMailSendDto.getMailParams())) {
                for (String key : msgMailSendDto.getMailParams().keySet()) {
                    mailSubject = mailSubject.replaceAll("\\#\\{" + key + "}*\\}", (String)msgMailSendDto.getMailParams().get(key));
                }
                msgMailSendDto.setMailSubject(mailSubject);
            }
            if (ToolUtil.isNotEmpty((Object)(mailContent = (msgMailTemplate = this.getMailTemplate(msgMailSendDto.getTemplateId(), msgMailSendDto.getTemplateNo())).getTemplateContent())) && ToolUtil.isNotEmpty((Object)msgMailSendDto.getMailParams())) {
                for (String key : msgMailSendDto.getMailParams().keySet()) {
                    mailContent = mailContent.replaceAll("\\#\\{" + key + "}*\\}", (String)msgMailSendDto.getMailParams().get(key));
                }
                msgMailSendDto.setMailContent(mailContent);
            }
        }
    }

    private MailSendRecord entity2MonDbRecordVo(MsgMailSendDto entity) {
        MailSendRecord vo = new MailSendRecord();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }

    private void setRecivers(MailSendRecord record) {
        if (!ToolUtil.isEmpty((Object)record.getReciverMail())) {
            return;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"group_id", (Object)record.getGropuIds());
        List recivers = this.msgMailReciverService.list((Wrapper)wrapper);
        if (ToolUtil.isEmpty((Object)recivers)) {
            throw new HussarException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6536\u4ef6\u4eba");
        }
        StringBuilder recivernames = new StringBuilder();
        StringBuilder recivernameEmails = new StringBuilder();
        for (MsgMailReciver reciver : recivers) {
            String reciverName = reciver.getReciverName();
            if (ToolUtil.isEmpty((Object)reciverName)) {
                reciverName = "";
            }
            recivernames.append(reciverName).append(";");
            String reciverMail = reciver.getReciverMail();
            if (ToolUtil.isEmpty((Object)reciverMail)) {
                reciverMail = "";
            }
            recivernameEmails.append(reciverMail).append(";");
        }
        record.setReciverMail(recivernameEmails.substring(0, recivernameEmails.length() - 1));
        record.setReciverName(recivernames.substring(0, recivernames.length() - 1));
    }

    private MsgMailChannel getMailChannel(Long channelId, String channelNo) {
        MsgMailChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(MsgMailChannel::getId, (Object)channelId);
        }
        if (ToolUtil.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(MsgMailChannel::getChannelNo, (Object)channelNo);
        }
        if (ToolUtil.isEmpty((Object)(channel = (MsgMailChannel)this.mailChannelService.getOne((Wrapper)qw)))) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }

    private MsgMailTemplate getMailTemplate(Long templateId, String templateNo) {
        MsgMailTemplate template;
        QueryWrapper qw = new QueryWrapper();
        if (templateId != null) {
            qw.lambda().eq(MsgMailTemplate::getId, (Object)templateId);
        }
        if (ToolUtil.isNotEmpty((Object)templateNo)) {
            qw.lambda().eq(MsgMailTemplate::getTemplateNo, (Object)templateNo);
        }
        if (ToolUtil.isEmpty((Object)(template = (MsgMailTemplate)this.msgMailTemplateService.getOne((Wrapper)qw)))) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677f");
        }
        if (template.getStatus() == null || !template.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u6a21\u677f\u672a\u542f\u7528");
        }
        return template;
    }
}

