/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.Strings;
import com.jxdinfo.hussar.msg.mail.config.mongodb.repository.MailSendRecordRepository;
import com.jxdinfo.hussar.msg.mail.dao.MsgMailSendRecordMapper;
import com.jxdinfo.hussar.msg.mail.dto.MailChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailReciverUpdateDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailSendRecordCreateDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailSendRecordPageDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailSendRecordQueryVo;
import com.jxdinfo.hussar.msg.mail.model.MsgMailSendRecord;
import com.jxdinfo.hussar.msg.mail.mongodb.document.MailSendRecord;
import com.jxdinfo.hussar.msg.mail.service.MsgMailChannelService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailSendRecordService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MsgMailSendRecordServiceImpl
extends HussarServiceImpl<MsgMailSendRecordMapper, MsgMailSendRecord>
implements MsgMailSendRecordService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MsgMailChannelService msgMailChannelService;
    @Autowired
    private MailSendRecordRepository mailSendRecordRepository;

    public IPage<MailSendRecord> listPage(Page page, MsgMailSendRecordPageDto pageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)pageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getAppName())) {
            criteria.and("appName").regex(Strings.format("%s%s%s", ".*", pageDto.getAppName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getReciverName())) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"reciverName").regex(Strings.format("%s%s%s", ".*", pageDto.getReciverName().trim(), ".*")), Criteria.where((String)"reciverMail").regex(Strings.format("%s%s%s", ".*", pageDto.getReciverName().trim(), ".*"))});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getReciverMail())) {
            criteria.and("reciverMail").regex(Strings.format("%s%s%s", ".*", pageDto.getReciverMail(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getMailContent())) {
            criteria.and("mailContent").regex(Strings.format("%s%s%s", ".*", pageDto.getMailContent(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getMailSubject())) {
            criteria.and("mailSubject").regex(Strings.format("%s%s%s", ".*", pageDto.getMailSubject(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format("%s%s%s", ".*", pageDto.getSceneCode(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format("%s%s%s", ".*", pageDto.getSceneName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelName())) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"channelName").regex(Strings.format("%s%s%s", ".*", pageDto.getChannelName(), ".*")), Criteria.where((String)"channelNo").regex(Strings.format("%s%s%s", ".*", pageDto.getChannelName(), ".*"))});
        }
        if (pageDto.getStatus() != null) {
            criteria.and("status").is((Object)pageDto.getStatus());
        }
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, MailSendRecord.class);
        query.skip((page.getCurrent() - 1L) * page.getSize());
        query.limit((int)page.getSize());
        List list = this.mongoTemplate.find(query, MailSendRecord.class);
        list.forEach(e -> e.setReciverMail(Arrays.stream(e.getReciverMail().split(";")).map(o -> o.replaceAll("(\\S{2})\\S*(@)(\\S*)", "$1****$2$3")).collect(Collectors.joining(";"))));
        Page resutlPage = new Page();
        resutlPage.setCurrent(page.getCurrent());
        resutlPage.setSize(page.getSize());
        resutlPage.setTotal(total);
        resutlPage.setRecords(list);
        return resutlPage;
    }

    public List<MsgMailSendRecordQueryVo> queryList(MsgMailSendRecordPageDto pageDto) {
        QueryWrapper qw = new QueryWrapper();
        List list = ((MsgMailSendRecordMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public MailSendRecord findById(String id) {
        Optional entity = this.mailSendRecordRepository.findById(id);
        return (MailSendRecord)entity.get();
    }

    public boolean save(MsgMailSendRecordCreateDto createDto) {
        MsgMailSendRecord entity = new MsgMailSendRecord();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        return super.save((BaseEntity)entity);
    }

    public boolean updateById(MsgMailReciverUpdateDto updateDto) {
        MsgMailSendRecord entity = new MsgMailSendRecord();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        return super.updateById((BaseEntity)entity);
    }

    public boolean delete(Long id) {
        return super.removeById((Serializable)id);
    }

    public List<MailChannelSendStatisticsVo> sendStatistics(MsgMailSendRecordQueryVo queryDto) {
        Criteria criteria = new Criteria();
        if (queryDto.getBeginTime() != null && queryDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)queryDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)queryDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)queryDto.getChannelNo());
        }
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createDate", "status", "channelName"}).count().as("count")});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, MailSendRecord.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDate).distinct().sorted().collect(Collectors.toList());
        ArrayList<MailChannelSendStatisticsVo> result = new ArrayList<MailChannelSendStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            MailChannelSendStatisticsVo statisticsVo = new MailChannelSendStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName(HussarUtils.isNotEmpty((Object)aggs) ? ((SendRecordAgg)aggs.get(0)).getChannelName() : null);
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createDate, aggs1) -> {
                MailChannelSendStatisticsVo.MailChannelSendStatisticAgg aggVo = new MailChannelSendStatisticsVo.MailChannelSendStatisticAgg();
                aggVo.setSendDate(createDate);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    public List<ChannelsVo> getAllChannels() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"channelNo", "channelName"})});
        return this.mongoTemplate.aggregate(agg, MailSendRecord.class, ChannelsVo.class).getMappedResults();
    }

    private MsgMailSendRecordQueryVo entity2QueryVo(MsgMailSendRecord entity) {
        MsgMailSendRecordQueryVo vo = new MsgMailSendRecordQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String channelName;
        private String createDate;
        private Integer status;
        private Long count;

        public String getChannelNo() {
            return this.channelNo;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }
    }
}

