/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.msg.mail.dao.MsgMailGroupMapper;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailGroupCreateDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailGroupPageDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailGroupQueryVo;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailGroupUpdateDto;
import com.jxdinfo.hussar.msg.mail.model.MsgMailGroup;
import com.jxdinfo.hussar.msg.mail.service.MsgMailGroupService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MsgMailGroupServiceImpl
extends HussarServiceImpl<MsgMailGroupMapper, MsgMailGroup>
implements MsgMailGroupService {
    public IPage<MsgMailGroup> listPage(Page page, MsgMailGroupPageDto pageDto) {
        IPage<MsgMailGroup> pageList = ((MsgMailGroupMapper)this.baseMapper).queryPage(page, pageDto);
        return pageList;
    }

    public List<MsgMailGroupQueryVo> getGroupList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgMailGroupMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public MsgMailGroupQueryVo findById(Long id) {
        MsgMailGroup entity = (MsgMailGroup)super.getById((Serializable)id);
        return this.entity2QueryVo(entity);
    }

    public boolean save(MsgMailGroupCreateDto createDto) {
        MsgMailGroup entity = new MsgMailGroup();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgMailGroup::getGroupName, (Object)createDto.getGroupName());
        Long count = ((MsgMailGroupMapper)this.baseMapper).selectCount((Wrapper)qw);
        if (count > 0L) {
            throw new HussarException("\u5206\u7ec4\u540d\u79f0'" + createDto.getGroupName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.save((BaseEntity)entity);
    }

    public boolean updateById(MsgMailGroupUpdateDto updateDto) {
        MsgMailGroup entity = new MsgMailGroup();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        return super.updateById((BaseEntity)entity);
    }

    public boolean delete(Long id) {
        return super.removeById((Serializable)id);
    }

    private MsgMailGroupQueryVo entity2QueryVo(MsgMailGroup entity) {
        MsgMailGroupQueryVo vo = new MsgMailGroupQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }
}

